#include "stdafx.h"

#include <windows.h>
#include <stdlib.h>



struct operatorStruct {
    int multiple;//0..15
    int detune;//-3..0..3
    int totalLevel;//0..127
    int rateScale;//0..3
    int envAttack;//0..31
    int envDecay;//0..31
    int envSustain;//0..31
    int envRelease;//0..15
    int envRelLevel;//0..15
    int envType;//7..15
};



struct instrumentStruct {
    operatorStruct op[4];
    int algo;//0..7
    int feedback;//0..7
};



instrumentStruct ins;


bool is_tag(char *txt,char *tag)
{
	int i,len,ch1,ch2;
	
	len=strlen(tag);
	
	for(i=0;i<len;i++)
	{
		ch1=txt[i];
		ch2=tag[i];
		if(ch1>='A'&&ch1<='Z') ch1+=0x20;
		if(ch2>='A'&&ch2<='Z') ch2+=0x20;
		if(ch1!=ch2) return false;
	}
	
	return true;
}



bool check_ext(const char *txt,char *ext)
{
	return is_tag((char*)txt+strlen(txt)-4,ext);	
}




bool ins_load(instrumentStruct *ins,const char *filename)
{
    FILE *file;
    operatorStruct *op;
    const int opExch[4]={0,2,1,3};
    unsigned char *data;
    int aa,pp,size;
	
	if(!check_ext(filename,".tfi")) return false;
	
    file=fopen(filename,"rb");
    if(!file) return false;
	
    fseek(file,0,SEEK_END);
    size=ftell(file);
    fseek(file,0,SEEK_SET);
	
	if(size!=42)
	{
		fclose(file);
		return false;
	}
	
	data=(unsigned char*)malloc(size);
	fread(data,size,1,file);
	fclose(file);
	
	pp=0;
	ins->algo=data[pp++];
	ins->feedback=data[pp++];
	
	for(aa=0;aa<4;aa++)
	{
		op=&ins->op[aa];
		op->multiple=data[pp++]&0x0f;
		op->detune=(data[pp++]&0x07)-3;
		op->totalLevel=data[pp++]&0x7f;
		op->rateScale=data[pp++]&0x03;
		op->envAttack=data[pp++]&0x1f;
		op->envDecay=data[pp++]&0x1f;
		op->envSustain=data[pp++]&0x1f;
		op->envRelease=data[pp++]&0x0f;
		op->envRelLevel=data[pp++]&0x0f;
		op->envType=data[pp++]&0x0f;
	}
	
    free(data);
    return true;
}



bool ins_save(instrumentStruct *ins,const char *filename)
{
    unsigned char insData[42];
    int aa,pp;
    FILE *file;
	
    pp=0;
    insData[pp++]=ins->algo;
    insData[pp++]=ins->feedback;
	
    for(aa=0;aa<4;aa++)
    {
        insData[pp++]=ins->op[aa].multiple;
        insData[pp++]=ins->op[aa].detune+3;
        insData[pp++]=ins->op[aa].totalLevel;
        insData[pp++]=ins->op[aa].rateScale;
        insData[pp++]=ins->op[aa].envAttack;
        insData[pp++]=ins->op[aa].envDecay;
        insData[pp++]=ins->op[aa].envSustain;
        insData[pp++]=ins->op[aa].envRelease;
        insData[pp++]=ins->op[aa].envRelLevel;
        insData[pp++]=ins->op[aa].envType;
    }
	
    file=fopen(filename,"wb");
    if(file)
    {
        fwrite(insData,pp,1,file);
        fclose(file);
        return true;
    }
    return false;
}



int parse_operator(char *opm,int size,int pp,int opnum)
{
	operatorStruct *op;
	int num,pnum;
	
	pp+=3;
	pnum=0;
	op=&ins.op[opnum];
	
	while(pp<size)
	{
		while(opm[pp]==0x20&&pp<size) pp++;
		
		num=0;
		while(opm[pp]>='0'&&opm[pp]<='9'&&pp<size) num=num*10+opm[pp++]-'0';
		
		switch(pnum)
		{
		case 0://AR
			op->envAttack=num;
			break;
		case 1://D1R
			op->envDecay=num;
			break;
		case 2://D2R
			op->envSustain=num;
			break;
		case 3://RR
			op->envRelease=num;
			break;
		case 4://D1L
			op->envRelLevel=num;
			break;
		case 5://TL
			op->totalLevel=num;
			break;
		case 6://KS
			op->rateScale=num;
			break;
		case 7://MUL
			op->multiple=num;
			break;
		case 8://DT1
			op->detune=num-3;
			break;
		case 9://DT2
			break;
		case 10://AMS-EN
			break;
		}
		pnum++;
		if(pnum>10) break;
	}
	
	return pp;
}



int main(int argc, char* argv[])
{
	const int opord[4]={0,2,1,3};
	operatorStruct *op;
	char insname[1024],filename[MAX_PATH];
	int i,j,pp,pd,chr,size,num,pnum,inscount;
	char *opm;
	FILE *file;
	bool first;
	
	if(argc<2)
	{
		printf("VOPMxTFI v1.1 by Shiru, 19.01.08\n");
		printf("USAGE: vopmxtfi.exe filename.opm to VOPM>TFI\n");
		printf("       vopmxtfi.exe filename.opm file1.tfi file2.tfi ... to TFI>VOPM\n");
		return 0;
	}
	
	if(argc<3)
	{
		// opm>tfi ////////////////////////////////////////////////////////////////////
		
		if(!check_ext(argv[1],".opm"))
		{
			printf("ERR: Unsupported file format\n");
			return 1;
		}
		
		file=fopen(argv[1],"rb");
		if(!file)
		{
			printf("ERR: Can't open file '%s'\n",argv[1]);
			return 1;
		}
		
		fseek(file,0,SEEK_END);
		size=ftell(file);
		fseek(file,0,SEEK_SET);
		opm=(char*)malloc(size+16);
		fread(opm,size,1,file);
		fclose(file);
		
		pp=0;
		inscount=0;
		first=true;
		
		while(pp<size)
		{
			if(opm[pp]==0x0d||opm[pp]==0x0a)
			{
				pp++;
				continue;
			}
			if(opm[pp]=='/'&&opm[pp+1]=='/')//skip comments
			{
				pp+=2;
				while(opm[pp]>=0x20&&pp<size) pp++;
				continue;
			}
			
			if(is_tag(opm+pp,"@:"))//new instrument
			{
				//save current instrument
				
				if(!first)
				{
					if(strcmp(insname,"no Name"))
					{
						strcpy(filename,insname);
						for(i=0;i<(int)strlen(filename);i++)
						{
							switch(filename[i])
							{
							case '/':
							case '\\':
							case ':':
							case '*':
							case '?':
							case '"':
							case '<':
							case '>':
							case '|':
								filename[i]='_';
								break;
							}
						}
						strcat(filename,".tfi");
						ins_save(&ins,filename);
						inscount++;
					}
				}
				insname[0]=0;
				memset(&ins,0,sizeof(instrumentStruct));
				first=false;
				
				//take new instrument name
				
				pp+=2;
				
				while(opm[pp]!=0x20&&pp<size) pp++;
				while(opm[pp]==0x20&&pp<size) pp++;
				pd=0;
				while(pp<size&&pd<1023)
				{
					chr=opm[pp++];
					if(chr==0x0d||chr==0x0a) break;
					insname[pd++]=chr;
				}
				insname[pd]=0;
				
				continue;
			}
			
			if(is_tag(opm+pp,"lfo:"))//skip LFO
			{
				pp+=4;
				while(opm[pp]>=0x20) pp++;
				continue;
			}
			
			if(is_tag(opm+pp,"ch:"))//common instrument settings
			{
				pp+=3;
				pnum=0;
				
				while(pp<size)
				{
					while(opm[pp]==0x20&&pp<size) pp++;
					
					num=0;
					while(opm[pp]>='0'&&opm[pp]<='9'&&pp<size) num=num*10+opm[pp++]-'0';
					
					switch(pnum)
					{
					case 0://PAN
						break;
					case 1://FL
						ins.feedback=num;
						break;
					case 2://CON
						ins.algo=num;
						break;
					case 3://AMS
						break;
					case 4://PMS
						break;
					case 5://SLOT
						break;
					case 6://NE
						break;
					}
					pnum++;
					if(pnum>6) break;
				}
				continue;
			}
			
			if(is_tag(opm+pp,"m1:"))//M1
			{
				pp=parse_operator(opm,size,pp,0);
				continue;
			}
			
			if(is_tag(opm+pp,"c1:"))//C1
			{
				pp=parse_operator(opm,size,pp,2);
				continue;
			}
			
			if(is_tag(opm+pp,"m2:"))//M2
			{
				pp=parse_operator(opm,size,pp,1);
				continue;
			}
			
			if(is_tag(opm+pp,"c2:"))//C2
			{
				pp=parse_operator(opm,size,pp,3);
				continue;
			}
			
			pp++;
		}
		
		free(opm);
	}
	else
	{
		// tfi>opm ////////////////////////////////////////////////////////////////////

		//get output file name
		filename[0]=0;
		for(i=1;i<argc;i++)
		{
			if(check_ext(argv[i],".opm"))
			{
				strcpy(filename,argv[1]);
				break;
			}
		}
		if(!strlen(filename))
		{
			printf("ERR: No output filename specified\n");
			return 1;
		}
		
		file=fopen(filename,"wb");
		if(!file)
		{
			printf("ERR: Can't open output file\n");
			return 1;
		}

		fprintf(file,"//MiOPMdrv sound bank Paramer Ver2002.04.22\r\n");
		fprintf(file,"//LFO: LFRQ AMD PMD WF NFRQ\r\n");
		fprintf(file,"//@:[Num] [Name]\r\n");
		fprintf(file,"//CH: PAN	FL CON AMS PMS SLOT NE\r\n");
		fprintf(file,"//[OPname]: AR D1R D2R	RR D1L	TL	KS MUL DT1 DT2 AMS-EN\r\n\r\n");

		inscount=0;
		for(i=1;i<argc;i++)
		{
			if(ins_load(&ins,argv[i]))
			{
				strcpy(filename,argv[i]);
				filename[strlen(filename)-4]=0;
				fprintf(file,"@:%i %s\r\n",inscount,filename);
				fprintf(file,"LFO: 0 0 0 0 0\r\n");
				fprintf(file,"CH: 64 %i %i 0 0 120 0\r\n",ins.feedback,ins.algo);

				for(j=0;j<4;j++)
				{
					if(j==0) fprintf(file,"%s: ","M1");
					if(j==1) fprintf(file,"%s: ","C1");
					if(j==2) fprintf(file,"%s: ","M2");
					if(j==3) fprintf(file,"%s: ","C2");
					op=&ins.op[opord[j]];
					fprintf(file,"%i ",op->envAttack);//AR
					fprintf(file,"%i ",op->envDecay);//D1R
					fprintf(file,"%i ",op->envSustain);//D2R
					fprintf(file,"%i ",op->envRelease);//RR
					fprintf(file,"%i ",op->envRelLevel);//D1L
					fprintf(file,"%i ",op->totalLevel);//TL
					fprintf(file,"%i ",op->rateScale);//KS
					fprintf(file,"%i ",op->multiple);//MUL
					fprintf(file,"%i ",op->detune+3);//DT1
					fprintf(file,"0 0\r\n");//DT2,AMS-EN
				}
				fprintf(file,"\r\n");

				inscount++;
			}
		}

		for(i=0;i<128-inscount;i++)
		{
			fprintf(file,"@:%i no Name\r\n",inscount+i);
			fprintf(file,"LFO: 0 0 0 0 0\r\n");
			fprintf(file,"CH: 64 0 0 0 0 64 0\r\n");
			fprintf(file,"M1: 31 0 0 4 0 0 0 1 0 0 0\r\n");
			fprintf(file,"C1: 31 0 0 4 0 0 0 1 0 0 0\r\n");
			fprintf(file,"M2: 31 0 0 4 0 0 0 1 0 0 0\r\n");
			fprintf(file,"C2: 31 0 0 4 0 0 0 1 0 0 0\r\n\r\n");
		}

		fclose(file);
	}

	printf("OK: %i instruments were converted successfully\n",inscount);
	
	return 0;
}