#include "leakchk.h"

#include "../SDK/foobar2000.h"
#include "../helpers//helpers.h"
#include "pversion.h"
#include <xsfui.rh>
#include "tagget.h"

#define xsf_channel_count 16


static const GUID guid_xsfcfg = XSFDRIVER_GUID1;
static const GUID guid_cfg_play_infinitely = 
{ 0xba375d99, 0xd43d, 0x4f7f, { 0xa7, 0x6b, 0x59, 0x3a, 0xec, 0x57, 0x0, 0xd9 } };
static const GUID guid_cfg_default_len =
{ 0x5371e38e, 0x1fef, 0x4952, { 0xab, 0x96, 0x18, 0xfa, 0x2f, 0x72, 0x2c, 0x12 } };
static const GUID guid_cfg_default_fade_len =
{ 0x88a70a46, 0xf56a, 0x47af, { 0xaf, 0xaf, 0xc1, 0xf4, 0x28, 0xc1, 0xa2, 0x50 } };
static const GUID guid_cfg_skip_silence =
{ 0x4b3e5056, 0x93bd, 0x4204, { 0xa5, 0x47, 0xeb, 0x36, 0x94, 0xcd, 0xf2, 0xe6 } };
static const GUID guid_cfg_detect_silence =
{ 0xc72f845e, 0xe629, 0x4d51, { 0x96, 0x7a, 0x58, 0x4f, 0xa5, 0xa6, 0x49, 0x35 } };
static const GUID guid_cfg_volume =
{ 0xc56c5ab, 0x7210, 0x4ae1, { 0xaa, 0xb, 0xa9, 0x76, 0xa5, 0x86, 0xff, 0x9a } };
static const GUID guid_cfg_mute =
{ 0xbc310e32, 0xf1d6, 0x49bb, { 0xb0, 0x3c, 0x50, 0x61, 0x42, 0x60, 0xb8, 0xe2 } };
static const GUID guid_cfg_interpolation =
{ 0x64baf316, 0x146b, 0x41b5, { 0xa8, 0xd1, 0xba, 0x4d, 0x54, 0x91, 0x6b, 0x81 } };
static const GUID guid_cfg_use_old_core =
{ 0xb17f26df, 0xa060, 0x481c, { 0xb1, 0xdd, 0x23, 0xbc, 0x32, 0xd6, 0x7, 0x6a } };
static const GUID guid_cfg_ignore_volume_tag =
{ 0xedc20390, 0x9d43, 0x40cf, { 0xaa, 0xe9, 0x2e, 0x2b, 0x7b, 0xf1, 0x98, 0xe3 } };





cfg_int cfg_play_infinitely(guid_cfg_play_infinitely, 0);
cfg_string cfg_default_len(guid_cfg_default_len, "1:55");
cfg_string cfg_default_fade_len(guid_cfg_default_fade_len, "5");
cfg_int cfg_skip_silence(guid_cfg_skip_silence, 5);
cfg_int cfg_detect_silence(guid_cfg_detect_silence, 5);
cfg_string cfg_volume(guid_cfg_volume, "1.0");
cfg_uint cfg_mute(guid_cfg_mute, (~0)<<xsf_channel_count);
cfg_int cfg_interpolation(guid_cfg_interpolation, 0);
cfg_int cfg_use_old_core(guid_cfg_use_old_core, 0);
cfg_int cfg_ignore_volume_tag(guid_cfg_ignore_volume_tag, 0);


class foo_input_xsfcfg_instance : public preferences_page_instance
{
protected:
	HWND m_parent;
	HWND m_hwnd;
	const preferences_page_callback::ptr m_callback;
	bool m_initialized;



static const char* const	xsf_channel_name			[xsf_channel_count];

static BOOL CALLBACK DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);


public:
	t_uint32 get_state()
	{
		if (cfg_play_infinitely != IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY) ||
			strcmp(cfg_default_len, string_utf8_from_window(m_hwnd, IDC_DEFAULT_LEN)) ||
			strcmp(cfg_default_fade_len, string_utf8_from_window(m_hwnd, IDC_DEFAULT_FADE_LEN)) ||
			cfg_skip_silence != uGetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, NULL, FALSE) ||
			cfg_detect_silence != uGetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, NULL, FALSE) ||
			strcmp(cfg_volume, string_utf8_from_window(m_hwnd, IDC_VOLUME)) ||	
			cfg_interpolation != uSendDlgItemMessage(m_hwnd, IDC_COMBO_INTERPOLATION, CB_GETCURSEL, 0, 0) ||
			cfg_use_old_core != IsDlgButtonChecked(m_hwnd, IDC_USE_OLD_CORE) ||
			cfg_ignore_volume_tag != IsDlgButtonChecked(m_hwnd, IDC_IGNORE_VOLUME_TAG)
			)
			return preferences_state::changed | preferences_state::resettable;
		return preferences_state::resettable;
	}
	HWND get_wnd()
	{
		return m_hwnd;
	}

	HWND create(HWND p_parent)
	{
		return uCreateDialog(IDD_DIALOG1, p_parent, DialogProc, reinterpret_cast<LPARAM>(this));
	}

	void reset()
	{
		CheckDlgButton(m_hwnd, IDC_PLAY_INFINITELY, BST_UNCHECKED);
		uSetDlgItemText(m_hwnd, IDC_DEFAULT_LEN, "1:55");
		uSetDlgItemText(m_hwnd, IDC_DEFAULT_FADE_LEN, "5");
		uSetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, 5, FALSE);
		uSetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, 5, FALSE);
		uSetDlgItemText(m_hwnd, IDC_VOLUME, "1.0");
		uSendDlgItemMessage(m_hwnd, IDC_COMBO_INTERPOLATION, CB_SETCURSEL, 0, 0);
		CheckDlgButton(m_hwnd, IDC_USE_OLD_CORE, BST_UNCHECKED);
		CheckDlgButton(m_hwnd, IDC_IGNORE_VOLUME_TAG, 0);

		//mute
		cfg_mute = (~0)<<xsf_channel_count;
		HWND h = uGetDlgItem(m_hwnd, IDC_MUTE);
		for (unsigned i = 0; i < xsf_channel_count; i++)
		{
			uSendMessage(h, LB_SETSEL, 0, i);
		}
	}
	void apply()
	{
		cfg_play_infinitely = IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY);
		uGetDlgItemText(m_hwnd, IDC_DEFAULT_LEN, cfg_default_len);
		uGetDlgItemText(m_hwnd, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len);
		cfg_skip_silence = uGetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, NULL, FALSE);
		cfg_detect_silence = uGetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, NULL, FALSE);	
		uGetDlgItemText(m_hwnd, IDC_VOLUME, cfg_volume);
		
		cfg_interpolation = uSendDlgItemMessage(m_hwnd, IDC_COMBO_INTERPOLATION, CB_GETCURSEL, 0, 0);
		cfg_use_old_core = IsDlgButtonChecked(m_hwnd, IDC_USE_OLD_CORE);
		cfg_ignore_volume_tag = IsDlgButtonChecked(m_hwnd, IDC_IGNORE_VOLUME_TAG);

		m_callback->on_state_changed();
	}


	foo_input_xsfcfg_instance(HWND parent, preferences_page_callback::ptr callback) : 
		m_initialized(false), 
		m_parent(parent), 
	    m_callback(callback)
	{
		m_hwnd = create(m_parent);
	}
	~foo_input_xsfcfg_instance() {}
};


const char* const	foo_input_xsfcfg_instance::xsf_channel_name[] = { "SPU 1", "SPU 2", "SPU 3", "SPU 4", "SPU 5", "SPU 6", "SPU 7", "SPU 8", "SPU 9", "SPU 10", "SPU 11", "SPU 12", "SPU 13", "SPU 14", "SPU 15", "SPU 16" };

BOOL CALLBACK foo_input_xsfcfg_instance::DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
		switch (uMsg)
		{
		case WM_COMMAND:
			{
				foo_input_xsfcfg_instance *pthis = static_cast<foo_input_xsfcfg_instance *>(xsfc::TWin32::WndGetLongPtr(hwndDlg, DWLP_USER));
				switch ( (LOWORD(wParam)))
				{

				case IDC_PLAY_INFINITELY:case IDC_DEFAULT_LEN: case IDC_DEFAULT_FADE_LEN: case IDC_SKIP_SILENCE:
				case IDC_DETECT_SILENCE: case IDC_VOLUME: case IDC_COMBO_INTERPOLATION: case IDC_USE_OLD_CORE: case IDC_IGNORE_VOLUME_TAG:
					if (pthis) pthis->m_callback->on_state_changed();
					break;
				case IDC_MUTE:
				{
					if (HIWORD(wParam) == CBN_SELCHANGE)
					{
						HWND h = uGetDlgItem(hwndDlg, IDC_MUTE);
						unsigned cur_sel = uSendMessage(h, LB_GETCURSEL, 0, 0);
						unsigned mute = uSendMessage(h, LB_GETSEL, cur_sel, 0) ? 1 : 0;
						cfg_mute = cfg_mute & (~(1 << cur_sel));
						cfg_mute = cfg_mute | (mute << cur_sel);
					}
				}
				default:
					break;
				}
				break;
			}

		case WM_INITDIALOG:
			{
				uSetWindowLong(hwndDlg, DWL_USER, lParam);

				CheckDlgButton(hwndDlg, IDC_PLAY_INFINITELY, (UINT)cfg_play_infinitely);
				uSetDlgItemText(hwndDlg, IDC_DEFAULT_LEN, cfg_default_len);
				uSetDlgItemText(hwndDlg, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len);
				uSetDlgItemInt(hwndDlg, IDC_SKIP_SILENCE, cfg_skip_silence, FALSE);
				uSetDlgItemInt(hwndDlg, IDC_DETECT_SILENCE, cfg_detect_silence, FALSE);
				uSetDlgItemText(hwndDlg, IDC_VOLUME, cfg_volume);
				
				HWND h = uGetDlgItem(hwndDlg, IDC_COMBO_INTERPOLATION);
				uSendMessageText(h, CB_ADDSTRING, 0, "No interpolation");
				uSendMessageText(h, CB_ADDSTRING, 0, "Linear interpolation");
				uSendMessageText(h, CB_ADDSTRING, 0, "Cosine interpolation");
				uSendMessage(h, CB_SETCURSEL, (UINT)cfg_interpolation, 0);

				CheckDlgButton(hwndDlg, IDC_USE_OLD_CORE, (UINT)cfg_use_old_core);
				CheckDlgButton(hwndDlg, IDC_IGNORE_VOLUME_TAG, (UINT)cfg_ignore_volume_tag);

				
				//mute
				h = uGetDlgItem(hwndDlg, IDC_MUTE);
				for (unsigned i = 0; i < xsf_channel_count; i++)
				{
					uSendMessageText(h, LB_ADDSTRING, 0, xsf_channel_name[i]);
					uSendMessage(h, LB_SETSEL, (cfg_mute & (1<<i)), i);
				}
				break;
			}
		case WM_DESTROY:
		{
			uSetWindowLong(hwndDlg, DWL_USER, 0);
			break;
		}
		default:
			return FALSE;
		}
	return TRUE;
}


class foo_input_xsfcfg : public preferences_page_v3
{
public:
	const char * get_name() { return XSFDRIVER_SIMPLENAME; }
	GUID get_guid() { return guid_xsfcfg; }
	GUID get_parent_guid() { return guid_input; }
	preferences_page_instance::ptr instantiate(HWND parent, preferences_page_callback::ptr callback)
	{
		return new service_impl_t<foo_input_xsfcfg_instance >(parent, callback);
	}
};

static preferences_page_factory_t<foo_input_xsfcfg> g_input_xsfcfg_factory;





HMODULE hDLL;
extern "C" void fb2k_config_init(HINSTANCE hinstDLL)
{
	hDLL = (HMODULE)hinstDLL;
}
