#define WSR_PLAYER_API __declspec(dllexport)

//mednafen
#include "mednafen/wswan/wswan.h"
#include "mednafen/wswan/v30mz.h"
#include "mednafen/wswan/gfx.h"
#include "mednafen/wswan/memory.h"
#include "mednafen/wswan/sound.h"
//#include <stdio.h>
#include <stdlib.h>
//#include <string.h>
#include "wsr_player.h"




#define WSR_HEADER_MAGIC 0x46525357

static uint32 _ChannelMute = 0;
static uint8	first_song_number = 0;


//refferd to viogsf's drvimpl.cpp. thanks the author.
static struct
{
	uint8 * ptr;
	uint32 len;
	uint32 fil;
	uint32 cur;
}
buffer =
{
	0, 0, 0, 0
};

static uint32 ReadLE16(const uint8* pData)
{
	return (pData[0x01] << 8) | (pData[0x00] << 0);
}

static uint32 ReadLE32(const uint8* pData)
{
	return	(pData[0x03] << 24) | (pData[0x02] << 16) |	(pData[0x01] << 8) | (pData[0x00] << 0);
}

void Init_WSR(void)
{
	
}

int Load_WSR(const void* pFile, unsigned Size)
{
	if (Size <= 0x20 || !pFile) return 0;
	if (ReadLE32((const uint8*)pFile + Size - 0x20) != WSR_HEADER_MAGIC)
		return 0;

	uint32 buflen = (4096 << 2);
	buffer.ptr = (uint8*)malloc(buflen);
	if (!buffer.ptr)
	{
		return 0;
	}
	buffer.len = buflen;
	buffer.fil = 0;
	buffer.cur = 0;

	if (!MDFN_IEN_WSWAN::Load((const uint8*)pFile, Size))	//error
	{
		free(buffer.ptr);
		buffer.ptr = 0;
		buffer.len = 0;
		return 0;
	}
		

	first_song_number = *((const uint8*)pFile + Size - 0x20 + 0x05);
	Init_WSR();

	return 1;
}


void Close_WSR()
{
	MDFN_IEN_WSWAN::CloseGame();

	if (buffer.ptr)
	{
		free(buffer.ptr);
		buffer.ptr = 0;
	}
	buffer.len = 0;
	buffer.fil = 0;
	buffer.cur = 0;
}


int Get_FirstSong(void)
{
	return first_song_number;
}


unsigned Set_Frequency(unsigned int Freq)
{
	if (Freq < 12000 || Freq > 192000)
		Freq = 44100;
	MDFN_IEN_WSWAN::WSwan_SetSoundRate(Freq);
	return Freq;
}

void Set_ChannelMuting(unsigned int Mute)
{
	_ChannelMute = Mute;
	MDFN_IEN_WSWAN::WSwan_SetChannelMute(Mute);
	return;
}

unsigned int Get_ChannelMuting(void)
{
	return _ChannelMute;
}



void Reset_WSR(unsigned SongNo)
{
	MDFN_IEN_WSWAN::Reset(SongNo&0xff);
	buffer.cur = 0;
	buffer.fil = 0;
}


void FlushBuffer_WSR(const short * finalWave, unsigned long length)
{
	if (length > buffer.len - buffer.fil)
	{
		length = buffer.len - buffer.fil;
	}
	if (length > 0)
	{
		memcpy(buffer.ptr + buffer.fil, finalWave, length);
		buffer.fil += length;
	}
}

//refferd to viogsf's drvimpl.cpp. thanks the author.
int Update_WSR(void* pBuf, unsigned Buflen, unsigned Samples)
{
	int ret = 0;
	uint32 bytes = Samples << 2;
	uint8* des = (uint8*)pBuf;

	if (buffer.ptr == 0 || pBuf == 0)
		return 0;

	while (bytes > 0)
	{
		uint32 remain = buffer.fil - buffer.cur;
		while (remain == 0)
		{
			buffer.cur = 0;
			buffer.fil = 0;

			while (!MDFN_IEN_WSWAN::wsExecuteLine())
			{

			}

			buffer.fil = (MDFN_IEN_WSWAN::WSwan_SoundFlush((int16*)(buffer.ptr), (buffer.len>>2))) << 2;
			MDFN_IEN_WSWAN::v30mz_timestamp = 0;
				
			remain = buffer.fil - buffer.cur;
		}
		uint32 len = remain;
		if (len > bytes)
		{
			len = bytes;
		}
		memcpy(des, buffer.ptr + buffer.cur, len);
		bytes -= len;
		des += len;
		buffer.cur += len;
		ret += len;
	}
	return ret;

}


static WSRPlayerApi g_wsr_player_api =
{
	Load_WSR, 
	Get_FirstSong, 
	Set_Frequency, 
	Set_ChannelMuting, 
	Get_ChannelMuting, 
	Reset_WSR, 
	Close_WSR, 
	Update_WSR
};

WSRPlayerApi* WSRPlayerSetUp(void)
{
	return &g_wsr_player_api;
}