/////////////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "log.h"

/////////////////////////////////////////////////////////////////////////////////////////////////
// static global variables
/////////////////////////////////////////////////////////////////////////////////////////////////
static FILE* log_stream = NULL;

/////////////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////////////
int log_init(const char* path)
{
  if (log_stream != NULL)
    log_done();

  return ((log_stream = fopen(path, "wrt")) == NULL ? 0 : 1);
}

/////////////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////////////
int log_write(const char* format, ...) {
  if (log_stream == NULL)
    return 0;

  va_list ap;
  int     result;

  va_start(ap, format);
  result = vfprintf(log_stream, format, ap);
  va_end(ap);

  return (result < 0 ? 0 : 1);
}

/////////////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////////////
void log_done(void)
{
  fclose(log_stream);
  log_stream = NULL;
}
