#include "leakchk.h"

#include "../SDK/foobar2000.h"
#include "../helpers//helpers.h"
#include "pversion.h"
#include <xsfui.rh>
#include "tagget.h"

#define xsf_channel_count 6


static const GUID guid_xsfcfg = XSFDRIVER_GUID1;
static const GUID guid_cfg_play_infinitely = 
{ 0x311c074e, 0x9e36, 0x46a2, { 0x8e, 0x2c, 0xa5, 0x80, 0x30, 0xc8, 0xcc, 0x52 } };
static const GUID guid_cfg_default_len =
{ 0x25f5faea, 0x94ba, 0x4344, { 0x97, 0xa9, 0x6c, 0xf6, 0x44, 0x30, 0xfd, 0x29 } };
static const GUID guid_cfg_default_fade_len =
{ 0x27c41a9c, 0x85e1, 0x4995, { 0xa7, 0x2b, 0x5c, 0xe6, 0x7, 0xb, 0x6d, 0xbc } };
static const GUID guid_cfg_skip_silence =
{ 0xaf93d17, 0x1c7d, 0x4a4a, { 0x98, 0x21, 0x1, 0x7c, 0x91, 0x94, 0xb9, 0xa0 } };
static const GUID guid_cfg_detect_silence =
{ 0xa02ed402, 0x7d50, 0x4482, { 0xa9, 0xda, 0xcc, 0x6c, 0xbe, 0x6b, 0x73, 0x1c } };
static const GUID guid_cfg_volume =
{ 0x5e23aabb, 0xecc7, 0x4db5, { 0x86, 0x95, 0x29, 0x4a, 0x5f, 0x48, 0xab, 0x8a } };
static const GUID guid_cfg_mute =
{ 0x524a9d80, 0xd5d, 0x4ec6, { 0x9e, 0x27, 0xcb, 0xe3, 0x95, 0xd8, 0xb2, 0xf6 } };
static const GUID guid_cfg_interpolation =
{ 0xa494f44, 0x1d6d, 0x4466, { 0x88, 0x66, 0xca, 0x70, 0x95, 0x9f, 0xfd, 0xec } };
static const GUID guid_cfg_exparam1 =
{ 0xd750931, 0x6c, 0x42c2, { 0x93, 0xf0, 0x5e, 0x25, 0xd2, 0xac, 0x34, 0xcb } };
static const GUID guid_cfg_sample_rate =
{ 0xe0f777a2, 0x1915, 0x4d60, { 0x9a, 0xcb, 0x61, 0xc, 0xdf, 0x63, 0x89, 0xe0 } };
static const GUID guid_cfg_exparam2 =
{ 0x357e5a23, 0x9002, 0x45d5, { 0xbd, 0x63, 0xc7, 0xe7, 0x61, 0xef, 0x26, 0xa6 } };
static const GUID guid_cfg_ignore_volume_tag =
{ 0xd1774453, 0x17c6, 0x44ce, { 0x87, 0x98, 0x41, 0x75, 0xa6, 0x93, 0xd1, 0x94 } };




cfg_int cfg_play_infinitely(guid_cfg_play_infinitely, 0);
cfg_string cfg_default_len(guid_cfg_default_len, "1:55");
cfg_string cfg_default_fade_len(guid_cfg_default_fade_len, "5");
cfg_int cfg_skip_silence(guid_cfg_skip_silence, 5);
cfg_int cfg_detect_silence(guid_cfg_detect_silence, 5);
cfg_string cfg_volume(guid_cfg_volume, "1.0");
cfg_uint cfg_mute(guid_cfg_mute, (~0)<<xsf_channel_count);
cfg_int cfg_interpolation(guid_cfg_interpolation, 1);
cfg_string cfg_exparam1(guid_cfg_exparam1, "0.5");
cfg_uint cfg_sample_rate(guid_cfg_sample_rate, 44100);
cfg_string cfg_exparam2(guid_cfg_exparam2, "1");
cfg_int cfg_ignore_volume_tag(guid_cfg_ignore_volume_tag, 0);

class foo_input_xsfcfg_instance : public preferences_page_instance
{
protected:
	HWND m_parent;
	HWND m_hwnd;
	const preferences_page_callback::ptr m_callback;
	bool m_initialized;


static const char* const	combo_sample_rate_name		[XSFDRIVER_SAMPLERATE_COUNT];
static const t_uint32		combo_sample_rate_value		[XSFDRIVER_SAMPLERATE_COUNT];


static const char* const	xsf_channel_name			[xsf_channel_count];

static BOOL CALLBACK DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);


public:
	t_uint32 get_state()
	{
		int cur_sample_rate = uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);

		if (cfg_play_infinitely != IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY) ||
			strcmp(cfg_default_len, string_utf8_from_window(m_hwnd, IDC_DEFAULT_LEN)) ||
			strcmp(cfg_default_fade_len, string_utf8_from_window(m_hwnd, IDC_DEFAULT_FADE_LEN)) ||
			cfg_skip_silence != uGetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, NULL, FALSE) ||
			cfg_detect_silence != uGetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, NULL, FALSE) ||
			strcmp(cfg_volume, string_utf8_from_window(m_hwnd, IDC_VOLUME)) ||		
			cfg_interpolation != IsDlgButtonChecked(m_hwnd, IDC_INTERPOLATION) ||
			cur_sample_rate != CB_ERR && cfg_sample_rate != combo_sample_rate_value[cur_sample_rate] ||
			strcmp(cfg_exparam1, string_utf8_from_window(m_hwnd, IDC_EXPARAM1)) ||
			strcmp(cfg_exparam2, string_utf8_from_window(m_hwnd, IDC_EXPARAM2)) ||
			cfg_ignore_volume_tag != IsDlgButtonChecked(m_hwnd, IDC_IGNORE_VOLUME_TAG)
			)
			return preferences_state::changed | preferences_state::resettable;
		return preferences_state::resettable;
	}
	HWND get_wnd()
	{
		return m_hwnd;
	}

	HWND create(HWND p_parent)
	{
		return uCreateDialog(IDD_DIALOG1, p_parent, DialogProc, reinterpret_cast<LPARAM>(this));
	}

	void reset()
	{
		CheckDlgButton(m_hwnd, IDC_PLAY_INFINITELY, 0);
		uSetDlgItemText(m_hwnd, IDC_DEFAULT_LEN, "1:55");
		uSetDlgItemText(m_hwnd, IDC_DEFAULT_FADE_LEN, "5");
		uSetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, 5, FALSE);
		uSetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, 5, FALSE);
		uSetDlgItemText(m_hwnd, IDC_VOLUME, "1.0");
		CheckDlgButton(m_hwnd, IDC_INTERPOLATION, 1);
		CheckDlgButton(m_hwnd, IDC_IGNORE_VOLUME_TAG, 0);

		uSetDlgItemText(m_hwnd, IDC_EXPARAM1, "0.5");
		uSetDlgItemText(m_hwnd, IDC_EXPARAM2, "1");

		//combo box
		uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_SETCURSEL, 0, 0);

		//mute
		cfg_mute = (~0)<<xsf_channel_count;
		HWND h = uGetDlgItem(m_hwnd, IDC_MUTE);
		for (unsigned i = 0; i < xsf_channel_count; i++)
		{
			uSendMessage(h, LB_SETSEL, 0, i);
		}
	}
	void apply()
	{
		cfg_play_infinitely = IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY);
		uGetDlgItemText(m_hwnd, IDC_DEFAULT_LEN, cfg_default_len);
		uGetDlgItemText(m_hwnd, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len);
		cfg_skip_silence = uGetDlgItemInt(m_hwnd, IDC_SKIP_SILENCE, NULL, FALSE);
		cfg_detect_silence = uGetDlgItemInt(m_hwnd, IDC_DETECT_SILENCE, NULL, FALSE);	
		uGetDlgItemText(m_hwnd, IDC_VOLUME, cfg_volume);
		
		cfg_interpolation = IsDlgButtonChecked(m_hwnd, IDC_INTERPOLATION);
		int cur_sel = uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);
		if (cur_sel != CB_ERR) cfg_sample_rate = combo_sample_rate_value[cur_sel];
		cfg_ignore_volume_tag = IsDlgButtonChecked(m_hwnd, IDC_IGNORE_VOLUME_TAG);

		uGetDlgItemText(m_hwnd, IDC_EXPARAM1, cfg_exparam1);
		uGetDlgItemText(m_hwnd, IDC_EXPARAM2, cfg_exparam2);

		m_callback->on_state_changed();
	}


	foo_input_xsfcfg_instance(HWND parent, preferences_page_callback::ptr callback) : 
		m_initialized(false), 
		m_parent(parent), 
	    m_callback(callback)
	{
		m_hwnd = create(m_parent);
	}
	~foo_input_xsfcfg_instance() {}
};


const char* const   foo_input_xsfcfg_instance::combo_sample_rate_name[] = XSFDRIVER_SAMPLERATE_NAME;
const t_uint32		foo_input_xsfcfg_instance::combo_sample_rate_value[] = XSFDRIVER_SAMPLERATE_VALUE;

const char* const	foo_input_xsfcfg_instance::xsf_channel_name[] = { "Square 1", "Square 2", "Wave Pattern", "Noise", "PCM A", "PCM B" };

BOOL CALLBACK foo_input_xsfcfg_instance::DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
		switch (uMsg)
		{
		case WM_COMMAND:
			{
				foo_input_xsfcfg_instance *pthis = static_cast<foo_input_xsfcfg_instance *>(xsfc::TWin32::WndGetLongPtr(hwndDlg, DWLP_USER));
				switch ( (LOWORD(wParam)))
				{

				case IDC_PLAY_INFINITELY:case IDC_DEFAULT_LEN: case IDC_DEFAULT_FADE_LEN: case IDC_SKIP_SILENCE:
				case IDC_DETECT_SILENCE: case IDC_VOLUME: case IDC_INTERPOLATION: case IDC_SAMPLE_RATE:case IDC_EXPARAM1: case IDC_EXPARAM2:
				case IDC_IGNORE_VOLUME_TAG:
					if (pthis) pthis->m_callback->on_state_changed();
					break;
				case IDC_MUTE:
				{
					if (HIWORD(wParam) == CBN_SELCHANGE)
					{
						HWND h = uGetDlgItem(hwndDlg, IDC_MUTE);
						unsigned cur_sel = uSendMessage(h, LB_GETCURSEL, 0, 0);
						unsigned mute = uSendMessage(h, LB_GETSEL, cur_sel, 0) ? 1 : 0;
						cfg_mute = cfg_mute & (~(1 << cur_sel));
						cfg_mute = cfg_mute | (mute << cur_sel);
					}
				}
				default:
					break;
				}
				break;
			}

		case WM_INITDIALOG:
			{
				uSetWindowLong(hwndDlg, DWL_USER, lParam);

				CheckDlgButton(hwndDlg, IDC_PLAY_INFINITELY, (UINT)cfg_play_infinitely);
				uSetDlgItemText(hwndDlg, IDC_DEFAULT_LEN, cfg_default_len);
				uSetDlgItemText(hwndDlg, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len);
				uSetDlgItemInt(hwndDlg, IDC_SKIP_SILENCE, cfg_skip_silence, FALSE);
				uSetDlgItemInt(hwndDlg, IDC_DETECT_SILENCE, cfg_detect_silence, FALSE);
				uSetDlgItemText(hwndDlg, IDC_VOLUME, cfg_volume);
				
	
				::ShowWindow(GetDlgItem(hwndDlg, IDC_EXPARAM1), SW_SHOWNA);
				::ShowWindow(GetDlgItem(hwndDlg, IDC_EXPARAM2), SW_SHOWNA);
				::EnableWindow(GetDlgItem(hwndDlg, IDC_EXPARAM1), TRUE);
				::EnableWindow(GetDlgItem(hwndDlg, IDC_EXPARAM2), TRUE);
				SetDlgItemTextW(hwndDlg, IDC_EXPARAM1_LABEL, XSFDRIVER_EXTENDPARAM1LABEL);
				SetDlgItemTextW(hwndDlg, IDC_EXPARAM2_LABEL, XSFDRIVER_EXTENDPARAM2LABEL);
				uSetDlgItemText(hwndDlg, IDC_EXPARAM1, cfg_exparam1);
				uSetDlgItemText(hwndDlg, IDC_EXPARAM2, cfg_exparam2);

				CheckDlgButton(hwndDlg, IDC_INTERPOLATION, (UINT)cfg_interpolation);
				CheckDlgButton(hwndDlg, IDC_IGNORE_VOLUME_TAG, (UINT)cfg_ignore_volume_tag);

				
				//combo box			
				HWND h = uGetDlgItem(hwndDlg, IDC_SAMPLE_RATE);
				unsigned cur_sel = 0;
				for (unsigned i = 0; i < XSFDRIVER_SAMPLERATE_COUNT; i++)
				{
					uSendMessageText(h, CB_ADDSTRING, 0, combo_sample_rate_name[i]);
					if (cfg_sample_rate == combo_sample_rate_value[i])
						cur_sel = i;
				}
				uSendMessage(h, CB_SETCURSEL, cur_sel, 0);

				//mute
				h = uGetDlgItem(hwndDlg, IDC_MUTE);
				for (unsigned i = 0; i < xsf_channel_count; i++)
				{
					uSendMessageText(h, LB_ADDSTRING, 0, xsf_channel_name[i]);
					uSendMessage(h, LB_SETSEL, (cfg_mute & (1<<i)), i);
				}
				break;
			}
		case WM_DESTROY:
		{
			uSetWindowLong(hwndDlg, DWL_USER, 0);
			break;
		}
		default:
			return FALSE;
		}
	return TRUE;
}


class foo_input_xsfcfg : public preferences_page_v3
{
public:
	const char * get_name() { return XSFDRIVER_SIMPLENAME; }
	GUID get_guid() { return guid_xsfcfg; }
	GUID get_parent_guid() { return guid_input; }
	preferences_page_instance::ptr instantiate(HWND parent, preferences_page_callback::ptr callback)
	{
		return new service_impl_t<foo_input_xsfcfg_instance >(parent, callback);
	}
};

static preferences_page_factory_t<foo_input_xsfcfg> g_input_xsfcfg_factory;





HMODULE hDLL;
extern "C" void fb2k_config_init(HINSTANCE hinstDLL)
{
	hDLL = (HMODULE)hinstDLL;
}
