
#include <windows.h>
#include <stdio.h>
#include "./nec/necintrf.h"
#include "wsr_winamp.h"
#include "wsr_player.h"
#include "types.h"
#include "ws_memory.h"
#include "ws_io.h"
#include "ws_audio.h"

int SampleRate = 44100;

byte *ROM = NULL;
int ROMSize;
int ROMBank;

int Load_WSR(char *name)
{
	HANDLE input_file = INVALID_HANDLE_VALUE;
	int i;

	if (ROM) { free(ROM); ROM = NULL; }

	input_file = CreateFile(name, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL,
	  OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (input_file != INVALID_HANDLE_VALUE)
	{
		ROMSize = GetFileSize(input_file, NULL);
		ROMBank = (ROMSize+0xFFFF)>>16;
		ROM = malloc(ROMBank*0x10000);
		if (!ROM) { CloseHandle(input_file); return 0; }
		ReadFile(input_file, ROM, ROMSize, &i, NULL);
		CloseHandle(input_file);
	}

	Init_WSR();

	return 1;
}

int Get_FirstSong(void)
{
	if (ROM == NULL || ROMSize < 0x20)
		return 0;

	return (unsigned)ROM[ROMSize-0x20+5];
}

void Init_WSR(void)
{
	ws_memory_init(ROM, ROMSize);
	ws_io_init();
	ws_audio_init();
}

void Reset_WSR(int SongNo)
{
	ws_memory_reset();
	ws_audio_reset();
	ws_io_reset();
	ws_timer_reset();
	nec_reset(NULL);
	nec_set_reg(NEC_SP, 0x2000);
	nec_set_reg(NEC_AW, SongNo);
}

void Close_WSR(void)
{
	if (ROM) free(ROM);
	ROM = NULL;
	ws_memory_done();
	ws_io_done();
	ws_audio_done();
}

int Sample_Enable = 0;
int Sample_Offset;
int Sample_Length;
int CPU_Count;
int CPU_Cycles;
int CPU_Run = 0;

void Init_SampleData(int Length)
{
	Sample_Offset = 0;
	Sample_Length = Length;
	Sample_Enable = 1;
}

void Close_SampleData(void)
{
	Update_SampleData();
	Sample_Enable = 0;
}

void Update_SampleData(void)
{
	int offset, length, cnt;

	if (Sample_Enable)
	{
		cnt = CPU_Count;
		if (CPU_Run)
			cnt += nec_getcycles();
		offset = Sample_Length * cnt / CPU_Cycles;
		if (offset >= Sample_Length)
			offset = Sample_Length;
		length = offset - Sample_Offset;

		if (length > 0)
		{
			ws_audio_update(sample_buffer + (Sample_Offset * 2), length);
			Sample_Offset += length;
		}
	}
}

void Update_WSR(int Cycles, int Length)
{
	int i;

	CPU_Cycles = Cycles;
	CPU_Count = 0;
	Init_SampleData(Length);

	while (CPU_Count < Cycles)
	{
		i = ws_timer_min(Cycles - CPU_Count);
		CPU_Run = 1;
		nec_execute(i);
		CPU_Run = 0;
		CPU_Count += i;
		ws_timer_count(i);
		ws_timer_update();
	}

	Close_SampleData();
}


#define TOTAL_TIMER 3
int ws_timer[TOTAL_TIMER];
int ws_timer_pending[TOTAL_TIMER];

void ws_timer_reset(void)
{
	int i;

	for (i=0; i<TOTAL_TIMER; i++)
	{
		ws_timer[i] = 0;
		ws_timer_pending[i] = 0;
	}

	ws_timer[0] = 256;		//HBlank Timer
	ws_timer[1] = 256*159;	//VBlank
	ws_timer[2] = 0;		//SoundDMA
}

void ws_timer_count(int Cycles)
{
	int i;

	for (i=0; i<TOTAL_TIMER; i++)
	{
		if (ws_timer[i] > 0)
		{
			ws_timer[i] -= Cycles;
			if (ws_timer[i] <= 0)
			{
				switch (i)
				{
				case 0: // HBlank Timer
					if ((ws_ioRam[0xb2]&0x80) && ws_ioRam[0xa4])
					{
						if (!ws_ioRam[0xa5])
							ws_ioRam[0xa5] = ws_ioRam[0xa4];
						if (ws_ioRam[0xa5])
							ws_ioRam[0xa5]--;
						if (!ws_ioRam[0xa5])
						{
							ws_ioRam[0xb6] |= 0x80;
							nec_int();
						}
					}
					ws_audio_process();
					ws_timer[0] += 256;
					break;
				case 1: // VBlank
					if (ws_ioRam[0xb2]&0x40)
					{
						ws_ioRam[0xb6] |= 0x40;
						nec_int();
					}
					ws_timer[1] += 256*159;
					break;
				case 2: // SoundDMA
					ws_audio_sounddma();
					break;
				}
			}
		}
	}
}

WORD cpu_interrupt(void)
{
	int i, f;

	f = ws_ioRam[0xb2] & ws_ioRam[0xb6];

	//荞݂̗D揇ʂ̍ bit7,bit6,...,bit0 ̏炵
	for (i=7; i>=6; i--)	//荞݂͂܂QĂȂ̂ bit7,bit6 ̂
	{
		if (f & (1<<i))
		{
			return ((ws_ioRam[0xb0]+i)*4);
		}
	}
	return 0xFFFF;
}

void ws_timer_set(int no, int timer)
{
	if (CPU_Run)
	{
		ws_timer_pending[no] = timer;
		nec_yield();
	}
	else
	{
		ws_timer[no] = timer;
	}
}

void ws_timer_update(void)
{
	int i;

	for (i=0; i<TOTAL_TIMER; i++)
	{
		if (ws_timer_pending[i] > 0)
		{
			ws_timer[i] = ws_timer_pending[i];
			ws_timer_pending[i] = 0;
		}
	}
}

int ws_timer_min(int Cycles)
{
	int i;
	int timer = Cycles;

	for (i=0; i<TOTAL_TIMER; i++)
	{
		if ((ws_timer[i]>0) && (ws_timer[i]<timer))
			timer = ws_timer[i];
	}

	return (timer);
}
