  PUTSTR                = 1
  TEXTBOX0              = 1
  TEXTBOX1              = 1
  PUSHPOPTEXT           = 1
  SETCHARS              = 1
  GETSTR                = 1

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include kb.inc

public  _initvga50, _vgatextptr, _textstakptr, _vgadefcolorz

;
; DATA
;
SCRX            = 80                    ; 80 or 90 columns wide
DEFTEXTSB       = 0b8000h+(50*SCRX)*2
stak    struc
        dd      ?
lx      db      ?
ly      db      ?
dlx     db      ?
dly     db      ?
ends

crtc90colregs   dw      0e11h,2d13h,6b00h,5901h,5a02h,5e04h

_textstakptr    dd      ?       ; ptr to video stack, MUST set this first
_vgatextptr     dd      ?       ; text vidmem adjusted base pointer
_vgadefcolorz   db      0,0,0,0,0,42,0,42,0,0,42,42,42,0,0,42
                db      0,42,42,21,0,42,42,42,21,21,21,21,21,63,21,63
                db      21,21,63,63,63,21,21,63,21,63,63,63,21,63,63,63

;
; CODE
;

;
; Init VGA 50 line text mode and set color numbers
;
_initvga50:
        push eax dx esi
        @rlp eax,0b8000h
        mov _vgatextptr,eax
        @rlp eax,DEFTEXTSB
        mov _textstakptr,eax
        mov dword ptr [eax],0
        mov v86r_ax,3
        mov al,10h
        int 33h
        mov v86r_ax,1102h
        mov v86r_bl,0
        int 33h
        mov v86r_ax,1003h
        int 33h
        mov dx,3d4h
        mov ax,709h
        out dx,ax
        mov dx,3dah
        in al,dx
        test al,8
        jz short $-3
        mov dx,3c0h
        xor ah,ah
initvga50l1:
        mov al,ah
        out dx,al
        jmp short $+2
        out dx,al
        inc ah
        cmp ah,10h
        jb initvga50l1
        mov al,20h
        out dx,al
        mov dx,3dah
        in al,dx
        mov esi,offset _vgadefcolorz
        mov dx,3c8h
        xor al,al
        out dx,al
        inc dx
initvga50l2:
        lodsb
        out dx,al
        cmp esi,offset _vgadefcolorz+30h
        jb initvga50l2
if SCRX eq 90
        mov dx,3c4h
        mov ax,101h
        out dx,ax
        mov dl,0d4h
        mov esi,offset crtc90colregs
        outsw
        outsw
        outsw
        outsw
        outsw
        outsw
endif
        pop esi dx eax
        ret

ifdef   PUTSTR
public  _putstr
;
; Put ASCIIZ string to screen
; In:
;   AH - attribute
;   BL - X
;   BH - Y
;   EDX -> ASCIIZ string
;
_putstr:
        push ax esi edi
        movzx edi,bh
        imul edi,SCRX*2
        movzx si,bl
        shl si,1
        add di,si
        add edi,_vgatextptr
        mov esi,edx
putstrl0:
        lodsb
        or al,al
        jz short putstrd
        stosw
        jmp putstrl0
putstrd:
        pop edi esi ax
        ret
endif

ifdef   PUSHPOPTEXT
public  _pushtext, _poptext
;
; Save an area of the screen to video stack
; In:
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;
_pushtext:
        pushad
        mov ebp,_textstakptr
        mov word ptr ds:[ebp].lx,bx
        mov word ptr ds:[ebp].dlx,cx
        lea edi,[ebp+8]
        movzx esi,bh
        imul esi,SCRX*2
        movzx eax,bl
        lea esi,[esi+eax*2]
        add esi,_vgatextptr
        movzx edx,cl
        lea ebx,[edx*2-SCRX*2]
        mov al,ch
pushtextl0:
        mov ecx,edx
        rep movsw
        sub esi,ebx
        dec al
        jnz pushtextl0
        mov [edi],ebp
        mov _textstakptr,edi
        popad
        ret

;
; Restore last pushed area of the screen from video stack
;
_poptext:
        pushad
        mov ebp,_textstakptr
        mov eax,ds:[ebp]
        or eax,eax
        jz short poptextdone
        mov ebp,eax
        lea esi,[ebp+8]
        movzx edi,ds:[ebp].ly
        imul edi,SCRX*2
        movzx eax,ds:[ebp].lx
        lea edi,[edi+eax*2]
        add edi,_vgatextptr
        movzx edx,ds:[ebp].dlx
        lea ebx,[edx*2-SCRX*2]
        movzx eax,ds:[ebp].dly
poptextl0:
        mov ecx,edx
        rep movsw
        sub edi,ebx
        dec eax
        jnz poptextl0
poptextdone:
        mov _textstakptr,ebp
        popad
        ret
endif

ifdef   TEXTBOX0
public  _textbox0
;
; Put box filled with character to screen
; In:
;   AL - character to fill with
;   AH - attribute
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;
_textbox0:
        pushad
        movzx ebp,ch
        movzx edx,cl
        movzx edi,bh
        imul edi,SCRX*2
        movzx ebx,bl
        shl ebx,1
        add edi,ebx
        add edi,_vgatextptr
        lea esi,[edx*2-SCRX*2]
textbox0l0:
        mov ecx,edx
        rep stosw
        sub edi,esi
        dec ebp
        jnz textbox0l0
        popad
        ret
endif

ifdef   TEXTBOX1
public  _textbox1
;
; Put outlined box to screen
; In:
;   AH - attribute
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;   EDX -> outlining characters in the following order 'ĳڿf'
;
_textbox1:
        pushad
        movzx edi,bh
        imul edi,SCRX*2
        movzx ebx,bl
        lea edi,[edi+ebx*2]
        add edi,_vgatextptr
        lea ebx,[ecx-202h]
        movzx ebp,bl
        movzx esi,cl
        lea esi,[esi*2-SCRX*2]
        mov al,[edx+2]
        stosw
        mov al,[edx]
        mov ecx,ebp
        rep stosw
        mov al,[edx+3]
        stosw
        sub edi,esi
textbox1l0:
        mov al,[edx+1]
        stosw
        mov al,[edx+6]
        mov ecx,ebp
        rep stosw
        mov al,[edx+1]
        stosw
        sub edi,esi
        dec bh
        jnz textbox1l0
        mov al,[edx+4]
        stosw
        mov al,[edx]
        mov ecx,ebp
        rep stosw
        mov al,[edx+5]
        stosw
        popad
        ret
endif

ifdef   SETCHARS
public  _setchars
;
; Set a group of character bitmaps
; In:
;   AL - first ASCII character to set
;   BL - number of bytes (lines) per character
;   CL - number of characters to set minus 1
;   EDX -> bitmap data for characters
; Notes:
;   Remember that in 80 column mode, character column 9 will be the same as
;    column 8 only for characters 0c0h-0dfh, in all other characters column 9
;    will be empty.
;
_setchars:
        push ax ecx edx esi edi
        mov esi,edx
        movzx edi,al
        shl edi,5
        add edi,0b8000h
        sub edi,_code32a
        mov dx,3c4h
        mov ax,00402h
        out dx,ax
        mov ax,00604h
        out dx,ax
        mov dx,3ceh
        mov ax,00c06h
        out dx,ax
        mov al,cl
        movzx edx,bl
        dec dl
        xor dl,1fh
setcharsl0:
        movzx ecx,bl
        rep movsb
        add edi,edx
        sub al,1
        jnc setcharsl0
        mov dx,3c4h
        mov ax,00302h
        out dx,ax
        mov ax,00204h
        out dx,ax
        mov dx,3ceh
        mov ax,00e06h
        out dx,ax
        pop edi esi edx ecx ax
        ret
endif

ifdef   GETSTR
public  _getstr
lowercasetbl    db      '`1234567890-=\qwertyuiop[]asdfghjkl;''zxcvbnm,./'
lowercasetbllen=$-lowercasetbl
uppercasetbl    db      '~!@#$%^&*()_+|QWERTYUIOP{}ASDFGHJKL:"ZXCVBNM<>?'
;
; Read string from keyboard to screen
; In:
;   AH - screen attribute
;   AL - input attribute bit 0 = make all letters uppercase
;   BL - X
;   BH - Y
;   CL - max count for string
;   EDX -> string buffer
;   EBP -> ASCIIZ list of characters to accept (first byte is # present)
; Out:
;   CF=0 string completed fine
;   CF=1 string entry aborted
;
_getstr:
        pushad
        movzx edi,bh
        imul edi,160
        movzx ebx,bl
        lea edi,[edi+ebx*2]
        add edi,_vgatextptr
        mov esi,edx
        mov bh,cl
        xor bl,bl
        mov edx,eax
getstrl0:
        lodsb
        or al,al
        jz short getstrl0d
        stosw
        inc bl
        jmp getstrl0
getstrl0d:
        mov esi,edi
        mov cl,bl
        mov al,' '
getstrl1:
        cmp cl,bh
        jae short getstrml
        stosw
        inc cl
        jmp getstrl1
getstrml:
        cmp bl,bh
        je short getstrmlf0
        mov ah,dh
        mov al,''
        mov [esi],ax
getstrmlf0:
        call _getch
        cmp al,14
        je short getstrabort
        cmp al,16
        je short getstrbs
        cmp al,13
        je short getstrdone
        cmp bl,bh
        jae getstrmlf0
        test dl,1
        jz short getstrmlf1
        cmp al,'a'
        jb short getstrmlf1
        cmp al,'z'
        ja short getstrmlf1
        or ah,1
getstrmlf1:
        test ah,1
        jz short getstrmlf2
        mov edi,offset lowercasetbl
        mov ecx,lowercasetbllen
        repnz scasb
        jnz getstrmlf0
        mov al,[edi+lowercasetbllen-1]
getstrmlf2:
        lea edi,[ebp+1]
        movzx ecx,byte ptr [ebp]
        repnz scasb
        jnz getstrmlf0
        mov al,[edi-1]
        mov ah,dh
        mov [esi],ax
        add esi,2
        inc bl
        jmp getstrml
getstrbs:
        or bl,bl
        jz getstrmlf0
        call getstrremove
        dec bl
        sub esi,2
        jmp getstrml
getstrabort:
        call getstrremove
        popad
        stc
        ret
getstrremove:
        cmp bl,bh
        je short getstrremovef0
        mov ah,dh
        mov al,' '
        mov [esi],ax
getstrremovef0:
        ret
getstrdone:
        call getstrremove
        mov edi,[esp+20]
        movzx ebx,bl
        sub esi,ebx
        sub esi,ebx
getstrdonel0:
        or bl,bl
        jz short getstrdonel0d
        movsb
        inc esi
        dec bl
        jmp getstrdonel0
getstrdonel0d:
        xor al,al
        stosb
        popad
        clc
        ret
endif


code32  ends
        end

