/* cshit.c :
    compile With
      gcc -shared -Wl,--strip-all -o cshit.dll cshit.c
*/
#include <stdio.h>
#include <assert.h>
#include "fmopl.h"
#include "portaudio.h"
#include <stdlib.h>

FM_OPL *opl;
PortAudioStream *stream;

int patestCallback(  void *inputBuffer, void *outputBuffer,
                     unsigned long framesPerBuffer,
                     PaTimestamp outTime, void *userData )
{
    unsigned int i;
    signed short *out = (signed short*)outputBuffer;

    YM3812UpdateOne(opl, out, framesPerBuffer);
   
    return 0;
}

__declspec(dllexport) void oplinit()
{
  int err;
  
  opl = OPLCreate(OPL_TYPE_YM3812, 3579545, 44100);
  assert(Pa_Initialize() == paNoError);
  err = Pa_OpenDefaultStream(
      &stream,        /* passes back stream pointer */
      0,              /* no input channels */
      1,              /* stereo output */
      paInt16,
      44100,          /* sample rate */
      256,            /* frames per buffer */
      0,              /* number of buffers, if zero then use default minimum */
      patestCallback, /* specify our custom callback */
      NULL );        /* pass our data through to callback */
  assert(err == paNoError);
  assert(Pa_StartStream(stream) == paNoError);
}

__declspec(dllexport) void oplout(int r, int v)
{
  OPLWrite(opl, 0, r);
  OPLWrite(opl, 1, v);
}
