#lang "fblite"
OPTION GOSUB
DEFINT A-Z

#inclib "cshit"
#include once "windows.bi"
#include once "win\commdlg.bi"

'$INCLUDE: 'textmode.bi'
'$INCLUDE: 'ems.bi'
'$INCLUDE: 'keycodes.bi'


DECLARE SUB eraseptn(ptn%)
DECLARE SUB modptrs (arr() AS LONG)
DECLARE SUB timerOn ()
DECLARE SUB timerOff ()
DECLARE SUB edpostobuf ()
DECLARE SUB initmainscreen ()
DECLARE SUB showpattern ()
DECLARE SUB showorder ()
DECLARE FUNCTION editpattern% ()
DECLARE SUB updchannelnos ()
DECLARE FUNCTION getfilename% (dest$, prompt$)
DECLARE SUB loadmod (filenm$)
DECLARE FUNCTION readb% (fh%)
DECLARE SUB eraseins (ini%)
DECLARE SUB savemod (filenm$)
DECLARE SUB writeb (fh%, b%)
DECLARE SUB exchinstr (kei%)
DECLARE FUNCTION hexscan% (k%)
DECLARE SUB buftoedpos ()
DECLARE SUB opl.playnote (v%, frq%, oct%)
DECLARE SUB opl.setinstr (v%, i AS ANY)
DECLARE SUB opl.out (reg%, vlu%)
DECLARE FUNCTION editinstr% ()
DECLARE SUB instoinsed (insno%)
DECLARE SUB insedtoins (insno%)
DECLARE FUNCTION editorder% ()
DECLARE FUNCTION getkeyc% ()
DECLARE SUB showwatch ()
DECLARE SUB opl.silence ()
DECLARE FUNCTION RequestFile$ ()

'OPEN "debug.txt" FOR OUTPUT as #5

'extern "c"
'declare function SDL_Init (byval flags as Uint32) as integer
'declare sub SDL_QuitSubSystem (byval flags as Uint32)
'end extern

EXTERN "Windows-MS"
DECLARE SUB oplinit ()
DECLARE SUB oplout (BYVAL r AS UINTEGER, BYVAL v AS UINTEGER)
END EXTERN

CONST FRAMELENGTH# = 0.02

CONST ModeDeath = 0
CONST ModePattern = 1
CONST ModeOrder = 2
CONST ModeInstrument = 3

CONST IE.MUL1 = 0
CONST IE.LEV1 = 1
CONST IE.ATD1 = 2
CONST IE.SUR1 = 3
CONST IE.VIB1 = 4
CONST IE.TRE1 = 5
CONST IE.EGS1 = 6
CONST IE.WAV1 = 7
CONST IE.MUL2 = 8
CONST IE.LEV2 = 9
CONST IE.ATD2 = 10
CONST IE.SUR2 = 11
CONST IE.VIB2 = 12
CONST IE.TRE2 = 13
CONST IE.EGS2 = 14
CONST IE.WAV2 = 15
CONST IE.FEED = 16
CONST IE.CONN = 17

TYPE Instrument
	mul1 AS INTEGER
	mul2 AS INTEGER
	lev1 AS INTEGER
	lev2 AS INTEGER
	atd1 AS INTEGER
	atd2 AS INTEGER
	sur1 AS INTEGER
	sur2 AS INTEGER
	wav1 AS INTEGER
	wav2 AS INTEGER
	fbcon AS INTEGER
END TYPE

DIM SHARED VocOff(0 TO 8)
DIM SHARED vocvol(0 TO 8)
DIM SHARED flgarp(0 TO 8)
DIM SHARED frqtab(0 TO 11)
DIM SHARED notenm(0 TO 1, 0 TO 12)
DIM SHARED keyhex(0 TO 15)
DIM SHARED keyloct(0 TO 11), keylovr(0 TO 4)
DIM SHARED keyhoct(0 TO 11), keyhovr(0 TO 4)
DIM SHARED modptr(0 TO 8) AS LONG

DIM SHARED length
DIM SHARED ord(0 TO 8, 0 TO 255)
DIM SHARED ins(0 TO 32) AS Instrument
DIM SHARED nbuf(0 TO 63, 0 TO 8)
DIM SHARED obuf(0 TO 63, 0 TO 8)
DIM SHARED ibuf(0 TO 63, 0 TO 8)
DIM SHARED ehbuf(0 TO 63, 0 TO 8)
DIM SHARED elbuf(0 TO 63, 0 TO 8)
DIM SHARED silence AS Instrument

DIM SHARED ordclip(0 TO 8)
DIM SHARED nclip(0 TO 63)
DIM SHARED oclip(0 TO 63)
DIM SHARED iclip(0 TO 63)
DIM SHARED ehclip(0 TO 63)
DIM SHARED elclip(0 TO 63)

DIM SHARED ecliph(0 TO 63)
DIM SHARED eclipl(0 TO 63)

DIM SHARED nblk(0 TO 63)
DIM SHARED oblk(0 TO 63)
DIM SHARED iblk(0 TO 63)
DIM SHARED ehblk(0 TO 63)
DIM SHARED elblk(0 TO 63)

DIM SHARED edpos, edrow, lmchan
DIM SHARED edkolon, edvoice
DIM SHARED playing, speed, follow
DIM SHARED edoct, edini

DIM SHARED vocnte(0 TO 8), vococt(0 TO 8), vocini(0 TO 8)
DIM SHARED vocfrq(0 TO 8)

DIM SHARED posjmp, ptnbrk
DIM SHARED frqshift(0 TO 8), frqadd(0 TO 8)

DIM SHARED prtsrcfrq(0 TO 8), prtsrco(0 TO 8)
DIM SHARED prtdstfrq(0 TO 8), prtdsto(0 TO 8)
DIM SHARED prtadd(0 TO 8), prtsign(0 TO 8)

DIM SHARED arpfrq(0 TO 2, 0 TO 8), arpoct(0 TO 2, 0 TO 8)
DIM SHARED lasteh(0 TO 8), lastel(0 TO 8)

DIM SHARED iv(0 TO 17)

DIM SHARED hlppattern$, hlporder$, hlpinstr$
DIM SHARED hlpfilereq$

DIM SHARED mptr AS LONG
DIM SHARED mins, secs, watch

DIM SHARED nofilereq

DIM SHARED thread AS ANY PTR
DIM SHARED timerTerminate
DIM SHARED requestShowpattern, requestShoworder
DIM SHARED requestShowwatch

nofilereq = 0
'arg$ = UCASE$(COMMAND(1))
'print arg$
'IF INSTR(arg$, "WITHFILEREQ") THEN nofilereq = 0

VocOff:
DATA 0,1,2,8,9,10,16,17,18
RESTORE VocOff
FOR a = 0 TO 8
	READ VocOff(a)
	vocvol(a) = 63
NEXT a

DATA &H157,&H16B,&H181,&H198,&H1B0,&H1CA
DATA &H1E5,&H202,&H220,&H241,&H263,&H287
FOR a = 0 TO 11
	READ frqtab(a)
NEXT a

DATA  48, 49, 50, 51, 52, 53, 54, 55
DATA  56, 57, 97, 98, 99, 100, 101, 102
FOR a = 0 TO 15
	READ keyhex(a)
NEXT a

DATA "C-","C#","D-","D#","E-","F-"
DATA "F#","G-","G#","A-","A#","B-",".."
FOR a = 0 TO 12
	READ nnm$
	FOR b = 0 TO 1
		notenm(b, a) = ASC(MID$(nnm$, b + 1, 1))
	NEXT b
NEXT a

DATA  121, 115, 120, 100, 99, 118, 103, 98
DATA  104, 110, 106, 109
DATA  44, 108, 46, 148, 45
DATA  113, 50, 119, 51, 101, 114, 53, 116
DATA  54, 122, 55, 117
DATA  105, 57, 111, 48, 112
FOR i = 0 TO 11: READ keyloct(i): NEXT i
FOR i = 0 TO 4: READ keylovr(i): NEXT i
FOR i = 0 TO 11: READ keyhoct(i): NEXT i
FOR i = 0 TO 4: READ keyhovr(i): NEXT i

DATA &H3F, &H3F, &H0F, &H0F, &H0F, &H0F
READ silence.lev1, silence.lev2
READ silence.atd1, silence.atd2
READ silence.sur1, silence.sur2
speed = 6
edoct = 2
edini = 1

DATA "<1EPattern Editor<n<n"
DATA "<06(Ctl+)Cursor,<n"
DATA "PgUp/Down,Home,End<n"
DATA "<07- move around<n<n"
DATA "<06Ins,Del,Backspace<n"
DATA "<07- edit<n<n"
DATA "<06F1<07  - edit order<n"
DATA "<06F3<07  - edit instr.<n"
DATA "<06F4<07  - load module<n"
DATA "<06F5<07  - save module<n"
DATA "<06F6<07  - cut ptn.<n"
DATA "<06F7<07  - copy ptn.<n"
DATA "<06F8<07  - paste ptn.<n<n"
DATA "<06-<07   - prev. ptn.<n"
DATA "<06+<07   - next ptn.<n"
DATA "<06/<07 - octave down<n"
DATA "<06*<07 - octave up<n"
DATA "<06<<<07 - prev. instrument<n"
DATA "<06><07 - next instrument<n<n"
DATA "<06Space<07 - play<n<n"
DATA "<06Sh+Up,Sh+Down<07<n"
DATA "- mark block<n<n"
DATA "<06Sh+F6,Sh+F7,Sh+F8<07<n"
DATA "- cut/copy/paste<n"
DATA "  block<n<n"
DATA "<06Sh+F5,Ctl+F5<07<n"
DATA "- exch. instrument in<n"
DATA "  this ptrn/all ptrns<n<n"
DATA "<06Ctl+F6,Ctl+F7,Ctl+F8<07<n"
DATA "- cut/copy/paste<n"
DATA "  effect commands<n<n"
DATA "<06Sh+F1,Sh+F2<07<n"
DATA "- transpose pattern<n<n"
DATA "<06Ctl+F2<07 - zap song<n"
DATA "<06Ctl+F3<07 - zap instrs."

FOR l% = 1 TO 35
	READ st$
	hlppattern$ = hlppattern$ + st$
NEXT l%

DATA "<1EOrder Editor<n<n"
DATA "<06(Ctl+)Cursor<n"
DATA "<07- move around<n<n"
DATA "<06Ins,Del,0..F<n"
DATA "<07- edit<n<n"
DATA "<06F2<07  - edit pattern<n"
DATA "<06F3<07  - edit instr.<n"
DATA "<06F6<07  - cut line<n"
DATA "<06F7<07  - copy line<n"
DATA "<06F8<07  - paste line<n<n"
DATA "<06-<07     - prev. ptn.<n"
DATA "<06+<07     - next ptn."
FOR l% = 1 TO 12
	READ st$
	hlporder$ = hlporder$ + st$
NEXT l%

DATA "<1EInstr. Editor<n<n"
DATA "<06(Ctl+)Cursor<n"
DATA "<07- move around<n<n"
DATA "<06Cursor,0..F<n"
DATA "<07- edit<n<n"
DATA "<06F1<07  - edit order<n<n"
DATA "<06F2<07  - edit pattern<n"
DATA "<06F4<07  - load instr.<n"
DATA "<06F5<07  - save instr.<n"
DATA "<06F7<07  - copy instr.<n"
DATA "<06F8<07  - paste instr.<n<n"
DATA "<06<<<07 - prev. instrument<n"
DATA "<06><07 - next instrument<n"
DATA "<06-<07 - test note down<n"
DATA "<06+<07 - test note up<n<n"
DATA "<06Space<07<n - play test note"
FOR l% = 1 TO 16
	READ st$
	hlpinstr$ = hlpinstr$ + st$
NEXT l%

DATA "<1EFile Requester<n<n"
DATA "<06Cursor,(Sh+)Tab,<n"
DATA "PgUp/Down<n"
DATA "<07- move around<n<n"
DATA "<06Enter<07 - select<n"
DATA "<06Esc<07   - abort<n<n"
DATA "Enter a filename<n"
DATA "by typing it."
FOR l = 1 TO 8
	READ st$
	hlpfilereq$ = hlpfilereq$ + st$
NEXT l

FOR a = 0 TO 8
	vocini(a) = -1
NEXT a

FOR p = 0 TO 203
	eraseptn p
NEXT p

SCREEN 17
WIDTH 80, 50

DATA  0, 8,12,  5, 5,24,  7,13,17, 10,10,47
DATA 27,33,37, 19,19,19, 45,45,39, 39,39,39
DATA 23,28,23, 28,33,28, 33,38,33, 38,43,38
DATA 43,48,43,  0, 0, 0, 55,55,37,  0, 0, 0
FOR c = 0 TO 15
	READ r, g, b
	setrgb c, r, g, b
NEXT c

'settypematic 0, 0
length = 1
modptrs modptr()
edpostobuf

COLOR 14
PRINT "SOS (SLEEPING PENNER OPERATING SYSTEM) v0.666"
PRINT ">BT"
PRINT CHR$(219)

oplinit
oplout 1, &H20 'enable waveform control

CLS
initmainscreen
showpattern
showorder

mode = ModePattern
DO
	SELECT CASE mode
		CASE ModePattern:
			mode = editpattern
		CASE ModeOrder:
			mode = editorder
		CASE ModeInstrument:
			mode = editinstr
	END SELECT
LOOP UNTIL mode = ModeDeath

'CLOSE #5


SUB eraseptn (ptn)
	DIM ofs AS LONG

	ofs = 320& * ptn
	FOR r = 0 TO 63
		ems.poke ofs, 12: ofs = ofs + 1
		ems.poke ofs, 0: ofs = ofs + 1
		ems.poke ofs, 0: ofs = ofs + 1
		ems.poke ofs, 0: ofs = ofs + 1
		ems.poke ofs, 0: ofs = ofs + 1
	NEXT r
END SUB

SUB modptrs (arr() AS LONG)
	arr(0) = 320& * ord(0, edpos)
	arr(1) = 320& * ord(1, edpos)
	arr(2) = 320& * ord(2, edpos)
	arr(3) = 320& * ord(3, edpos)
	arr(4) = 320& * ord(4, edpos)
	arr(5) = 320& * ord(5, edpos)
	arr(6) = 320& * ord(6, edpos)
	arr(7) = 320& * ord(7, edpos)
	arr(8) = 320& * ord(8, edpos)
END SUB

SUB timerProc(param AS ANY PTR) STATIC
	DIM current AS DOUBLE, last AS DOUBLE, elapsed AS DOUBLE

	'    PRINT #5, "enter timerProc"
	last = TIMER - FRAMELENGTH
	DO WHILE timerTerminate=0
		current = TIMER
		elapsed = current - last
		IF elapsed >= FRAMELENGTH THEN
			last = current - (elapsed - FRAMELENGTH)
			GOSUB Frame
		END IF
		SLEEP 1, 1
	LOOP

	Frame:
	'    IF framelock = 1 THEN RETURN
	'    framelock = 1
	count = count + 1
	IF count = speed THEN
		FOR v = 0 TO 8
			n = nbuf(edrow, v)
			o = obuf(edrow, v)
			i = ibuf(edrow, v)
			eh = ehbuf(edrow, v)
			el = elbuf(edrow, v)
			IF eh = 3 THEN
				IF i THEN
					IF vocini(v) <> i THEN
						opl.setinstr v, ins(i)
						vocini(v) = i
					END IF
					IF vocvol(v) < 63 THEN
						l1 = 64 - (64 * (64 - ins(i).lev1) \ 64)
						l2 = 64 - (64 * (64 - ins(i).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
					END IF
					vocvol(v) = 63
				END IF
				IF n < 12 THEN
					frq = vocfrq(v)
					okt = vococt(v)
					prtsrcfrq(v) = frq
					prtsrco(v) = okt
					prtdstfrq(v) = frqtab(n)
					prtdsto(v) = o
					IF prtdsto(v) < okt THEN
						prtsign(v) = -1
					ELSEIF prtdsto(v) > okt THEN
						prtsign(v) = 1
					ELSE
						IF prtdstfrq(v) < frq THEN
							prtsign(v) = -1
						ELSE
							prtsign(v) = 1
						END IF
					END IF
				END IF
			ELSEIF i THEN
				IF n < 12 THEN
					'n+i
					lastel(v) = -1
					opl.out &HB0 + v, 0
					IF eh <> &HC THEN
						IF vocini(v) <> i THEN
							opl.setinstr v, ins(i)
							vocini(v) = i
						ELSEIF vocvol(v) < 63 THEN
							l1 = 64 - (64 * (64 - ins(i).lev1) \ 64)
							l2 = 64 - (64 * (64 - ins(i).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
						END IF
						vocvol(v) = 63
					ELSE
						IF vocini(v) <> i THEN
							opl.setinstr v, ins(i)
							vocini(v) = i
						END IF
						l1 = 62 - (el * (64 - ins(i).lev1) \ 64)
						l2 = 62 - (el * (64 - ins(i).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
						vocvol(v) = el
					END IF
					frq = frqtab(n)
					opl.out &HA0 + v, frq
					opl.out &HB0 + v, 32 OR (4 * o) OR (frq \ 256)
					vocnte(v) = n
					vococt(v) = o
					vocfrq(v) = frq
				ELSE
					'i
					IF vocini(v) <> i THEN
						opl.setinstr v, ins(i)
						vocini(v) = i
						IF eh = &HC THEN
							l1 = 62 - (el * (64 - ins(i).lev1) \ 64)
							l2 = 62 - (el * (64 - ins(i).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
							vocvol(v) = el
						ELSEIF vocvol(v) < 63 THEN
							l1 = 64 - (vocvol(v) * (64 - ins(i).lev1) \ 64)
							l2 = 64 - (vocvol(v) * (64 - ins(i).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
						END IF
					END IF
					IF lastel(v) THEN
						IF lasteh(v) = 0 THEN
							frq = vocfrq(v)
							opl.out &HA0 + v, frq
							opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
						END IF
					END IF
				END IF
			ELSE
				IF n < 12 THEN
					'n
					lastel(v) = -1
					IF eh = &HC THEN
						ti = vocini(v)
						IF ti >= 0 THEN
							l1 = 62 - (el * (64 - ins(ti).lev1) \ 64)
							l2 = 62 - (el * (64 - ins(ti).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
							vocvol(v) = el
						END IF
					ELSEIF vocvol(v) < 63 THEN
						ti = vocini(v)
						IF ti >= 0 THEN
							l1 = 64 - (vocvol(v) * (64 - ins(ti).lev1) \ 64)
							l2 = 64 - (vocvol(v) * (64 - ins(ti).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
						END IF
					END IF
					frq = frqtab(n)
					opl.out &HA0 + v, frq
					opl.out &HB0 + v, 32 OR (4 * o) OR (frq \ 256)
					vocnte(v) = n
					vococt(v) = o
					vocfrq(v) = frq
				ELSE
					'e?
					IF eh = &HC THEN
						ti = vocini(v)
						IF ti >= 0 THEN
							l1 = 62 - (el * (64 - ins(ti).lev1) \ 64)
							l2 = 62 - (el * (64 - ins(ti).lev2) \ 64)
							opl.out &H40 + VocOff(v), l1
							opl.out &H43 + VocOff(v), l2
							vocvol(v) = el
						END IF
					END IF
					IF lastel(v) THEN
						IF lasteh(v) = 0 THEN
							frq = vocfrq(v)
							opl.out &HA0 + v, frq
							opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
						END IF
					END IF
				END IF
			END IF

			SELECT CASE eh
				CASE 0:
					IF el THEN
						IF el <> lastel(v) THEN
							n = vocnte(v)
							o = vococt(v)
							arpfrq(0, v) = frqtab(n)
							arpoct(0, v) = o
							an1 = n + (el \ 16)
							an2 = n + (el AND 15)
							IF an1 < 12 THEN
								arpfrq(1, v) = frqtab(an1)
								arpoct(1, v) = o
							ELSE
								arpfrq(1, v) = frqtab(an1 - 12)
								arpoct(1, v) = o + 1
							END IF
							IF an2 < 12 THEN
								arpfrq(2, v) = frqtab(an2)
								arpoct(2, v) = o
							ELSE
								arpfrq(2, v) = frqtab(an2 - 12)
								arpoct(2, v) = o + 1
							END IF
						END IF
						flgarp(v) = 1
					ELSE
						flgarp(v) = 0
					END IF
					frqadd(v) = 0
					prtadd(v) = 0
				CASE &H1:
					prtadd(v) = 0
					flgarp(v) = 0
					frqadd(v) = el
				CASE &H2:
					prtadd(v) = 0
					flgarp(v) = 0
					frqadd(v) = -el
				CASE &H3:
					frqadd(v) = 0
					flgarp(v) = 0
					prtadd(v) = el
				CASE &HB:
					frqadd(v) = 0
					prtadd(v) = 0
					flgarp(v) = 0
					posjmp = el
				CASE &HD:
					frqadd(v) = 0
					prtadd(v) = 0
					flgarp(v) = 0
					ptnbrk = el
				CASE &HF:
					frqadd(v) = 0
					prtadd(v) = 0
					flgarp(v) = 0

					IF el THEN
						speed = el
					ELSE
						timerOff
						playing = 0
					END IF

				CASE &HE:
					SELECT CASE (el \ 16)
						CASE 6:
							IF e6x = 0 THEN
								IF ((el AND 15) = 0) THEN
									e6xrow = edrow
								ELSE
									e6xcount = el AND 15
									e6x = 1
								END IF
							END IF
							IF e6x = 1 THEN
								IF ((el AND 15) > 0) THEN
									e6xcount = e6xcount - 1
									IF e6xcount >= 0 THEN
										edrow = e6xrow - 1
									ELSE
										e6x = 0
									END IF
								END IF
							END IF
						CASE &HA:
							ti = vocini(v)
							IF ti >= 0 THEN
								lol = vocvol(v) + (el AND 15)
								IF lol > 63 THEN lol = 63
								l1 = 64 - (lol * (64 - ins(ti).lev1) \ 64)
								l2 = 64 - (lol * (64 - ins(ti).lev2) \ 64)
								opl.out &H40 + VocOff(v), l1
								opl.out &H43 + VocOff(v), l2
								vocvol(v) = lol
							END IF
						CASE &HB:
							ti = vocini(v)
							IF ti >= 0 THEN
								lol = vocvol(v) - (el AND 15)
								IF lol < 2 THEN lol = 2
								l1 = 64 - (lol * (64 - ins(ti).lev1) \ 64)
								l2 = 64 - (lol * (64 - ins(ti).lev2) \ 64)
								opl.out &H40 + VocOff(v), l1
								opl.out &H43 + VocOff(v), l2
								vocvol(v) = lol
							END IF
					END SELECT
					frqadd(v) = 0
					prtadd(v) = 0
					flgarp(v) = 0
			END SELECT
			lasteh(v) = eh
			lastel(v) = el
		NEXT v
		opos = edpos
		IF posjmp >= 0 THEN
			edpos = posjmp
			IF ptnbrk = -1 THEN
				edrow = 0
			ELSE
				edrow = ptnbrk
				ptnbrk = -1
			END IF
			posjmp = -1
		ELSEIF ptnbrk >= 0 THEN
			edpos = edpos + 1
			IF edpos = length THEN edpos = 0
			edrow = ptnbrk
			ptnbrk = -1
		ELSE
			edrow = edrow + 1
			IF edrow = 64 THEN
				edpos = edpos + 1
				IF edpos = length THEN edpos = 0
				edrow = 0
			END IF
		END IF
		IF edpos <> opos THEN
			modptr(0) = 320& * ord(0, edpos)
			modptr(1) = 320& * ord(1, edpos)
			modptr(2) = 320& * ord(2, edpos)
			modptr(3) = 320& * ord(3, edpos)
			modptr(4) = 320& * ord(4, edpos)
			modptr(5) = 320& * ord(5, edpos)
			modptr(6) = 320& * ord(6, edpos)
			modptr(7) = 320& * ord(7, edpos)
			modptr(8) = 320& * ord(8, edpos)
			FOR v = 0 TO 8
				mptr = modptr(v)
				FOR r = 0 TO 63
					nbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
					obuf(r, v) = ems.peek(mptr): mptr = mptr + 1
					ibuf(r, v) = ems.peek(mptr): mptr = mptr + 1
					ehbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
					elbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
				NEXT r
			NEXT v
			IF follow THEN requestShoworder = 1
		END IF
		IF follow THEN requestShowpattern = 1
		count = 0
	ELSE
		arpi = arpi + 1
		IF arpi = 3 THEN arpi = 0
		FOR v = 0 TO 8
			IF frqadd(v) THEN
				vocfrq(v) = vocfrq(v) + frqadd(v)
				frq = vocfrq(v)
				opl.out &HA0 + v, frq
				opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
			ELSEIF prtadd(v) THEN
				frq = vocfrq(v)
				okt = vococt(v)

				IF prtsign(v) = 1 THEN
					frq = frq + prtadd(v)
					IF okt = prtdsto(v) THEN
						IF frq > prtdstfrq(v) THEN
							frq = prtdstfrq(v)
							prtadd(v) = 0
						END IF
					END IF
					IF frq > &H287 THEN
						frq = &H143 + (frq - &H287)
						okt = okt + 1
					END IF
				ELSE
					frq = frq - prtadd(v)
					IF okt = prtdsto(v) THEN
						IF frq < prtdstfrq(v) THEN
							frq = prtdstfrq(v)
							prtadd(v) = 0
						END IF
					END IF
					IF frq < &H157 THEN
						frq = &H2AE - (&H157 - frq)
						okt = okt - 1
					END IF
				END IF
				opl.out &HA0 + v, frq
				opl.out &HB0 + v, 32 OR (4 * okt) OR (frq \ 256)
				vocfrq(v) = frq
				vococt(v) = okt
			ELSEIF flgarp(v) THEN
				frq = arpfrq(arpi, v)
				opl.out &HA0 + v, frq
				opl.out &HB0 + v, 32 OR (4 * arpoct(arpi, v)) OR (frq \ 256)
			END IF
		NEXT v
	END IF

	watch = watch + 1
	IF watch = 50 THEN
		secs = secs + 1
		IF secs = 60 THEN mins = mins + 1: secs = 0
		requestShowwatch = 1
		watch = 0
	END IF
	'    framelock=0
	RETURN

END SUB

SUB timerOn
	'    PRINT #5, "enter timerOn"
	timerTerminate = 0
	thread = THREADCREATE(@timerProc)
END SUB

SUB timerOff
	timerTerminate = 1
	THREADWAIT thread
END SUB

'assumes modptrs are adjusted to row 0 of edpos
'
SUB edpostobuf
	IF playing THEN timerOff
	FOR v = 0 TO 8
		mptr = modptr(v)
		FOR r = 0 TO 63
			nbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
			obuf(r, v) = ems.peek(mptr): mptr = mptr + 1
			ibuf(r, v) = ems.peek(mptr): mptr = mptr + 1
			ehbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
			elbuf(r, v) = ems.peek(mptr): mptr = mptr + 1
		NEXT r
	NEXT v
	IF playing THEN
		'        PRINT #5, "calling timerOn from edpostobuf"
		timerOn
	END IF
END SUB

SUB initmainscreen
	x = 2

	con.clear

	con.atrseg 0, 10, 58, 12
	con.atrseg 0, 9, 58, 11
	con.atrseg 0, 8, 58, 10
	con.atrseg 0, 6, 58, 9
	con.atrseg 0, 5, 58, 8
	con.atrseg 0, 4, 58, 8
	FOR c = 0 TO 4
		con.box x, 3, 12, 9, 4
		con.box x, 11, 12, 34, 4
		x = x + 11
	NEXT c

	con.atrseg 0, 28, 58, &H17
	con.atrseg 0, 7, 58, &H17

	con.putstrxy ".-* REVENGE OF BENI TRACKER *-.", 14, 0
	con.putstrxy "Ported from pure QB4.5 by one guy from SPP", 9, 1

	con.atrseg 14, 0, 32, 14
	con.atrseg 9, 1, 42, 14

	ofs = 1774
	FOR a = 0 TO 4
		con.poke ofs, a + 48: ofs = ofs + 1
		con.poke ofs, 7
		ofs = ofs + 21
	NEXT a

	o$ = "0" + HEX$(edoct)
	i$ = HEX$(edini)
	IF edini < 16 THEN i$ = "0" + i$
	con.putstrxy "Octave: " + o$, 0, 47
	con.putstrxy "Instr.: " + i$, 0, 48

	con.atrseg 0, 49, 60, 14
END SUB

'obfuscated = fast. readability fakk!
'
SUB showpattern
	ofs = 1920
	r = edrow - 16
	WHILE r < 0
		con.poke ofs, 32: ofs = ofs + 2
		con.poke ofs, 32: ofs = ofs + 4
		FOR c = 0 TO 4
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 4
		NEXT c
		ofs = ofs + 44
		r = r + 1
		sr = sr + 1
	WEND
	WHILE r < 64
		IF sr = 32 THEN EXIT SUB
		IF r < 16 THEN
			con.poke ofs, 48: ofs = ofs + 2
			IF r < 10 THEN
				con.poke ofs, r + 48
			ELSE
				con.poke ofs, r + 55
			END IF
			ofs = ofs + 4
		ELSE
			h = r \ 16
			IF h < 10 THEN
				con.poke ofs, h + 48
			ELSE
				con.poke ofs, h + 55
			END IF
			ofs = ofs + 2
			l = r AND 15
			IF l < 10 THEN
				con.poke ofs, l + 48
			ELSE
				con.poke ofs, l + 55
			END IF
			ofs = ofs + 4
		END IF
		FOR v = lmchan TO lmchan + 4
			n = nbuf(r, v)
			con.poke ofs, notenm(0, n): ofs = ofs + 2
			con.poke ofs, notenm(1, n): ofs = ofs + 2
			IF n < 12 THEN
				con.poke ofs, obuf(r, v) + 48
			ELSE
				con.poke ofs, 46
			END IF
			ofs = ofs + 4
			i = ibuf(r, v)
			IF i = 0 THEN
				con.poke ofs, 46: ofs = ofs + 2
				con.poke ofs, 46
			ELSE
				con.poke ofs, 49 + (i < 16): ofs = ofs + 2
				i = i AND 15
				IF i < 10 THEN
					con.poke ofs, 48 + i
				ELSE
					con.poke ofs, 55 + i
				END IF
			END IF
			ofs = ofs + 4
			eh = ehbuf(r, v)
			el = elbuf(r, v)
			e = (256 * eh) OR el
			IF e = 0 THEN
				con.poke ofs, 46: ofs = ofs + 2
				con.poke ofs, 46: ofs = ofs + 2
				con.poke ofs, 46: ofs = ofs + 2
			ELSE
				IF eh < 10 THEN
					con.poke ofs, 48 + eh
				ELSE
					con.poke ofs, 55 + eh
				END IF
				ofs = ofs + 2
				IF el = 0 THEN
					con.poke ofs, 48: ofs = ofs + 2
					con.poke ofs, 48
				ELSE
					elh = el \ 16
					ell = el AND 15
					IF elh < 10 THEN
						con.poke ofs, 48 + elh
					ELSE
						con.poke ofs, 55 + elh
					END IF
					ofs = ofs + 2
					IF ell < 10 THEN
						con.poke ofs, 48 + ell
					ELSE
						con.poke ofs, 55 + ell
					END IF
				END IF
				ofs = ofs + 2
			END IF
			ofs = ofs + 2
		NEXT v
		ofs = ofs + 44
		r = r + 1
		sr = sr + 1
	WEND
	WHILE sr < 32
		con.poke ofs, 32: ofs = ofs + 2
		con.poke ofs, 32: ofs = ofs + 4
		FOR c = 0 TO 4
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32: ofs = ofs + 4
		NEXT c
		ofs = ofs + 44
		sr = sr + 1
	WEND
END SUB

SUB showorder
	ofs = 640
	r = edpos - 3
	sr = 0
	WHILE r < 0
		con.poke ofs, 32: ofs = ofs + 2
		con.poke ofs, 32: ofs = ofs + 20
		FOR c = 0 TO 4
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32
			ofs = ofs + 20
		NEXT c
		ofs = ofs + 28
		r = r + 1
		sr = sr + 1
	WEND

	WHILE r < length
		IF sr = 7 THEN EXIT SUB

		IF r < 16 THEN
			con.poke ofs, 48: ofs = ofs + 2
			IF r < 10 THEN
				con.poke ofs, r + 48
			ELSE
				con.poke ofs, r + 55
			END IF
			ofs = ofs + 20
		ELSE
			h = r \ 16
			IF h < 10 THEN
				con.poke ofs, h + 48
			ELSE
				con.poke ofs, h + 55
			END IF
			ofs = ofs + 2
			l = r AND 15
			IF l < 10 THEN
				con.poke ofs, l + 48
			ELSE
				con.poke ofs, l + 55
			END IF
			ofs = ofs + 20
		END IF
		FOR v = lmchan TO lmchan + 4
			p = ord(v, r)
			IF p < 16 THEN
				con.poke ofs, 48
				ofs = ofs + 2
				IF p < 10 THEN
					con.poke ofs, p + 48
				ELSE
					con.poke ofs, p + 55
				END IF
			ELSE
				ph = p \ 16
				pl = p AND 15
				IF ph < 10 THEN
					con.poke ofs, ph + 48
				ELSE
					con.poke ofs, ph + 55
				END IF
				ofs = ofs + 2
				IF pl < 10 THEN
					con.poke ofs, pl + 48
				ELSE
					con.poke ofs, pl + 55
				END IF
			END IF
			ofs = ofs + 20
		NEXT v
		ofs = ofs + 28
		r = r + 1
		sr = sr + 1
	WEND
	WHILE sr < 7
		con.poke ofs, 32: ofs = ofs + 2
		con.poke ofs, 32: ofs = ofs + 20
		FOR c = 0 TO 4
			con.poke ofs, 32: ofs = ofs + 2
			con.poke ofs, 32
			ofs = ofs + 20
		NEXT c
		ofs = ofs + 28
		sr = sr + 1
	WEND
END SUB

FUNCTION editpattern
	DIM oefsu AS LONG
	STATIC blkstart, blkend

	crsoff = 4480 + (22 * edkolon) + 7
	con.poke crsoff, &H3E
	context = 1
	blkkolon = -1

	con.atrbar 59, 0, 21, 50, 0
	puthyp hlppattern$, 59, 3

	DO
		GetNextKey:
		k = getkeyc
		SELECT CASE k
			CASE keyUp:
				IF edrow THEN

					IF shift THEN
						IF blkkolon = -1 THEN
							blkstart = edrow
							blkend = edrow
							blkkolon = edkolon
						END IF
						blkend = blkend - 1
					ELSEIF blkkolon >= 0 THEN
						GOSUB Unhilite
						blkkolon = -1
					END IF

					edrow = edrow - 1
					updptn = 1

				END IF
			CASE keyDown:
				IF edrow < 63 THEN

					IF shift THEN
						IF blkkolon = -1 THEN
							blkstart = edrow
							blkend = edrow
							blkkolon = edkolon
						END IF
						blkend = blkend + 1
					ELSEIF blkkolon >= 0 THEN
						GOSUB Unhilite
						blkkolon = -1
					END IF
					edrow = edrow + 1
					updptn = 1
				END IF
			CASE keyLeft:
				IF crsx THEN
					con.poke crsoff, &H17
					crsx = crsx - 1
					crsoff = crsoff - 2
					con.poke crsoff, &H3E
					SELECT CASE crsx
						CASE 0:
							context = 1
						CASE 4, 5:
							context = 2
						CASE 7, 8, 9:
							context = 3
					END SELECT
				END IF
			CASE keyRight:
				IF crsx < 9 THEN
					con.poke crsoff, &H17
					crsx = crsx + 1
					crsoff = crsoff + 2
					con.poke crsoff, &H3E
				END IF
				SELECT CASE crsx
					CASE 0:
						context = 1
					CASE 4, 5:
						context = 2
					CASE 7, 8, 9:
						context = 3
				END SELECT
			CASE keyPgUp:
				IF edrow >= 16 THEN edrow = edrow - 16 ELSE edrow = 0
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				updptn = 1
			CASE keyPgDown:
				IF edrow < 48 THEN edrow = edrow + 16 ELSE edrow = 63
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				updptn = 1
			CASE keyHome
				edrow = 0
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				updptn = 1
			CASE keyEnd
				edrow = 63
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				updptn = 1
			CASE keyCtRight:
				IF edkolon < 4 THEN
					con.poke crsoff, &H17
					edkolon = edkolon + 1
					crsoff = crsoff + 22
					con.poke crsoff, &H3E
					edvoice = edvoice + 1
				ELSEIF lmchan < 4 THEN
					lmchan = lmchan + 1
					showorder
					edvoice = edvoice + 1
					updptn = 1
					updchannelnos
				END IF
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
			CASE keyCtLeft:
				IF edkolon THEN
					con.poke crsoff, &H17
					edkolon = edkolon - 1
					crsoff = crsoff - 22
					con.poke crsoff, &H3E
					edvoice = edvoice - 1
				ELSEIF lmchan THEN
					lmchan = lmchan - 1
					showorder
					edvoice = edvoice - 1
					updptn = 1
					updchannelnos
				END IF
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF

			CASE keySpace:
				con.putstrxy SPACE$(5), 0, 0
				mins = 0: secs = 0: watch = 0
				playing = playing XOR 1
				IF playing THEN
					'				buftoedpos
					playing = 0: buftoedpos: playing = 1
					posjmp = -1
					ptnbrk = -1
					follow = 1
					'				ON TIMER(1) GOSUB Frame
					'				TIMER ON
					'                PRINT #5, "calling timerOn from editpattern"
					timerOn
				ELSE
					timerOff
					opl.silence
				END IF
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
			CASE keySlash:
				IF edoct THEN
					edoct = edoct - 1
					con.putstrxy HEX$(edoct), 9, 47
				END IF
			CASE keyAsterisk:
				IF edoct < 7 THEN
					edoct = edoct + 1
					con.putstrxy HEX$(edoct), 9, 47
				END IF
			CASE keyPrevIns:
				IF edini > 1 THEN
					edini = edini - 1
					i$ = HEX$(edini)
					IF edini < 16 THEN i$ = "0" + i$
					con.putstrxy i$, 8, 48
				END IF
			CASE keyNextIns:
				IF edini < 31 THEN
					edini = edini + 1
					i$ = HEX$(edini)
					IF edini < 16 THEN i$ = "0" + i$
					con.putstrxy i$, 8, 48
				END IF

			CASE keyIns:
				pi = ord(edvoice, edpos)
				FOR v = 0 TO 8
					IF ord(v, edpos) = pi THEN
						FOR r = 63 TO edrow + 1 STEP -1
							nbuf(r, v) = nbuf(r - 1, v)
							obuf(r, v) = obuf(r - 1, v)
							ibuf(r, v) = ibuf(r - 1, v)
							ehbuf(r, v) = ehbuf(r - 1, v)
							elbuf(r, v) = elbuf(r - 1, v)
						NEXT r
						nbuf(edrow, v) = 12
						obuf(edrow, v) = 0
						ibuf(edrow, v) = 0
						ehbuf(edrow, v) = 0
						elbuf(edrow, v) = 0
					END IF
				NEXT v
				buftoedpos
				updptn = 1

			CASE keyBackspc:
				IF edrow THEN
					pi = ord(edvoice, edpos)
					edrow = edrow - 1
					FOR v = 0 TO 8
						IF ord(v, edpos) = pi THEN
							FOR r = edrow TO 62
								nbuf(r, v) = nbuf(r + 1, v)
								obuf(r, v) = obuf(r + 1, v)
								ibuf(r, v) = ibuf(r + 1, v)
								ehbuf(r, v) = ehbuf(r + 1, v)
								elbuf(r, v) = elbuf(r + 1, v)
							NEXT r
							nbuf(63, v) = 12
							obuf(63, v) = 0
							ibuf(63, v) = 0
							ehbuf(63, v) = 0
							elbuf(63, v) = 0
						END IF
					NEXT v
					updptn = 1
					buftoedpos
				END IF

			CASE keyF4:
				follow = 0
				agi = getfilename(filenm$, "Load from file")
				IF agi THEN
					IF playing THEN
						timerOff
						opl.silence
						playing = 0
					END IF
					loadmod (filenm$)
					edpos = 0
					edrow = 0
					modptrs modptr()
					edpostobuf
					speed = 6
				END IF
				CLS
				initmainscreen
				showorder
				showpattern
				follow = 1
				con.poke crsoff, &H3E
				con.atrbar 59, 0, 21, 50, 0
				puthyp hlppattern$, 59, 3
			CASE keyF5:
				follow = 0
				agi = getfilename(filenm$, "Save to file")
				IF agi THEN
					buftoedpos
					savemod (filenm$)
				END IF
				CLS
				initmainscreen
				showorder
				showpattern
				follow = 1
				con.poke crsoff, &H3E
				con.atrbar 59, 0, 21, 50, 0
				puthyp hlppattern$, 59, 3

			CASE keyF6:
				pi = ord(edvoice, edpos)
				FOR r = 0 TO 63
					nclip(r) = nbuf(r, edvoice)
					oclip(r) = obuf(r, edvoice)
					iclip(r) = ibuf(r, edvoice)
					ehclip(r) = ehbuf(r, edvoice)
					elclip(r) = elbuf(r, edvoice)
				NEXT r
				FOR v = 0 TO 8
					IF ord(v, edpos) = pi THEN
						FOR r = 0 TO 63
							nbuf(r, v) = 12
							obuf(r, v) = 0
							ibuf(r, v) = 0
							ehbuf(r, v) = 0
							elbuf(r, v) = 0
						NEXT r
					END IF
				NEXT v
				buftoedpos
				updptn = 1
			CASE keyF7:

				FOR r = 0 TO 63
					nclip(r) = nbuf(r, edvoice)
					oclip(r) = obuf(r, edvoice)
					iclip(r) = ibuf(r, edvoice)
					ehclip(r) = ehbuf(r, edvoice)
					elclip(r) = elbuf(r, edvoice)
				NEXT r
			CASE keyF8:
				pi = ord(edvoice, edpos)
				FOR v = 0 TO 8
					IF ord(v, edpos) = pi THEN
						FOR r = 0 TO 63
							nbuf(r, v) = nclip(r)
							obuf(r, v) = oclip(r)
							ibuf(r, v) = iclip(r)
							ehbuf(r, v) = ehclip(r)
							elbuf(r, v) = elclip(r)
						NEXT r
					END IF
				NEXT v
				buftoedpos
				updptn = 1

			CASE keyShF6:
				IF blkkolon >= 0 THEN
					IF blkend < blkstart THEN SWAP blkend, blkstart
					blkv = lmchan + blkkolon
					pi = ord(blkv, edpos)
					FOR r = blkstart TO blkend
						nblk(r) = nbuf(r, blkv)
						oblk(r) = obuf(r, blkv)
						iblk(r) = ibuf(r, blkv)
						ehblk(r) = ehbuf(r, blkv)
						elblk(r) = elbuf(r, blkv)
					NEXT r
					FOR v = 0 TO 8
						IF ord(v, edpos) = pi THEN
							FOR r = blkstart TO blkend
								nbuf(r, v) = 12
								obuf(r, v) = 0
								ibuf(r, v) = 0
								ehbuf(r, v) = 0
								elbuf(r, v) = 0
							NEXT r
						END IF
					NEXT v
					updptn = 1
					buftoedpos
				END IF

			CASE keyShF7:
				IF blkkolon >= 0 THEN
					IF blkend < blkstart THEN SWAP blkend, blkstart
					v = lmchan + blkkolon
					FOR r = blkstart TO blkend
						nblk(r) = nbuf(r, v)
						oblk(r) = obuf(r, v)
						iblk(r) = ibuf(r, v)
						ehblk(r) = ehbuf(r, v)
						elblk(r) = elbuf(r, v)
					NEXT r
				END IF
			CASE keyShF8:
				pi = ord(edvoice, edpos)
				ccpend = edrow + (blkend - blkstart)
				IF ccpend > 63 THEN ccpend = 63
				FOR v = 0 TO 8
					IF ord(v, edpos) = pi THEN
						blkr = blkstart
						FOR r = edrow TO ccpend
							nbuf(r, v) = nblk(blkr)
							obuf(r, v) = oblk(blkr)
							ibuf(r, v) = iblk(blkr)
							ehbuf(r, v) = ehblk(blkr)
							elbuf(r, v) = elblk(blkr)
							blkr = blkr + 1
						NEXT r
					END IF
				NEXT v
				buftoedpos
				updptn = 1

			CASE keyMinus:
				IF ord(edvoice, edpos) THEN
					buftoedpos
					ord(edvoice, edpos) = ord(edvoice, edpos) - 1
					modptrs modptr()
					edpostobuf
					showorder
					updptn = 1
				END IF
			CASE keyPlus:
				IF ord(edvoice, edpos) < 203 THEN
					buftoedpos
					ord(edvoice, edpos) = ord(edvoice, edpos) + 1
					modptrs modptr()
					edpostobuf
					showorder
					updptn = 1
				END IF

			CASE keyShF5, keyCtF5:
				exchinstr k
				CLS
				initmainscreen
				showorder
				showpattern
				con.poke crsoff, &H3E
				puthyp hlppattern$, 59, 3

			CASE keyCtF6:
				p = ord(edvoice, edpos)
				oefsu = (320& * p) + 3
				FOR row = 0 TO 63
					ecliph(row) = ems.peek(oefsu)
					ems.poke oefsu, 0: oefsu = oefsu + 1
					eclipl(row) = ems.peek(oefsu)
					ems.poke oefsu, 0: oefsu = oefsu + 4
				NEXT row
				edpostobuf
				updptn = 1

			CASE keyCtF7:
				buftoedpos
				p = ord(edvoice, edpos)
				oefsu = (320& * p) + 3
				FOR row = 0 TO 63
					ecliph(row) = ems.peek(oefsu): oefsu = oefsu + 1
					eclipl(row) = ems.peek(oefsu): oefsu = oefsu + 4
				NEXT row

			CASE keyCtF8:
				p = ord(edvoice, edpos)
				oefsu = (320& * p) + 3
				FOR row = 0 TO 63
					ems.poke oefsu, ecliph(row): oefsu = oefsu + 1
					ems.poke oefsu, eclipl(row): oefsu = oefsu + 4
				NEXT row
				edpostobuf
				updptn = 1

			CASE keyShF1:
				p = ord(edvoice, edpos)
				oefsu = (320& * p)
				FOR row = 0 TO 63
					n = ems.peek(oefsu)
					IF n < 12 THEN
						o = ems.peek(oefsu + 1)
						n = n - 1
						IF n < 0 THEN
							IF o THEN
								n = 11
								o = o - 1
								ems.poke oefsu, n: oefsu = oefsu + 1
								ems.poke oefsu, o: oefsu = oefsu + 4
							END IF
						ELSE
							ems.poke oefsu, n: oefsu = oefsu + 1
							ems.poke oefsu, o: oefsu = oefsu + 4
						END IF
					ELSE
						oefsu = oefsu + 5
					END IF
				NEXT row
				edpostobuf
				updptn = 1

			CASE keyShF2:
				p = ord(edvoice, edpos)
				oefsu = (320& * p)
				FOR row = 0 TO 63
					n = ems.peek(oefsu)

					IF n < 12 THEN

						o = ems.peek(oefsu + 1)
						n = n + 1
						IF n > 11 THEN
							IF o < 7 THEN
								n = 0
								o = o + 1
								ems.poke oefsu, n: oefsu = oefsu + 1
								ems.poke oefsu, o: oefsu = oefsu + 4
							END IF
						ELSE
							ems.poke oefsu, n: oefsu = oefsu + 1
							ems.poke oefsu, o: oefsu = oefsu + 4
						END IF
					ELSE
						oefsu = oefsu + 5
					END IF
				NEXT row
				edpostobuf
				updptn = 1

			CASE keyCtF2:
				FOR p = 0 TO 203
					eraseptn p
				NEXT p
				FOR o = 0 TO 255
					FOR v = 0 TO 8
						ord(v, o) = 0
					NEXT v
				NEXT o
				edpostobuf
				length = 1
				edpos = 0
				showorder
				updptn = 1

				'		CASE keyLaltZ, keyRaltZ:
			CASE keyCtF3:
				FOR i = 1 TO 31
					eraseins i
				NEXT i
				FOR v = 0 TO 8
					vocini(v) = -1
				NEXT v

			CASE keyF1:
				IF blkkolon >= 0 THEN
					cln = 3 + (11 * blkkolon)
					FOR row = 12 TO 44
						IF row = 28 THEN row = 29
						con.atrseg cln, row, 10, 7
					NEXT row
					blkkolon = -1
				END IF
				con.poke crsoff, &H17
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				editpattern = ModeOrder
				EXIT FUNCTION

			CASE keyF3:
				con.poke crsoff, &H17
				IF blkkolon >= 0 THEN
					GOSUB Unhilite
					blkkolon = -1
				END IF
				editpattern = ModeInstrument
				EXIT FUNCTION

			CASE keyEsc:
				editpattern = ModeDeath
				EXIT FUNCTION
			CASE ELSE:
				GOTO Ctx
		END SELECT
		IF updptn THEN
			showpattern
			IF blkkolon >= 0 THEN
				cln = 3 + (11 * blkkolon)
				tbs = blkstart: tbe = blkend
				IF tbe < tbs THEN SWAP tbe, tbs
				phyrow = 12: lgcrow = edrow - 16
				IF lgcrow < 0 THEN
					phyrow = phyrow - lgcrow
					lgcrow = 0
				END IF
				DO WHILE phyrow < 44
					IF phyrow <> 28 THEN
						IF (lgcrow >= tbs) AND (lgcrow <= tbe) THEN
							con.atrseg cln, phyrow, 10, &H2E
						ELSE
							con.atrseg cln, phyrow, 10, 7
						END IF
					END IF
					phyrow = phyrow + 1
					lgcrow = lgcrow + 1
					IF lgcrow > 63 THEN EXIT DO
				LOOP
			END IF
			updptn = 0
		END IF
		GOTO GetNextKey

		Ctx:
		ON context GOTO CtxNote, CtxInstr, CtxEffect

		CtxNote:
		IF k = keyDel THEN
			nbuf(edrow, edvoice) = 12
			obuf(edrow, edvoice) = 0
			ibuf(edrow, edvoice) = 0
			p = ord(edvoice, edpos)
			FOR a = 0 TO 8
				IF ord(a, edpos) = p THEN
					nbuf(edrow, a) = 12
					obuf(edrow, a) = 0
					ibuf(edrow, a) = 0
				END IF
			NEXT a
			IF edrow < 63 THEN edrow = edrow + 1
			showpattern
			GOTO GetNextKey
		END IF
		FOR a = 0 TO 11
			IF k = keyhoct(a) THEN
				n = a
				o = edoct + 1
				GOTO Match
			END IF
			IF k = keyloct(a) THEN
				n = a
				o = edoct
				GOTO Match
			END IF
		NEXT a
		FOR a = 0 TO 4
			IF k = keyhovr(a) THEN
				n = a
				o = edoct + 2
				GOTO Match
			END IF
			IF k = keylovr(a) THEN
				n = a
				o = edoct + 1
				GOTO Match
			END IF
		NEXT a
		GOTO GetNextKey
		Match:
		nbuf(edrow, edvoice) = n
		obuf(edrow, edvoice) = o
		ibuf(edrow, edvoice) = edini
		p = ord(edvoice, edpos)
		FOR a = 0 TO 8
			IF ord(a, edpos) = p THEN
				nbuf(edrow, a) = n
				obuf(edrow, a) = o
				ibuf(edrow, a) = edini
			END IF
		NEXT a
		IF edrow < 63 THEN edrow = edrow + 1
		showpattern
		opl.out &HB0 + edvoice, 0
		IF vocini(edvoice) <> edini THEN
			opl.setinstr edvoice, ins(edini)
			vocini(edvoice) = edini
		END IF
		opl.playnote edvoice, frqtab(n), o
		GOTO GetNextKey

		CtxInstr:

		IF k = keyDel THEN
			i = 0
			GOTO DelInstr
		END IF
		h = hexscan(k)
		IF h >= 0 THEN
			i = ibuf(edrow, edvoice)
			IF crsx = 4 THEN
				IF h = 0 THEN
					i = i AND 15
					change = 1
				ELSEIF h = 1 THEN
					i = 16 OR (i AND 15)
					change = 1
				END IF
			ELSE
				i = (i AND &H10) OR h
				change = 1
			END IF
			IF change THEN
				DelInstr:
				ibuf(edrow, edvoice) = i
				p = ord(edvoice, edpos)
				FOR a = 0 TO 8
					IF ord(a, edpos) = p THEN
						ibuf(edrow, a) = i
					END IF
				NEXT a
				IF edrow < 63 THEN edrow = edrow + 1
				showpattern
				change = 0
			END IF
		END IF
		GOTO GetNextKey

		CtxEffect:
		IF k = keyDel THEN
			p = ord(edvoice, edpos)
			FOR a = 0 TO 8
				IF ord(a, edpos) = p THEN
					ehbuf(edrow, a) = 0
					elbuf(edrow, a) = 0
				END IF
			NEXT a
			IF edrow < 63 THEN edrow = edrow + 1
			showpattern
			GOTO GetNextKey
		END IF

		h = hexscan(k)
		IF h >= 0 THEN
			IF crsx = 7 THEN
				p = ord(edvoice, edpos)
				FOR a = 0 TO 8
					IF ord(a, edpos) = p THEN
						ehbuf(edrow, a) = h
					END IF
				NEXT a
			ELSE
				IF crsx = 8 THEN
					el = (16 * h) OR (elbuf(edrow, edvoice) AND 15)
				ELSE
					el = (elbuf(edrow, edvoice) AND &HF0) OR h
				END IF
				p = ord(edvoice, edpos)
				FOR a = 0 TO 8
					IF ord(a, edpos) = p THEN
						elbuf(edrow, a) = el
					END IF
				NEXT a
			END IF
			IF edrow < 63 THEN edrow = edrow + 1
			showpattern
		END IF
		GOTO GetNextKey
	LOOP

	Unhilite:
	cln = 3 + (11 * blkkolon)
	FOR phyrow = 12 TO 43
		IF phyrow <> 28 THEN
			con.atrseg cln, phyrow, 10, 7
		END IF
	NEXT phyrow
	RETURN
END FUNCTION

SUB updchannelnos
	ofs = 1774
	chno = lmchan
	FOR a = 0 TO 4
		con.poke ofs, chno + 48: ofs = ofs + 2
		chno = chno + 1
		ofs = ofs + 20
	NEXT a
END SUB

SUB buftoedpos
	IF playing THEN timerOff
	FOR v = 0 TO 8
		mptr = modptr(v)
		FOR r = 0 TO 63
			ems.poke mptr, nbuf(r, v): mptr = mptr + 1
			ems.poke mptr, obuf(r, v): mptr = mptr + 1
			ems.poke mptr, ibuf(r, v): mptr = mptr + 1
			ems.poke mptr, ehbuf(r, v): mptr = mptr + 1
			ems.poke mptr, elbuf(r, v): mptr = mptr + 1
		NEXT r
	NEXT v
	IF playing THEN
		'       PRINT #5, "calling timerOn from buftoedpos"
		timerOn
	END IF
END SUB

FUNCTION getfilename (dest$, prompt$)
	IF nofilereq = 1 THEN
		con.putstrxy prompt$ + ":", 0, 49
		i$ = con.getstr(LEN(prompt$) + 2, 49, 14, 12)
		con.putstr SPACE$(60), 7840
		IF i$ <> "" THEN
			dest$ = i$
			getfilename = 1
		END IF
	ELSE
		'		con.atrbar 59, 0, 21, 50, 0
		'		puthyp hlpfilereq$, 59, 18
		dest$ = RequestFile
		IF LEN(dest$) THEN getfilename = 1 ELSE getfilename = 0
	END IF
END FUNCTION

SUB loadmod (filenm$)
	OPEN filenm$ FOR BINARY ACCESS READ AS #1
	length = readb(1)
	nptns = readb(1)
	ninstrs = readb(1)

	IF (nptns = 0) OR (nptns > 204) OR (ninstrs > 31) THEN CLOSE #1: EXIT SUB

	DIM ptnmap(0 TO nptns - 1)
	FOR a = 0 TO nptns - 1
		ptnmap(a) = readb(1)
		IF ptnmap(a) > 203 THEN CLOSE #1: EXIT SUB
	NEXT a
	IF ninstrs THEN
		DIM insmap(0 TO ninstrs - 1)
		FOR a = 0 TO ninstrs - 1
			insmap(a) = readb(1)
			IF (insmap(a) < 1) OR (insmap(a) > 31) THEN CLOSE #1: EXIT SUB
		NEXT a
	END IF

	FOR p = 0 TO 203
		eraseptn p
	NEXT p

	FOR i = 1 TO 31
		eraseins i
	NEXT i

	FOR p = 0 TO length - 1
		FOR v = 0 TO 8
			ord(v, p) = readb(1)
			IF ord(v, p) > 203 THEN CLOSE #1: EXIT SUB
		NEXT v
	NEXT p

	FOR a = 0 TO nptns - 1
		ptn = ptnmap(a)
		ofs = 320& * ptn
		FOR row = 0 TO 63
			b1 = readb(1)
			b2 = readb(1)
			el = readb(1)
			n = b1 \ 16
			o = (b1 \ 2) AND 7
			i = (16 * (b1 AND 1)) OR (b2 \ 16)
			eh = b2 AND 15
			ems.poke ofs, n: ofs = ofs + 1
			ems.poke ofs, o: ofs = ofs + 1
			ems.poke ofs, i: ofs = ofs + 1
			ems.poke ofs, eh: ofs = ofs + 1
			ems.poke ofs, el: ofs = ofs + 1
		NEXT row
	NEXT a

	IF ninstrs THEN

		FOR a = 0 TO ninstrs - 1
			ini = insmap(a)
			ins(ini).mul1 = readb(1)
			ins(ini).mul2 = readb(1)
			ins(ini).lev1 = readb(1)
			ins(ini).lev2 = readb(1)
			ins(ini).atd1 = readb(1)
			ins(ini).atd2 = readb(1)
			ins(ini).sur1 = readb(1)
			ins(ini).sur2 = readb(1)
			ins(ini).wav1 = readb(1)
			ins(ini).wav2 = readb(1)
			ins(ini).fbcon = readb(1)
		NEXT a
	END IF

	modptrs modptr()
	edpostobuf

	CLOSE #1
END SUB

FUNCTION readb (fh)
	b$ = CHR$(0)
	GET #fh, , b$
	readb = ASC(b$)
END FUNCTION

SUB eraseins (ini)
	ins(ini).mul1 = 0: ins(ini).mul2 = 0
	ins(ini).lev1 = 0: ins(ini).lev2 = 0
	ins(ini).atd1 = 0: ins(ini).atd2 = 0
	ins(ini).sur1 = 0: ins(ini).sur2 = 0
	ins(ini).wav1 = 0: ins(ini).wav2 = 0
	ins(ini).fbcon = 0
END SUB

SUB savemod (filenm$)
	DIM ptnuse(0 TO 203), ptnmap(0 TO 203)
	DIM insuse(0 TO 31), insmap(1 TO 31)
	DIM ofs AS LONG


	FOR o = 0 TO length - 1
		FOR v = 0 TO 8
			ptnuse(ord(v, o)) = 1
		NEXT v
	NEXT o
	FOR p = 0 TO 203
		IF ptnuse(p) THEN
			ptnmap(nptrns) = p
			nptrns = nptrns + 1
		END IF
	NEXT p
	FOR lp = 0 TO nptrns - 1
		p = ptnmap(lp)
		ofs = (320& * p) + 2
		FOR row = 0 TO 63
			insuse(ems.peek(ofs)) = 1
			ofs = ofs + 5
		NEXT row
	NEXT lp
	FOR li = 1 TO 31
		IF insuse(li) THEN
			ninstrs = ninstrs + 1
			insmap(ninstrs) = li
		END IF
	NEXT li

	OPEN filenm$ FOR BINARY ACCESS WRITE AS #1
	writeb 1, length
	writeb 1, nptrns
	writeb 1, ninstrs
	FOR a = 0 TO nptrns - 1
		writeb 1, ptnmap(a)
	NEXT a
	FOR a = 1 TO ninstrs
		writeb 1, insmap(a)
	NEXT a
	FOR o = 0 TO length - 1
		FOR v = 0 TO 8
			writeb 1, ord(v, o)
		NEXT v
	NEXT o
	FOR lp = 0 TO nptrns - 1
		p = ptnmap(lp)
		ofs = 320& * p
		FOR row = 0 TO 63
			n = ems.peek(ofs): ofs = ofs + 1
			o = ems.peek(ofs): ofs = ofs + 1
			i = ems.peek(ofs): ofs = ofs + 1
			eh = ems.peek(ofs): ofs = ofs + 1
			b3 = ems.peek(ofs): ofs = ofs + 1
			b1 = (16 * n) OR (2 * o) OR (i \ 16)
			b2 = (16 * (i AND 15)) OR eh
			writeb 1, b1
			writeb 1, b2
			writeb 1, b3
		NEXT row
	NEXT lp
	FOR li = 1 TO ninstrs
		i = insmap(li)
		writeb 1, ins(i).mul1
		writeb 1, ins(i).mul2
		writeb 1, ins(i).lev1
		writeb 1, ins(i).lev2
		writeb 1, ins(i).atd1
		writeb 1, ins(i).atd2
		writeb 1, ins(i).sur1
		writeb 1, ins(i).sur2
		writeb 1, ins(i).wav1
		writeb 1, ins(i).wav2
		writeb 1, ins(i).fbcon
	NEXT li
	mk$ = "B.J."
	PUT #1, , mk$
	CLOSE #1
END SUB

SUB writeb (fh, b)
	zbi$ = CHR$(b)
	PUT #fh, , zbi$
END SUB

SUB exchinstr (kei)
	DIM xi(0 TO 1)
	DIM ofs AS LONG

	con.box 10, 15, 40, 11, &H5E
	con.atrbar 11, 16, 38, 9, 7
	con.bar 11, 16, 38, 9, " "

	con.putstrxy "Exchange instrument in:", 12, 17
	IF kei = keyShF5 THEN
		p = ord(edvoice, edpos)
		IF p < 16 THEN
			st$ = "pattern 0" + HEX$(p)
		ELSE
			st$ = "pattern " + HEX$(p)
		END IF
	ELSE
		st$ = "all patterns"
	END IF
	con.putstrxy st$, 36, 17
	con.putstrxy "From:", 12, 19
	con.putstrxy "  To:", 12, 20
	con.atrseg 18, 19, 3, &H3E
	con.putstrxy "+,-,Enter to choose instrument", 12, 22
	con.putstrxy "Esc to cancel", 12, 23
	con.puthex xi(0), 19, 19
	con.puthex xi(1), 19, 20

	GetKeiExIns:
	k = getkeyc
	SELECT CASE k
		CASE keyMinus:
			IF xi(a) THEN
				xi(a) = xi(a) - 1
				con.puthex xi(a), 19, 19 + a
			END IF
		CASE keyPlus:
			IF xi(a) < 31 THEN
				xi(a) = xi(a) + 1
				con.puthex xi(a), 19, 19 + a
			END IF
		CASE keyEnter:
			IF a THEN
				IF kei = keyShF5 THEN
					GOSUB ExInsPattern
				ELSE
					GOSUB ExInsAll
				END IF
				EXIT SUB
			ELSE
				con.atrseg 18, 19, 3, 7
				a = a + 1
				con.atrseg 18, 20, 3, &H3E
			END IF
		CASE keyEsc:
			EXIT SUB
		CASE keyUp:
			IF a THEN
				con.atrseg 18, 20, 3, 7
				a = a - 1
				con.atrseg 18, 19, 3, &H3E
			END IF
		CASE keyDown:
			IF a = 0 THEN
				con.atrseg 18, 19, 3, 7
				a = a + 1
				con.atrseg 18, 20, 3, &H3E
			END IF
	END SELECT
	GOTO GetKeiExIns

	ExInsPattern:
	ofs = (320& * p) + 2
	FOR row = 0 TO 63
		IF ems.peek(ofs) = xi(0) THEN ems.poke ofs, xi(1)
		ofs = ofs + 5
	NEXT row
	edpostobuf
	RETURN

	ExInsAll:
	FOR o = 0 TO length - 1
		FOR v = 0 TO 8
			p = ord(v, o)
			ofs = (320& * p) + 2
			FOR row = 0 TO 63
				IF ems.peek(ofs) = xi(0) THEN ems.poke ofs, xi(1)
				ofs = ofs + 5
			NEXT row
		NEXT v
	NEXT o
	edpostobuf
	RETURN
END SUB

FUNCTION hexscan (k)
	FOR a = 0 TO 15
		IF k = keyhex(a) THEN
			hexscan = a
			EXIT FUNCTION
		END IF
	NEXT a
	hexscan = -1
END FUNCTION

SUB opl.playnote(v, frq, okt)
	opl.out &HA0 + v, frq AND 255
	opl.out &HB0 + v, 32 OR (4 * okt) OR (frq \ 256)
END SUB

SUB opl.setinstr(v, i AS Instrument)
	reg = &H20 + VocOff(v)
	opl.out reg, i.mul1: reg = reg + 3
	opl.out reg, i.mul2: reg = reg + &H1D
	opl.out reg, i.lev1: reg = reg + 3
	opl.out reg, i.lev2: reg = reg + &H1D
	opl.out reg, i.atd1: reg = reg + 3
	opl.out reg, i.atd2: reg = reg + &H1D
	opl.out reg, i.sur1: reg = reg + 3
	opl.out reg, i.sur2: reg = reg + &H5D
	opl.out reg, i.wav1: reg = reg + 3
	opl.out reg, i.wav2: reg = reg + &H1D
	opl.out &HC0 + v, i.fbcon
END SUB

FUNCTION editinstr STATIC
	DIM ny(0 TO 1) AS STRING
	DIM wvfm(0 TO 3) AS STRING
	DIM conn(0 TO 1) AS STRING

	con.atrbar 59, 0, 21, 50, 0
	puthyp hlpinstr$, 59, 14

	IF initialized = 0 THEN
		ny(0) = "No "
		ny(1) = "Yes"
		wvfm(0) = "Sine      "
		wvfm(1) = "Half-Sine "
		wvfm(2) = "Abs-Sine  "
		wvfm(3) = "Pulse-Sine"
		conn(0) = "Mod Op.1  "
		conn(1) = "Both sound"
		tesn = 0: teso = 2
		initialized = 1
	END IF

	follow = 0
	GOSUB InitIEScreen
	instoinsed edini
	GOSUB RethinkIE

	crsc = 25: crsr = 20: dig = 0
	con.atrseg crsc, crsr, 10, &H17
	con.putatr crsc + dig, crsr, &H3E
	ivi = 0

	GetKeiI:
	kei = getkeyc
	SELECT CASE kei
		CASE keyPrevIns:
			IF edini > 1 THEN
				opl.out &HB8, 0
				opl.setinstr 8, silence
				insedtoins edini
				edini = edini - 1
				instoinsed edini
				GOSUB RethinkIE
			END IF
		CASE keyNextIns:
			IF edini < 31 THEN
				opl.out &HB8, 0
				opl.setinstr 8, silence
				insedtoins edini
				edini = edini + 1
				instoinsed edini
				GOSUB RethinkIE
			END IF
		CASE keyUp:
			IF crsr > 20 THEN
				con.atrseg crsc, crsr, 10, 7
				crsr = crsr - 1
				GOSUB PutCrs
			END IF
		CASE keyDown:
			IF crsr < 29 THEN
				con.atrseg crsc, crsr, 10, 7
				crsr = crsr + 1
				GOSUB PutCrs
			END IF
		CASE keyCtLeft, keyCtRight:
			con.atrseg crsc, crsr, 10, 7
			IF crsc = 25 THEN crsc = 37 ELSE crsc = 25
			GOSUB PutCrs
		CASE keyLeft, keyRight:
			IF (crsr < 24) OR (ivi = 16) THEN
				con.putatr crsc + dig, crsr, &H17
				dig = dig XOR 1
				con.putatr crsc + dig, crsr, &H3E
			ELSEIF (crsr < 27) OR (ivi = 17) THEN
				iv(ivi) = iv(ivi) XOR 1
				GOSUB RethinkIE
			ELSEIF ivi < 18 THEN
				IF kei = keyLeft THEN
					iv(ivi) = (iv(ivi) - 1) AND 3
				ELSE
					iv(ivi) = (iv(ivi) + 1) AND 3
				END IF
				GOSUB RethinkIE
			END IF
		CASE keyMinus:
			IF tesn THEN
				tesn = tesn - 1
				GOSUB RethinkIE
			ELSEIF teso THEN
				teso = teso - 1
				tesn = 11
				GOSUB RethinkIE
			END IF
		CASE keyPlus:
			IF tesn < 11 THEN
				tesn = tesn + 1
				GOSUB RethinkIE
			ELSEIF teso < 7 THEN
				teso = teso + 1
				tesn = 0
				GOSUB RethinkIE
			END IF
		CASE keySpace:
			insedtoins edini
			opl.out &HB8, 0
			opl.setinstr 8, silence
			opl.setinstr 8, ins(edini)
			opl.playnote 8, frqtab(tesn), teso
		CASE keyF1:
			insedtoins edini
			CLS
			initmainscreen
			showorder
			showpattern
			follow = 1
			opl.out &HB8, 0
			opl.setinstr 8, silence
			vocini(0) = -1
			editinstr = ModeOrder
			EXIT FUNCTION
		CASE keyF2:
			insedtoins edini
			CLS
			initmainscreen
			showorder
			showpattern
			follow = 1
			opl.out &HB8, 0
			opl.setinstr 8, silence
			vocini(0) = -1
			editinstr = ModePattern
			EXIT FUNCTION

		CASE keyF4:
			agi = getfilename(filenm$, "Load from file")
			IF agi THEN GOSUB LoadInstr
			CLS
			initmainscreen
			showorder
			showpattern
			GOSUB InitIEScreen
			GOSUB RethinkIE
			con.atrbar 59, 0, 21, 50, 0
			puthyp hlpinstr$, 59, 14
			GOSUB PutCrs

		CASE keyF5:
			agi = getfilename(filenm$, "Save to file")
			IF agi THEN GOSUB SaveInstr
			CLS
			initmainscreen
			showorder
			showpattern
			GOSUB InitIEScreen
			GOSUB RethinkIE
			con.atrbar 59, 0, 21, 50, 0
			puthyp hlpinstr$, 59, 14
			GOSUB PutCrs

		CASE keyF7:
			insedtoins 32

		CASE keyF8:
			instoinsed 32
			GOSUB RethinkIE

		CASE ELSE:
			IF (crsr < 24) OR (ivi = 16) THEN
				GOSUB Hexa
			END IF
	END SELECT

	GOTO GetKeiI

	Hexa:
	H = hexscan(kei)
	IF H < 0 THEN RETURN
	IF dig = 0 THEN
		iv(ivi) = (16 * H) OR (iv(ivi) AND 15)
	ELSE
		iv(ivi) = (iv(ivi) AND &HF0) OR H
	END IF
	GOSUB RethinkIE
	RETURN

	RethinkIE:
	con.puthex edini, 15, 17
	con.poke 5166, notenm(0, tesn)
	con.poke 5168, notenm(1, tesn)
	con.poke 5170, 48 + teso
	row = 20
	FOR i = 0 TO 3
		con.puthex iv(i), 25, row
		con.puthex iv(i + 8), 37, row
		row = row + 1
	NEXT i
	FOR i = 4 TO 6
		con.putstrxy ny(iv(i)), 25, row
		con.putstrxy ny(iv(i + 8)), 37, row
		row = row + 1
	NEXT i
	con.putstrxy wvfm(iv(IE.WAV1)), 25, 27
	con.putstrxy wvfm(iv(IE.WAV2)), 37, 27
	con.puthex iv(IE.FEED), 25, 28
	con.putstrxy conn(iv(IE.CONN)), 25, 29

	insedtoins edini
	FOR v = 0 TO 8
		IF vocini(v) = edini THEN opl.setinstr v, ins(edini)
	NEXT v

	RETURN


	InitIEScreen:
	con.box 10, 15, 40, 20, &H5E
	con.atrbar 11, 16, 38, 18, 7
	con.bar 11, 16, 38, 18, " "
	con.putstrxy "Nr.", 12, 17
	con.putstrxy "Op.1", 25, 18
	con.putstrxy "Op.2", 37, 18
	con.putstrxy "Multiple", 12, 20
	con.putstrxy "Level", 12, 21
	con.putstrxy "Att / Dec", 12, 22
	con.putstrxy "Sus / Rel", 12, 23
	con.putstrxy "Vibrato", 12, 24
	con.putstrxy "Tremolo", 12, 25
	con.putstrxy "EG Sustain", 12, 26
	con.putstrxy "Waveform", 12, 27
	con.putstrxy "Feedback", 12, 28
	con.putstrxy "Connection", 12, 29
	con.putstrxy "Test note:", 12, 32
	RETURN

	LoadInstr:
	OPEN filenm$ FOR BINARY ACCESS READ AS #1
	ins(edini).mul1 = readb(1)
	ins(edini).mul2 = readb(1)
	ins(edini).lev1 = readb(1)
	ins(edini).lev2 = readb(1)
	ins(edini).atd1 = readb(1)
	ins(edini).atd2 = readb(1)
	ins(edini).sur1 = readb(1)
	ins(edini).sur2 = readb(1)
	ins(edini).wav1 = readb(1)
	ins(edini).wav2 = readb(1)
	ins(edini).fbcon = readb(1)
	CLOSE #1
	instoinsed edini
	RETURN

	SaveInstr:
	insedtoins edini
	OPEN filenm$ FOR BINARY ACCESS WRITE AS #1
	writeb 1, ins(edini).mul1
	writeb 1, ins(edini).mul2
	writeb 1, ins(edini).lev1
	writeb 1, ins(edini).lev2
	writeb 1, ins(edini).atd1
	writeb 1, ins(edini).atd2
	writeb 1, ins(edini).sur1
	writeb 1, ins(edini).sur2
	writeb 1, ins(edini).wav1
	writeb 1, ins(edini).wav2
	writeb 1, ins(edini).fbcon
	CLOSE #1
	RETURN

	PutCrs:
	con.atrseg crsc, crsr, 10, &H17
	ivi = (crsr - 20) + (-8 * (crsc = 37)) + (-8 * (crsr >= 28))
	IF (crsr < 24) OR (ivi = 16) THEN
		con.putatr crsc + dig, crsr, &H3E
	END IF
	RETURN
END FUNCTION

SUB instoinsed (insno)
	iv(IE.MUL1) = ins(insno).mul1 AND 15
	iv(IE.LEV1) = ins(insno).lev1
	iv(IE.ATD1) = ins(insno).atd1
	iv(IE.SUR1) = ins(insno).sur1
	iv(IE.WAV1) = ins(insno).wav1
	iv(IE.MUL2) = ins(insno).mul2 AND 15
	iv(IE.LEV2) = ins(insno).lev2
	iv(IE.ATD2) = ins(insno).atd2
	iv(IE.SUR2) = ins(insno).sur2
	iv(IE.WAV2) = ins(insno).wav2
	iv(IE.VIB1) = (ins(insno).mul1 \ 64) AND 1
	iv(IE.TRE1) = ins(insno).mul1 \ 128
	iv(IE.EGS1) = (ins(insno).mul1 \ 32) AND 1
	iv(IE.VIB2) = (ins(insno).mul2 \ 64) AND 1
	iv(IE.TRE2) = ins(insno).mul2 \ 128
	iv(IE.EGS2) = (ins(insno).mul2 \ 32) AND 1
	iv(IE.FEED) = ins(insno).fbcon \ 2
	iv(IE.CONN) = ins(insno).fbcon AND 1
END SUB

SUB insedtoins (insno)
	ins(insno).mul1 = (128 * iv(IE.TRE1)) OR (64 * iv(IE.VIB1)) OR (32 * iv(IE.EGS1)) OR iv(IE.MUL1)
	ins(insno).mul2 = (128 * iv(IE.TRE2)) OR (64 * iv(IE.VIB2)) OR (32 * iv(IE.EGS2)) OR iv(IE.MUL2)
	ins(insno).lev1 = iv(IE.LEV1)
	ins(insno).atd1 = iv(IE.ATD1)
	ins(insno).sur1 = iv(IE.SUR1)
	ins(insno).wav1 = iv(IE.WAV1)
	ins(insno).lev2 = iv(IE.LEV2)
	ins(insno).atd2 = iv(IE.ATD2)
	ins(insno).sur2 = iv(IE.SUR2)
	ins(insno).wav2 = iv(IE.WAV2)
	ins(insno).fbcon = (2 * iv(IE.FEED)) OR iv(IE.CONN)
END SUB

FUNCTION editorder
	crsoff = 1120 + (22 * edkolon) + 23
	con.poke crsoff, &H3E

	con.atrbar 59, 0, 21, 50, 0
	puthyp hlporder$, 59, 4

	DO
		GetNextKeyO:
		k = getkeyc
		SELECT CASE k
			CASE keyUp:
				IF edpos THEN
					edpos = edpos - 1
					updord = 1
				END IF
			CASE keyDown:
				IF edpos < length - 1 THEN
					edpos = edpos + 1
					updord = 1
				END IF
			CASE keyLeft:
				IF crsx THEN
					con.poke crsoff, &H17
					crsx = crsx - 1
					crsoff = crsoff - 2
					con.poke crsoff, &H3E
				END IF
			CASE keyRight:
				IF crsx = 0 THEN
					con.poke crsoff, &H17
					crsx = crsx + 1
					crsoff = crsoff + 2
					con.poke crsoff, &H3E
				END IF
			CASE keyCtRight:
				IF edkolon < 4 THEN
					con.poke crsoff, &H17
					edkolon = edkolon + 1
					crsoff = crsoff + 22
					con.poke crsoff, &H3E
					edvoice = edvoice + 1
				ELSEIF lmchan < 4 THEN
					lmchan = lmchan + 1
					showorder
					showpattern
					edvoice = edvoice + 1
					updchannelnos
				END IF
			CASE keyCtLeft:
				IF edkolon THEN
					con.poke crsoff, &H17
					edkolon = edkolon - 1
					crsoff = crsoff - 22
					con.poke crsoff, &H3E
					edvoice = edvoice - 1
				ELSEIF lmchan THEN
					lmchan = lmchan - 1
					showorder
					showpattern
					edvoice = edvoice - 1
					updchannelnos
				END IF
			CASE keyF2:
				con.poke crsoff, &H17
				editorder = ModePattern
				EXIT FUNCTION
			CASE keyF3:
				con.poke crsoff, &H17
				editorder = ModeInstrument
				EXIT FUNCTION

			CASE keyF6:
				buftoedpos
				FOR v = 0 TO 8
					ordclip(v) = ord(v, edpos)
					ord(v, edpos) = 0
				NEXT v
				updord = 1

			CASE keyF7:
				FOR v = 0 TO 8
					ordclip(v) = ord(v, edpos)
				NEXT v

			CASE keyF8:
				buftoedpos
				FOR v = 0 TO 8
					ord(v, edpos) = ordclip(v)
				NEXT v
				updord = 1

			CASE keyMinus:
				IF ord(edvoice, edpos) THEN
					buftoedpos
					ord(edvoice, edpos) = ord(edvoice, edpos) - 1
					updord = 1
				END IF

			CASE keyPlus:
				IF ord(edvoice, edpos) < 203 THEN
					buftoedpos
					ord(edvoice, edpos) = ord(edvoice, edpos) + 1
					updord = 1
				END IF

			CASE keyIns
				IF length < 256 THEN
					buftoedpos
					FOR o = length TO edpos + 2 STEP -1
						FOR v = 0 TO 8
							ord(v, o) = ord(v, o - 1)
						NEXT v
					NEXT o
					FOR v = 0 TO 8
						ord(v, edpos + 1) = 0
					NEXT v
					length = length + 1
					updord = 1
				END IF
			CASE keyDel
				IF length > 1 THEN
					buftoedpos
					FOR o = edpos TO length - 2
						FOR v = 0 TO 8
							ord(v, o) = ord(v, o + 1)
						NEXT v
					NEXT o
					FOR v = 0 TO 8
						ord(v, length - 1) = 0
					NEXT v
					length = length - 1
					IF edpos = length THEN edpos = edpos - 1
					updord = 1
				END IF
			CASE ELSE:
				GOTO Hexb
		END SELECT
		IF updord THEN
			buftoedpos
			showorder
			modptrs modptr()
			edpostobuf
			showpattern
			updord = 0
		END IF

		GOTO GetNextKeyO

		Hexb:
		H = hexscan(k)
		IF H >= 0 THEN
			IF crsx = 0 THEN
				o = (16 * H) OR (ord(edvoice, edpos) AND 15)
			ELSE
				o = (ord(edvoice, edpos) AND &HF0) OR H
			END IF
			IF o < 204 THEN
				buftoedpos
				ord(edvoice, edpos) = o
				showorder
				modptrs modptr()
				edpostobuf
				showpattern
			END IF
		END IF
	LOOP
END FUNCTION

FUNCTION getkeyc
	DO WHILE i$ = ""
		SLEEP 1, 1
		IF requestShowwatch THEN showwatch: requestShowwatch = 0
		IF requestShoworder THEN showorder: requestShoworder = 0
		IF requestShowpattern THEN showpattern: requestShowpattern = 0
		i$ = INKEY$
	LOOP
	getkeyc = CVI(i$ + CHR$(0) + CHR$(0) + CHR$(0))
END FUNCTION

SUB showwatch
	m$ = STR$(mins): 'm$ = RIGHT$(m$, LEN(m$) - 1)
	s$ = STR$(secs): 's$ = RIGHT$(s$, LEN(s$) - 1)
	IF mins < 10 THEN m$ = " " + m$
	IF secs < 10 THEN s$ = "0" + s$
	con.putstrxy m$ + ":" + s$, 0, 0
END SUB

SUB opl.out(reg, vlu)
	DIM x AS UINTEGER, y AS UINTEGER
	x = reg: y = vlu
	oplout x, y
END SUB

SUB opl.silence ()
	FOR v = 0 TO 8
		oplout &HB0+v, 0
		opl.setinstr v, silence
		vocini(v) = -1
	NEXT
END SUB

Function RequestFile() AS STRING

	Dim ofn As OPENFILENAME
	Dim filename As Zstring * MAX_PATH+1
	Dim hwnd AS HWND

	With ofn
		.lStructSize       = sizeof( OPENFILENAME )
		.hwndOwner         = 0
		.hInstance         = GetModuleHandle( NULL )
		.lpstrFilter       = Strptr( !"All Files, (*.*)\0*.*\0PIS Files, (*.PIS)\0*.pis\0INS Files, (*.INS)\0*.ins\0\0" )
		.lpstrCustomFilter = NULL
		.nMaxCustFilter    = 0
		.nFilterIndex      = 1
		.lpstrFile         = @filename
		.nMaxFile          = sizeof( filename )
		.lpstrFileTitle    = NULL
		.nMaxFileTitle     = 0
		.lpstrInitialDir   = NULL
		.lpstrTitle        = @"Choose Path"
		.Flags             = OFN_PATHMUSTEXIST 'OFN_EXPLORER Or OFN_PATHMUSTEXIST
		.nFileOffset       = 0
		.nFileExtension    = 0
		.lpstrDefExt       = NULL
		.lCustData         = 0
		.lpfnHook          = NULL
		.lpTemplateName    = NULL
	End With


	If( GetOpenFileName( @ofn ) = FALSE ) Then
		RequestFile = ""
	Else
		RequestFile = filename
	End If

	SCREENCONTROL GET_WINDOW_HANDLE, hwnd
	SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE or SWP_NOMOVE)
	SetActiveWindow(hwnd)
End Function
