#lang "fblite"
DEFINT A-Z

'$INCLUDE: 'keycodes.bi'

CONST SC_LSHIFT% = &H2A
CONST SC_RSHIFT% = &H36

DIM SHARED con.b800(0 TO 7999)

SUB con.clear
    FOR i = 0 TO 7998 STEP 2
        con.b800(i) = 0
        con.b800(i+1) = 7
    NEXT
END SUB

SUB con.poke(offset, v)
'    oldcolumn = POS(0)
'    oldrow = CSRLIN
'    oldattrib = COLOR
    con.b800(offset) = v
    column = 1 + ((offset MOD 160) \ 2)
    row = 1 + (offset \ 160)
    LOCATE row, column
    IF (offset AND 1) THEN
        fg = v AND 15
        bg = v \ 16
        ch = con.b800(offset XOR 1)
    ELSE
        at = con.b800(offset XOR 1)
        fg = at AND 15
        bg = at \ 16
        ch = v
    END IF
    COLOR fg, bg
    PRINT CHR$(ch);
'    LOCATE oldcolumn, oldrow
'    COLOR oldattrib AND 15, oldattrib \ 16
END SUB

SUB con.atrbar (x, y, w, h, atr)
	ofs = (2 * ((80 * y) + x)) + 1
	mdo = 2 * (80 - w)
	lh = h
	WHILE lh
		lw = w
		WHILE lw
			con.poke ofs, atr
			ofs = ofs + 2
			lw = lw - 1
		WEND
		ofs = ofs + mdo
		lh = lh - 1
	WEND
END SUB

SUB con.atrseg (x, y, w, atr)
	ofs = (2 * ((80 * y) + x)) + 1
	lw = w
	WHILE lw
		con.poke ofs, atr
		ofs = ofs + 2
		lw = lw - 1
	WEND
END SUB

SUB con.bar (x, y, w, h, ch$)
	ofs = 2 * ((80 * y) + x)
	mdo = 2 * (80 - w)
	lh = h
	bsc = ASC(ch$)
	WHILE lh
		lw = w
		WHILE lw
			con.poke ofs, bsc
			ofs = ofs + 2
			lw = lw - 1
		WEND
		ofs = ofs + mdo
		lh = lh - 1
	WEND
END SUB

SUB con.box (x, y, w, h, atr)
	h = h - 2
	ow = w
	w = w - 1
	IF h < 1 THEN EXIT SUB
	IF w < 2 THEN EXIT SUB
	o1 = 2 * ((80 * y) + x)
	o2 = o1 + w + w
	o3 = o1
	w = w - 1
	con.poke o1, 218: con.poke o1 + 1, atr
	con.poke o2, 191: con.poke o2 + 1, atr
	o1 = o1 + 160
	o2 = o2 + 160
	WHILE h
		h = h - 1
		con.poke o1, 179: con.poke o1 + 1, atr
		con.poke o2, 179: con.poke o2 + 1, atr
		o1 = o1 + 160
		o2 = o2 + 160
	WEND
	con.poke o1, 192: con.poke o1 + 1, atr
	con.poke o2, 217: con.poke o2 + 1, atr
	WHILE w
		w = w - 1
		o3 = o3 + 2
		o2 = o2 - 2
		con.poke o3, 196: con.poke o3 + 1, atr
		con.poke o2, 196: con.poke o2 + 1, atr
	WEND
	w = ow
END SUB

SUB con.putatr (x, y, atr)
	con.poke (2 * ((80 * y) + x)) + 1, atr
END SUB

SUB con.putstrxy (st$, x, y)
	ofs = 2 * ((80 * y) + x)
	FOR p = 1 TO LEN(st$)
		con.poke ofs, ASC(MID$(st$, p, 1))
		ofs = ofs + 2
	NEXT p
END SUB

SUB con.puthex (v, x, y)
	DIM st AS STRING * 2

	IF v < 16 THEN st = "0" + HEX$(v) ELSE st = HEX$(v)
	con.putstrxy st, x, y
END SUB

SUB con.putstr (st$, ofs)
	lofs = ofs
	FOR p = 1 TO LEN(st$)
		con.poke ofs, ASC(MID$(st$, p, 1))
		ofs = ofs + 2
	NEXT p
END SUB

FUNCTION con.getstr$ (x, y, atr, maxchrs)
	st$ = SPACE$(maxchrs)
	ofs = 2 * ((80 * y) + x)
	p = 1
	maxchrs = maxchrs + 1
	DO
		k = GETKEY
		IF k = keyEnter THEN
			con.getstr$ = LEFT$(st$, p - 1)
			EXIT FUNCTION
		ELSEIF k = keyBackspc THEN
			IF p > 1 THEN
				ofs = ofs - 2
				con.poke ofs, 32
				p = p - 1
			END IF
		ELSEIF k = keyEsc THEN
			con.getstr$ = ""
			EXIT FUNCTION
		ELSE
			IF p < maxchrs THEN
				MID$(st$, p, 1) = CHR$(k)
				con.poke ofs, k
				con.poke ofs + 1, atr
				ofs = ofs + 2
				p = p + 1
			END IF
		END IF
	LOOP
END FUNCTION

SUB setrgb(c, r, g, b)
    PALETTE c, r OR (g SHL 8) OR (b SHL 16)
END SUB

SUB message (txt$)
	w = LEN(txt$) + 4
	con.box 40 - (w \ 2), 20, w, 5, &H5E
	con.bar 41 - (w \ 2), 21, w - 2, 3, " "
	con.atrbar 41 - (w \ 2), 21, w - 2, 3, 7
	con.atrseg 41 - (w \ 2), 22, w - 2, 12
	con.putstrxy txt$, 42 - (w \ 2), 22
	i$ = ""
	WHILE i$ = "": i$ = INKEY$: WEND
END SUB

SUB puthyp (hyp$, x%, y%)
	ofs% = 2 * ((80 * y%) + x%)
	tonl% = 160
	p% = 1
	atr% = 7
	WHILE p% <= LEN(hyp$)
		l$ = MID$(hyp$, p%, 1)
		p% = p% + 1
		IF l$ = "<" THEN
			m$ = MID$(hyp$, p%, 1)
			p% = p% + 1
			IF m$ = "n" THEN
				ofs% = ofs% + tonl%
				tonl% = 160
			ELSEIF m$ = "<" THEN
				con.poke ofs%, 60: ofs% = ofs% + 1
				con.poke ofs%, atr%: ofs% = ofs% + 1
				tonl% = tonl% - 2
			ELSE
				n$ = MID$(hyp$, p%, 1)
				p% = p% + 1
				m% = ASC(m$)
				n% = ASC(n$)
				IF m% < 65 THEN m% = m% - 48 ELSE m% = m% - 55
				IF n% < 65 THEN n% = n% - 48 ELSE n% = n% - 55
				atr% = (m% * 16) OR n%
			END IF
		ELSE
			con.poke ofs%, ASC(l$): ofs% = ofs% + 1
			con.poke ofs%, atr%: ofs% = ofs% + 1
			tonl% = tonl% - 2
		END IF
	WEND
END SUB

FUNCTION shift
    shift = MULTIKEY(SC_LSHIFT) OR MULTIKEY(SC_RSHIFT)
END FUNCTION
