/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"ConfigKey.h"
#include	"ConfigKeyValue.h"

#include	<cassert>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

ConfigKey::ConfigKey ()
:	_name ()
,	_value_ptr (0)
{
	// Nothing
}



ConfigKey::ConfigKey (const char *name_0, const ConfigKeyValue &val)
:	_name (name_0)
,	_value_ptr (val.clone ())
{
	// Nothing
}



ConfigKey::ConfigKey (const ConfigKey &other)
:	_name (other._name)
,	_value_ptr (other._value_ptr->clone ())
{
	// Nothing
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

ConfigKey::~ConfigKey ()
{
	if (_value_ptr != 0)
	{
		delete _value_ptr;
		_value_ptr = 0;
	}
}



void	ConfigKey::set_name (const char *name_0)
{
	_name = name_0;
}



String	ConfigKey::get_name () const
{
	return (_name);
}



ConfigKeyValue	&	ConfigKey::get_value () const
{
	assert (_value_ptr != 0);

	return (*_value_ptr);
}



void	ConfigKey::set_value (const ConfigKeyValue &val)
{
	ConfigKeyValue *	temp_ptr = val.clone ();

	if (_value_ptr != 0)
	{
		delete _value_ptr;
		_value_ptr = 0;
	}

	_value_ptr = temp_ptr;
}



String	ConfigKey::get_string () const
{
	return (get_value ().get_string ());
}



std::list <ConfigKey> &	ConfigKey::get_list ()
{
	return (get_value ().get_list ());
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
