/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (EditString_CURRENT_HEADER)
	#error Inclusion recursive du header EditString.
#endif
#define	EditString_CURRENT_HEADER

#if ! defined (EditString_HEADER_INCLUDED)
#define	EditString_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types de chaines a editer */
enum
{
	EditString_TYPE_ALPHA = 0,				/* Alphanumerique */
	EditString_TYPE_HEXA,					/* Hexadecimal */
	EditString_TYPE_DEC,						/* Decimal */
	EditString_TYPE_FLO,						/* Virgule flotante */
	EditString_TYPE_FIX,						/* Virgule fixe, determinee par sa position dans la chaine d'entree */
	EditString_TYPE_MSC						/* Minutes-secondes-centiemes: MM:SS.CC */
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class EditString
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
EditString (char *text_0, int object, int max_len, int type);
~EditString (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		redraw (void);
void		refresh (void);
signed int	manage (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static EditString	*displayed_edit_string_ptr;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		check_disp_pos (void);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_object;				/* Numero de l'ogjet qui accueille l'edition (un EdBoxText) */
int		_type;				/* Type de la chaine editee */
int		_max_len;			/* Taille max de la chaine sans le 0 final */
char		*_text_0;				/* Pointeur sur la chaine a modifier */

bool		_displayed_flag;	/* true indique que la chaine et le curseur peuvent etre affiches */
signed int	_point_pos;		/* Position du point (pour les FLO ou FIX) */
int		_disp_len;			/* Longueur de la chaine utilisee de l'EdBoxText */
int		_cursor_pos;		/* Position du curseur dans la chaine */
int		_disp_pos;			/* Position de l'affichage EdBoxText dans la chaine */
char		*_work_0;			/* Chaine de travail */
char		*_string_0;			/* Chaine de l'EdBoxText */



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
EditString (void);
EditString (const EditString &other);
void		operator = (const EditString &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef EditString_CURRENT_HEADER
