/*****************************************************************************

        EnvSet.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (EnvSet_HEADER_INCLUDED)
#define	EnvSet_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250) // "Inherits via dominance."
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Envelope.h"



class EnvSet
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	class ComEnv
	{
	public:
		UWORD		nbr;						// Numero de l'enveloppe
		Envelope_PROCESS	proc;			// Structure de donnees de l'evolution de l'enveloppe
	};

						EnvSet ();
	virtual			~EnvSet () {}

	void				init_all_env (int instr, int track_type);

	static bool		is_handled_envelope (int track_type, int env_type);

	ComEnv			_com_env [Envelope_NBR_TYPES];	// Partie commune des enveloppes



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

//						EnvSet (const EnvSet &other);
//	EnvSet &			operator = (const EnvSet &other);
	bool				operator == (const EnvSet &other);
	bool				operator != (const EnvSet &other);

};	// class EnvSet



//#include	"EnvSet.hpp"



#endif	// EnvSet_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
