/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (ICWindow_CURRENT_HEADER)
	#error Inclusion recursive du header ICWindow.
#endif
#define	ICWindow_CURRENT_HEADER

#if ! defined (ICWindow_HEADER_INCLUDED)
#define	ICWindow_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"sliders.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	ICWindow_MAX_ZOOM		65536
#define	ICWindow_MIN_ZOOM		(1.0 / 65536)



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class ICWindow
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
ICWindow (int master_object, int h_offset, int window, int center,
          signed int _h_gadgets, signed int _v_gadgets,
          signed int h_sbar, signed int h_slider,
          signed int v_sbar, signed int v_slider,
          signed int arrow_left, signed int arrow_right,
          signed int arrow_up, signed int arrow_down,
          signed int h_zoom_in, signed int h_zoom_out,
          signed int v_zoom_in, signed int v_zoom_out,
          long h_length, long v_length, long h_pos = 0, long v_pos = 0,
          double h_zoom = 1, double v_zoom = 1);
virtual	~ICWindow (void);

virtual void	redraw (void);
virtual void	refresh (void);
virtual void	refresh_dynamic (bool force_flag);
virtual void	manage (int sel_object, int sel_elder);

virtual void	manage_main_window (int sel_object, int sel_elder);

virtual int		get_width (void);
virtual int		get_height (void);
virtual void	set_width (int width);
virtual void	set_height (int height);
virtual void	get_coordinates (int &pix_x, int &pix_y);
virtual void	move_to (int pix_x, int pix_y);

virtual void	set_h_length (long length);
virtual void	set_v_length (long length);
virtual long	get_h_length (void);
virtual long	get_v_length (void);
virtual void	set_h_pos (long pos);
virtual void	set_v_pos (long pos);
virtual long	get_h_pos (void);
virtual long	get_v_pos (void);
virtual void	set_h_zoom (double zoom);
virtual void	set_v_zoom (double zoom);
virtual double	get_h_zoom (void);
virtual double	get_v_zoom (void);
virtual void	check_pos (void);
virtual void	set_inversion_flag (int flag);
virtual void	get_mouse_point (long &x, long &y, int mouse_x, int mouse_y);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
SLID_INFO	_h_slider;
SLID_INFO	_v_slider;
int			_master_object;
signed int	_arrow_left;
signed int	_arrow_right;
signed int	_arrow_up;
signed int	_arrow_down;
signed int	_h_zoom_in;
signed int	_h_zoom_out;
signed int	_v_zoom_in;
signed int	_v_zoom_out;
long			_h_length;
long			_v_length;
long			_h_pos;
long			_v_pos;
double		_h_zoom;
double		_v_zoom;
int			_width;
int			_height;
int			_center;
int			_h_offset;
int			_h_gadgets;
int			_v_gadgets;
int			_inversion_flag;		// Indique que l'axe des Y est du bas vers le haut

protected:
int			_window;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
ICWindow (void);
ICWindow (const ICWindow &other);
void		operator = (const ICWindow &other);
int		operator == (const ICWindow &other) const;
int		operator != (const ICWindow &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ICWindow_CURRENT_HEADER
