/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MixPreset_CURRENT_HEADER)
	#error Inclusion recursive du header MixPreset.
#endif
#define	MixPreset_CURRENT_HEADER

#if ! defined (MixPreset_HEADER_INCLUDED)
#define	MixPreset_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"play_ct.h"

#include	<vector>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	MixPreset_NAME_LEN		32		/* Longueur du nom d'un preset de mixage */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class MixPreset
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
MixPreset (int number);
~MixPreset (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		get_preset_name (char *name_0);
void		set_preset_name (const char *name_0);
int		get_track_type (void);
void		set_track_type (int track_type);
int		get_track_number (void);
void		set_track_number (int track_nbr);
int		get_nbr_source_tracks (void);
signed int	set_nbr_source_tracks (int nbr_sources);
void		get_source_track (int source, PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr);
void		set_source_track (int source, const PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr);
long		get_volume (bool dry_flag);
void		set_volume (bool dry_flag, long volume);
long		get_panning (bool dry_flag);
void		set_panning (bool dry_flag, long panning);
int		get_stereo (void);
void		set_stereo (int stereo);

signed int	kill_preset (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	init (void);
void		restore (void);
void		reset_source_track (int pos);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

struct Source
{
	void		reset ();

	BYTE		track_type;		/* Numero du type de piste source */
	bool		dry_flag;		/* Pour les pistes d'effet, 0 = wet, 1 = dry */
	WORD		track;			/* Voie d'entree */
	UWORD		volume;			/* 0..1000..FFFF */
	WORD		balance;			/* 0..800..FFF */
};

typedef	std::vector <Source>	SourceArr;

int			_number;					// 1-... Bit 15 a 1: config actuelle d'un canal
char			_name [MixPreset_NAME_LEN];
int			_track_type;			// Type de piste (FX ou AOU)
int			_track_nbr;				// Piste d'application (par defaut)
int			_nbr_in;					// Nombre de voies en entree
int			_pan_wet;				// 0..800..FFF
int			_pan_dry;
UWORD			_vol_wet;				// 0..1000..FFFF
UWORD			_vol_dry;
int			_stereo;					// Pour les voies qui peuvent

SourceArr	_in_arr;					// Pour chaque voie en entree




/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
MixPreset (void);
MixPreset (const MixPreset &other);
void		operator = (const MixPreset &other);
int		operator == (const MixPreset &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MixPreset_CURRENT_HEADER
