/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (PatEdMenus_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdMenus.
#endif
#define	PatEdMenus_CURRENT_HEADER

#if ! defined (PatEdMenus_HEADER_INCLUDED)
#define	PatEdMenus_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuFiles.h"
#include	"PatEdMenuFx.h"
#include	"PatEdMenuInstruments.h"
#include	"PatEdMenuMidi.h"
#include	"PatEdMenuMix.h"
#include	"PatEdMenuPref.h"
#include	"PatEdMenuSamples.h"
#include	"PatEdMenuTools.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Identificateurs des differents sous-menus */
enum
{
	PatEdMenus_FILES = 0,
	PatEdMenus_TOOLS,
	PatEdMenus_INSTR,
	PatEdMenus_SPL,
	PatEdMenus_ENV,
	PatEdMenus_MIX,
	PatEdMenus_FX,
	PatEdMenus_MIDI,
	PatEdMenus_PREF,

	PatEdMenus_NBR_MENUS
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdMenus
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatEdMenus (void);
signed int	check_ok (void) const;
void	self_display (void) const;

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		get_coordinates (int &pix_x, int &pix_y);
void		move_to (int pix_x, int pix_y);

int		get_submenu (void) const;
void		set_submenu (int menu_nbr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_submenu;

PatEdMenuFiles			_files;
PatEdMenuTools			_tools;
PatEdMenuInstruments	_instruments;
PatEdMenuSamples		_samples;
PatEdMenuEnvelopes	_envelopes;
PatEdMenuMix			_mix;
PatEdMenuFx				_effects;
PatEdMenuMidi			_midi;
PatEdMenuPref			_pref;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdMenus_CURRENT_HEADER
