/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"log.h"
#include	"PatSelection.h"
#include	"patt.h"
#include	"tracks.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PatSelection::PatSelection (int pattern, int preset, int left_col, int start_line, int nbr_col, int nbr_lines)
{
	_pattern = pattern;
	_preset = preset;
	_left_col = left_col;
	_nbr_col = nbr_col;
	_start_line = start_line;
	_nbr_lines = nbr_lines;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

PatSelection::~PatSelection (void)
{
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatSelection::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatSelection::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatSelection::self_display (void) const
{

	/*** A faire ***/

}



void	PatSelection::check (void)
{
	int	height;
	int	nbr_col;

	height = PAT_get_pattern_height (_pattern);
	_start_line = MIN (_start_line, height - 1);
	_nbr_lines = MIN (_nbr_lines, height - _start_line);

	nbr_col = TRK_preset_data [_preset].nbr;
	_left_col = MIN (_left_col, nbr_col - 1);
	_nbr_col = MIN (_nbr_col, nbr_col - _left_col);
}



int	PatSelection::get_nbr_col (void) const
{
	return (_nbr_col);
}



int	PatSelection::get_nbr_lines (void) const
{
	return (_nbr_lines);
}



int	PatSelection::get_pattern (void) const
{
	return (_pattern);
}



int	PatSelection::get_track_type (void) const
{
	return (TRK_preset_data [_preset].track_type);
}



int	PatSelection::get_preset (void) const
{
	return (_preset);
}



int	PatSelection::get_left_col (void) const
{
	return (_left_col);
}



int	PatSelection::get_start_line (void) const
{
	return (_start_line);
}



int	PatSelection::get_track (int col) const
{
	return (TRK_preset_data [_preset].track_nbr [col + _left_col]);
}



void	*PatSelection::get_note_ptr (int col, int line) const
{
	return (PAT_get_note_adr_pat (TRK_preset_data [_preset].track_type,
	                              _pattern, line + _start_line,
	                              TRK_preset_data [_preset].track_nbr [col + _left_col]));
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
