/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"env.h"
#include	"Envelope.h"
#include	"EnvSet.h"
#include	"inst.h"
#include	"Player.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: env_manage_all_envelopes                                       */
/*      Description: Gere les enveloppes.                                   */
/*==========================================================================*/

void	Player::env_manage_all_envelopes ()
{
	for (int track_type = 0; track_type < Pattern_NBR_TYPES; track_type ++)
	{
		const int		track_max = GTK_nbr_tracks [track_type];
		for (int track = 0; track < track_max; track ++)
		{
			env_manage_envelope (track_type, track);
		}
	}
}



/*==========================================================================*/
/*      Nom: env_manage_envelope                                            */
/*      Description: Gere une certaine enveloppe pour une piste donnee.     */
/*      Parametres en entree:                                               */
/*        - track_type: type de la piste.                                   */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	Player::env_manage_envelope (int track_type, int track)
{
	TrackInfo &		track_info =
		_track_info [_track_info_list [track_type] [track]];

	for (int voice_cnt = 0; voice_cnt < track_info.mix.spl.nbr_voices; ++voice_cnt)
	{
		const int		voice_index = track_info.mix.spl.voice_index_arr [voice_cnt];
		Voice &			voice = _voice_arr [voice_index];

		for (int env_type = 0; env_type < Envelope_NBR_TYPES; ++env_type)
		{
			// Cherche le numero de l'enveloppe
			const int		env_nbr = voice._env_set._com_env [env_type].nbr;
			if (   env_nbr > 0
			    && EnvSet::is_handled_envelope (track_type, env_type))
			{
				ENV_process_tick (
					env_type,
					env_nbr,
					voice._env_set._com_env [env_type].proc
				);

				// Indique que le volume final doit etre recalcule
				if (env_type == Envelope_TYPE_VOL)
				{
					track_info.score.changed_volume_flag = true;
				}
			}
		}
	}
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
