/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (Popup_CURRENT_HEADER)
	#error Inclusion recursive du header Popup.
#endif
#define	Popup_CURRENT_HEADER

#if ! defined (Popup_HEADER_INCLUDED)
#define	Popup_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"base_ct.h"
#include	"PopupLine.h"
#include	"sliders.h"



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class	Popup
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Popup (void);
~Popup (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	redraw (void);
signed int	refresh (void) const;
signed int	add_line (const char *text_0, signed long code, bool selected_flag = false, bool disable_flag = false, Popup *popup_ptr = NULL);
signed long	manage (signed int default_line = -1);
void	select_by_line (signed int line, bool selected_flag);
signed int	select_by_code (signed long code, bool selected_flag);
void	select_radio_by_line (signed int line);
signed int	select_radio_by_code (signed long code);
void	disable_by_line (signed int line, bool disable_flag);
signed int	disable_by_code (signed long code, bool disable_flag);
bool		is_displayed (void) const;



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static Popup	*displayed_popup_ptr;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	LINE_ARRAY_GRANULARITY;



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	find_line_by_code (signed long code) const;
void	get_dimensions (int &pix_width, int &pix_height, int &disp_lines, bool &slider_flag) const;
void	format_line (int line, char *text_0) const;



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_nbr_lines;
int		_nbr_columns;
PopupLine	**_line_ptr;
signed int	_pix_x_pos;
signed int	_pix_y_pos;
signed int	_pix_width;
signed int	_pix_height;
int		_nbr_disp_lines;
bool		_slider_flag;
SLID_INFO	_slider;
bool		_displayed_flag;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Popup (const Popup &other);
Popup	operator = (const Popup &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Popup_CURRENT_HEADER
