/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<limits.h>

#include	"base_ct.h"
#include	"errors.h"
#include	"log.h"
#include	"memory.h"
#include	"PopupLine.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

const signed long	PopupLine::NO_ACTION = LONG_MIN;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PopupLine::PopupLine (const char *text_0, signed long code, bool selected_flag, bool disable_flag, void *popup_ptr)
{
	_text_0 = STRDUP (text_0);
	_code = code;
	_popup_ptr = popup_ptr;
	set_selected_flag (selected_flag);
	set_disable_flag (disable_flag);
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

PopupLine::~PopupLine (void)
{
	if (_text_0 != NULL)
	{
		FREE (_text_0);
		_text_0 = NULL;
	}
}



/*==========================================================================*/
/*      Nom: operator =                                                     */
/*      Description: Copie proprement l'objet par operation d'affectation.  */
/*      Parametres en entree:                                               */
/*        - copy: objet source.                                             */
/*==========================================================================*/

void	PopupLine::operator = (const PopupLine &copy)
{
	/* Evite de bousiller l'objet en cas de "a = a;" */
	if (&copy == this)
	{
		return;
	}

	if (_text_0 != NULL)
	{
		FREE (_text_0);
	}

	_text_0 = STRDUP (copy.get_text ());
	_code = copy.get_code ();
	set_selected_flag (copy.get_selected_flag ());
	set_disable_flag (copy.get_disable_flag ());
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PopupLine::check_ok (void) const
{
	if (_text_0 == NULL)
	{
		LOG_printf ("PopupLine::check_ok: Error: text pointer is null.\n");
		return (-1);
	}

	MCHECK (_text_0);

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PopupLine::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: get_code                                                       */
/*      Description: Renvoie le code de la ligne.                           */
/*      Retour: le code.                                                    */
/*==========================================================================*/

signed long	PopupLine::get_code (void) const
{
	return (_code);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Effectue les actions necessaires quand on a clique sur */
/*                   cette ligne. Cette routine est destinee a gerer des    */
/*                   sous-pop-up (n'est pas implemente pour l'instant).     */
/*      Retour: Code renvoye par la ligne, ou par celle du dernier sous     */
/*              menu.                                                       */
/*              Si la ligne etait invalidee, renvoie PopupLine::NO_ACTION.  */
/*==========================================================================*/

signed long	PopupLine::manage (void)
{
	if (_disable_flag)
	{
		return (PopupLine::NO_ACTION);
	}
	else
	{
		return (_code);
	}
}



/*==========================================================================*/
/*      Nom: get_text                                                       */
/*      Description: Renvoie le texte de la ligne.                          */
/*      Retour: pointeur sur le texte (a ne pas modifier directement.       */
/*==========================================================================*/

const char	*PopupLine::get_text (void) const
{
	return (_text_0);
}



/*==========================================================================*/
/*      Nom: get_selected_flag                                              */
/*      Description: Renvoie l'etat de "check" de la ligne.                 */
/*      Retour: true si la ligne est checkee, false sinon.                  */
/*==========================================================================*/

bool	PopupLine::get_selected_flag (void) const
{
	return (_selected_flag);
}



/*==========================================================================*/
/*      Nom: set_selected_flag                                              */
/*      Description: "Check" ou de-check une ligne.                         */
/*      Parametres en entree:                                               */
/*        - selected_flag: true si on doit checker.                         */
/*==========================================================================*/

void	PopupLine::set_selected_flag (bool selected_flag)
{
	_selected_flag = selected_flag;
}



/*==========================================================================*/
/*      Nom: get_disable_flag                                               */
/*      Description: Renvoie si une ligne est cliquable ou non.             */
/*      Retour: true si la ligne n'est pas cliquable, false sinon.          */
/*==========================================================================*/

bool	PopupLine::get_disable_flag (void) const
{
	return (_disable_flag);
}



/*==========================================================================*/
/*      Nom: set_disable_flag                                               */
/*      Description: Valide ou invalide une ligne.                          */
/*      Parametres en entree:                                               */
/*        - disable_flag: true si on doit invalider la ligne, false sinon.  */
/*==========================================================================*/

void	PopupLine::set_disable_flag (bool disable_flag)
{
	_disable_flag = disable_flag;
}



void	*PopupLine::get_popup_ptr (void) const
{
	return (_popup_ptr);
}



void	PopupLine::set_popup_ptr (void *popup_ptr)
{
	_popup_ptr = popup_ptr;
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur par copie)                                       */
/*      Description: Clone proprement l'objet.                              */
/*      Parametres en entree:                                               */
/*        - copy: objet a copier.                                           */
/*==========================================================================*/

PopupLine::PopupLine (const PopupLine &copy)
{
	_text_0 = STRDUP (copy._text_0);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
