/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (PopupLine_CURRENT_HEADER)
	#error Inclusion recursive du header PopupLine.
#endif
#define	PopupLine_CURRENT_HEADER

#if ! defined (PopupLine_HEADER_INCLUDED)
#define	PopupLine_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"base_ct.h"



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PopupLine
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const signed long	NO_ACTION;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PopupLine (const char *text_0, signed long code, bool selected_flag = false, bool disable_flag = false, void *popup_ptr = NULL);
~PopupLine (void);
void		operator = (const PopupLine &copy);
signed int	check_ok (void) const;
void		self_display (void) const;

const char	*get_text (void) const;
signed long	get_code (void) const;
signed long	manage (void);
bool		get_selected_flag (void) const;
void		set_selected_flag (bool selected_flag);
bool		get_disable_flag (void) const;
void		set_disable_flag (bool disable_flag);
void		*get_popup_ptr (void) const;
void		set_popup_ptr (void *popup_ptr);



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
char		*_text_0;
signed long	_code;
bool		_selected_flag;
bool		_disable_flag;
void		*_popup_ptr;



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
PopupLine (void);
PopupLine (const PopupLine &copy);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PopupLine_CURRENT_HEADER
