/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (ReconstructionFilter_CURRENT_HEADER)
	#error Inclusion recursive du header ReconstructionFilter.
#endif
#define	ReconstructionFilter_CURRENT_HEADER

#if ! defined (ReconstructionFilter_HEADER_INCLUDED)
#define	ReconstructionFilter_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"splhandl.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class ReconstructionFilter
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
ReconstructionFilter (int width);
~ReconstructionFilter (void);

void		resample_and_mix (const SWORD *s_buffer_ptr, float *d_buffer_ptr,
			                  LWORD length, int s_stereo, int d_stereo,
			                  SLWORD volume, ULWORD pos_frac, double inv_resample_factor);
void		clear_buffer (void);
void		copy_state (const ReconstructionFilter &other);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Largeur du sinus cardinal utilise pour le filtre (en samples, de part et
   d'autre de 0). Vaut normalement 64. Plus cette valeur est grande, plus le
	filtre est de bonne qualite mais plus le retard est important (il vaut
	d'ailleur _width / 2). */
int		_width;

/* Taille du buffer stereo en samples. Doit etre une puissance de 2. */
int		_buf_len;

/* Pointeur sur le buffer stereo qui accompagne le reechantillonnage tout au
   long des frames. Ce buffer est de la taille de _width + 1. */
double	(*_buffer_ptr) [2];

/* Poisition courante dans le buffer */
int		_buffer_pos;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
ReconstructionFilter (void);
ReconstructionFilter (const ReconstructionFilter &other);
void		operator = (const ReconstructionFilter &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ReconstructionFilter_CURRENT_HEADER
