/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (RscObject_CURRENT_HEADER)
	#error Inclusion recursive du header RscObject.
#endif
#define	RscObject_CURRENT_HEADER

#if ! defined (RscObject_HEADER_INCLUDED)
#define	RscObject_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class RscObject
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
RscObject (void);
virtual	~RscObject (void);
virtual signed int	check_ok (void) const = 0;
virtual void	self_display (void) const = 0;
virtual RscObject	*Create (void) const = 0;
virtual RscObject	*Clone (void) const = 0;

virtual void	display (void) const = 0;
virtual int		get_width (void) const = 0;
virtual void	set_width (int width) = 0;
virtual int		get_height (void) const = 0;
virtual void	set_height (int height) = 0;
virtual void	set_flag (LWORD flag) = 0;
virtual void	clear_flag (LWORD flag) = 0;
virtual void	pos_flag (LWORD flag, bool state) = 0;
virtual bool	test_flags (LWORD flag) const = 0;
virtual bool	test_all_flags (LWORD flag) const = 0;
virtual int		get_color (void) const = 0;
virtual void	set_color (int color) = 0;
virtual char	*get_string (void) const = 0;
virtual void	*set_string (const char *text_0) = 0;

/*** A finir ***/



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_child;
int		_brother;
int		_x;
int		_y;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
RscObject (const RscObject &other);
void		operator = (const RscObject &other);
int		operator == (const RscObject &other) const;
int		operator != (const RscObject &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef RscObject_CURRENT_HEADER
