/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SimpleCalculator_CURRENT_HEADER)
	#error Inclusion recursive du header SimpleCalculator.
#endif
#define	SimpleCalculator_CURRENT_HEADER

#if ! defined (SimpleCalculator_HEADER_INCLUDED)
#define	SimpleCalculator_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"ConfigKeyValueList.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class SimpleCalculator
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
enum ArgTypeMask
{
	MASK      = ~0x0FFF,
	VAL       = 0x0000,
	SPEC_VAR  = 0x1000,
	OPERATION = 0x2000,
	PARAMETER = 0x3000
};

enum SpecVar
{
	SAMPLE_FREQ = 0,
	TEMPO,

	NBR_SPEC_VAR
};

enum Operation
{
	ADD = 0,
	SUBSTRACT,
	MULTIPLY,
	DIVIDE,
	EXP,
	LOG,

	NBR_OPERATIONS
};

enum
{
	MAX_NBR_ARG = 16		// Nombre maximum d'arguments dans la fonction
};



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
SimpleCalculator (void);
~SimpleCalculator (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		reset (void);
signed int	add_argument (double arg);
signed int	add_spec_var (SpecVar type);
signed int	add_operation (Operation op);
signed int	add_parameter (void);
signed int	parse_op_list (const ConfigKeyValueList &op_list, const char *path_0);

double	calculate (double param) const;

static signed int	set_spec_var (SpecVar type, double val);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	NBR_OPERANDS [NBR_OPERATIONS];



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
double	_val [MAX_NBR_ARG];
int		_type [MAX_NBR_ARG];
long		_nbr_arg;
long		_final_stack_size;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static double	spec_var [NBR_SPEC_VAR];



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SimpleCalculator_CURRENT_HEADER
