/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"SplEdMenuBar.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdMenuBar::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_MENUBAR);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdMenuBar::refresh (void)
{

	/*** A faire ***/
	RSC_display_object (RSC_OBJ_SE_MENUBAR);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdMenuBar::manage (int sel_object, int sel_elder)
{
/*************************************************************************************************************************/
//	INTR_main_screen = INTR_MAIN_SCREEN_PATTERN_EDITOR;
/*************************************************************************************************************************/
	char		line_0 [20+1];
	Popup		popup_menu;
	Popup		sub_popup_menu;
enum
{
	FILE_OPEN = 1,
	FILE_OPEN_IN_2D2,
	FILE_SAVE,
	FILE_SAVE_AS,
	FILE_D2D,
	FILE_RETURN_TO_GT,

	EDIT_UNDO,
	EDIT_REDO,
	EDIT_CUT,
	EDIT_COPY,
	EDIT_PASTE,
	EDIT_SELECT_ALL,
	EDIT_DELETE,
	EDIT_CROP,
	EDIT_SAMPLE_INFO,

	VIEW_ALL,
	VIEW_TIME_FREQ,
		VIEW_TIME_FREQ_OUT_FULL,
		VIEW_TIME_FREQ_REGION,
		VIEW_TIME_FREQ_IN_FULL_CENTER,
		VIEW_TIME_FREQ_IN_FULL_START,
		VIEW_TIME_FREQ_IN_FULL_END,
		VIEW_TIME_FREQ_IN,
		VIEW_TIME_FREQ_OUT,
	VIEW_ZOOM_LEVEL,
		VIEW_ZOOM_LEVEL_OUT_FULL,
		VIEW_ZOOM_LEVEL_IN_FULL,
		VIEW_ZOOM_LEVEL_IN,
		VIEW_ZOOM_LEVEL_OUT,
	VIEW_TOOLBAR,
	VIEW_LOOP_TUNER,
	VIEW_FREQUENCY,

	PROCESS_INVERT,
	PROCESS_FLIP,
	PROCESS_SIGN,
	PROCESS_BYTE_SWAP,
	PROCESS_RESAMPLING,
	PROCESS_VOLUME,
	PROCESS_CHANNEL_CONVERTER,
	PROCESS_TIME_STRETCH,
	
	EFFECTS_EDITOR,
};
	switch (sel_object)
	{

	/* File */
	case	RSC_OBJ_SE_MENUBAR_FILE:
		sprintf(line_0,"Open...");
		popup_menu.add_line (line_0, FILE_OPEN);
		sprintf(line_0,"Open in D2D...");
		popup_menu.add_line (line_0, FILE_OPEN_IN_2D2);
		sprintf(line_0,"Save");
		popup_menu.add_line (line_0, FILE_SAVE);
		sprintf(line_0,"Save as...");
		popup_menu.add_line (line_0, FILE_SAVE_AS);
		sprintf(line_0,"__________________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Direct to disk",true,true);
		popup_menu.add_line (line_0, FILE_D2D);
		sprintf(line_0,"__________________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Back to pattern...");
		popup_menu.add_line (line_0, FILE_RETURN_TO_GT);
		switch (popup_menu.manage())
		{
		case FILE_OPEN:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case FILE_OPEN_IN_2D2:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case FILE_SAVE:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case FILE_SAVE_AS:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case FILE_D2D:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case FILE_RETURN_TO_GT:
			INTR_main_screen = INTR_MAIN_SCREEN_PATTERN_EDITOR;
			break;
		}
		break;

	/* Edit */
	case	RSC_OBJ_SE_MENUBAR_EDIT:
		sprintf(line_0,"Undo");
		popup_menu.add_line (line_0, EDIT_UNDO);
		sprintf(line_0,"Redo");
		popup_menu.add_line (line_0, EDIT_REDO);
		sprintf(line_0,"______________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Cut");
		popup_menu.add_line (line_0, EDIT_CUT);
		sprintf(line_0,"Copy");
		popup_menu.add_line (line_0, EDIT_COPY);
		sprintf(line_0,"Paste");
		popup_menu.add_line (line_0, EDIT_PASTE);
		sprintf(line_0,"Select all");
		popup_menu.add_line (line_0, EDIT_SELECT_ALL);
		sprintf(line_0,"______________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Delete");
		popup_menu.add_line (line_0, EDIT_DELETE);
		sprintf(line_0,"Crop");
		popup_menu.add_line (line_0, EDIT_CROP);
		sprintf(line_0,"______________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Sample info...");
		popup_menu.add_line (line_0, EDIT_SAMPLE_INFO);

		switch (popup_menu.manage())
		{
		case EDIT_UNDO:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A FAIRE ***/
			break;
		case EDIT_REDO:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_CUT:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_COPY:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_PASTE:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_SELECT_ALL:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_DELETE:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_CROP:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case EDIT_SAMPLE_INFO:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		}
		break;

	/* View */
	case	RSC_OBJ_SE_MENUBAR_VIEW:
		sprintf(line_0,"View all");
		popup_menu.add_line (line_0, VIEW_ALL);
		sprintf(line_0,"Zoom Time/Freq >");
		popup_menu.add_line (line_0, VIEW_TIME_FREQ);
		sprintf(line_0,"Zoom Level     >");
		popup_menu.add_line (line_0, VIEW_ZOOM_LEVEL);
		sprintf(line_0,"________________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Toolbar");
		popup_menu.add_line (line_0, VIEW_TOOLBAR);
		sprintf(line_0,"________________");
		popup_menu.add_line (line_0, 999, false, true);
		sprintf(line_0,"Loop Tuner",true,true);
		popup_menu.add_line (line_0, VIEW_LOOP_TUNER);
		sprintf(line_0,"Frequency",true,true);
		popup_menu.add_line (line_0, VIEW_FREQUENCY);
		switch (popup_menu.manage())
		{
		case VIEW_ALL:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case VIEW_TIME_FREQ:
			sprintf(line_0,"Out full");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_OUT_FULL);
			sprintf(line_0,"Region");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_REGION);
			sprintf(line_0,"In full (center)");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_IN_FULL_CENTER);
			sprintf(line_0,"In full (start)");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_IN_FULL_START);
			sprintf(line_0,"In full (end)");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_IN_FULL_END);
			sprintf(line_0,"In");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_IN);
			sprintf(line_0,"Out");
			sub_popup_menu.add_line (line_0, VIEW_TIME_FREQ_OUT);
			switch (sub_popup_menu.manage())
			{
			case VIEW_TIME_FREQ_OUT_FULL:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_REGION:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_IN_FULL_CENTER:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_IN_FULL_START:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_IN_FULL_END:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_IN:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_TIME_FREQ_OUT:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			}
			break;
		case VIEW_ZOOM_LEVEL:
			sprintf(line_0,"Out full");
			sub_popup_menu.add_line (line_0, VIEW_ZOOM_LEVEL_OUT_FULL);
			sprintf(line_0,"In full");
			sub_popup_menu.add_line (line_0, VIEW_ZOOM_LEVEL_IN_FULL);
			sprintf(line_0,"In full");
			sub_popup_menu.add_line (line_0, VIEW_ZOOM_LEVEL_IN);
			sprintf(line_0,"In full");
			sub_popup_menu.add_line (line_0, VIEW_ZOOM_LEVEL_OUT);
			switch (sub_popup_menu.manage())
			{
			case VIEW_ZOOM_LEVEL_OUT_FULL:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_ZOOM_LEVEL_IN_FULL:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_ZOOM_LEVEL_IN:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			case VIEW_ZOOM_LEVEL_OUT:
				INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
				/*** A faire ***/
				break;
			}
			break;
		case VIEW_TOOLBAR:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case VIEW_LOOP_TUNER:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case VIEW_FREQUENCY:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		}
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Process */
	case	RSC_OBJ_SE_MENUBAR_PROC:
		sprintf(line_0,"Invert");
		popup_menu.add_line (line_0, PROCESS_INVERT);
		sprintf(line_0,"Flip");
		popup_menu.add_line (line_0, PROCESS_FLIP);
		sprintf(line_0,"Sign");
		popup_menu.add_line (line_0, PROCESS_SIGN);
		sprintf(line_0,"Byte Swap");
		popup_menu.add_line (line_0, PROCESS_BYTE_SWAP);
		sprintf(line_0,"____________________");
		popup_menu.add_line (line_0, 999,false,true);
		sprintf(line_0,"Resampling...");
		popup_menu.add_line (line_0, PROCESS_RESAMPLING);
		sprintf(line_0,"Volume...");
		popup_menu.add_line (line_0, PROCESS_VOLUME);
		sprintf(line_0,"Channel Converter...");
		popup_menu.add_line (line_0, PROCESS_CHANNEL_CONVERTER);
		sprintf(line_0,"Time stretch...");
		popup_menu.add_line (line_0, PROCESS_TIME_STRETCH);
		switch (popup_menu.manage())
		{
		case PROCESS_INVERT:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_FLIP:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_SIGN:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_BYTE_SWAP:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_RESAMPLING:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_VOLUME:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_CHANNEL_CONVERTER:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		case PROCESS_TIME_STRETCH:
			INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
			/*** A faire ***/
			break;
		}
		break;

	/* Effects */
	case	RSC_OBJ_SE_MENUBAR_FX:
		sprintf(line_0,"Invert");
		popup_menu.add_line (line_0, PROCESS_INVERT);
		if (popup_menu.manage() == EFFECTS_EDITOR)
		{
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		}
		break;

	/* Help */
	case	RSC_OBJ_SE_MENUBAR_HELP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	}
}



int	SplEdMenuBar::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_MENUBAR));
}



int	SplEdMenuBar::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_MENUBAR));
}



void	SplEdMenuBar::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_MENUBAR];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_MENUBAR];
}



void	SplEdMenuBar::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_MENUBAR, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
