/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SplEdWindow_CURRENT_HEADER)
	#error Inclusion recursive du header SplEdWindow.
#endif
#define	SplEdWindow_CURRENT_HEADER

#if ! defined (SplEdWindow_HEADER_INCLUDED)
#define	SplEdWindow_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"sliders.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types d'affichage de sample */
enum
{
	SplEdWindow_SPL_MEMORY = 0,		// Sample en memoire
	SplEdWindow_SPL_DISK,				// Sample en Direct-To-Disk

	SplEdWindow_NBR_SPL_TYPES
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class SplEdWindow
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
SplEdWindow (void);
~SplEdWindow (void);

void		redraw (void);
void		refresh (void);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		set_width (int width);
void		set_height (int height);
void		get_coordinates (int &pix_x, int &pix_y);
void		move_to (int pix_x, int pix_y);

static long	get_real_nbr_disp_spl (void);
static long	get_max_nbr_disp_spl (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

/* Les couleurs utilisees pour l'affichage du sample (dans l'ordre des layers) */
static int	color_window;											// Fond de la fenetre
static int	color_background [SplEdWindow_NBR_SPL_TYPES] [2];		// Fond du sample [pas sel/selectione]
static int	color_center_line [SplEdWindow_NBR_SPL_TYPES];			// Ligne du 0 V
static int	color_6db_line [SplEdWindow_NBR_SPL_TYPES];				// Ligne a -6 dB
static int	color_channel_separator [SplEdWindow_NBR_SPL_TYPES];	// Ligne de separation des canaux (stereo)
static int	color_data [SplEdWindow_NBR_SPL_TYPES] [3];				// Courbe du sample [pas sel/selectione/loop]



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	SplEdWindow::display_wave (int sample, int object);
signed int	SplEdWindow::display_wave_normal (int sample, int object);
signed int	SplEdWindow::display_wave_loop (int sample, int object);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
SLID_INFO	_h_slider;
SLID_INFO	_v_slider;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:


/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		operator = (const SplEdWindow &other);
int		operator == (const SplEdWindow &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SplEdWindow_CURRENT_HEADER
