/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (WaveForm_CURRENT_HEADER)
	#error Inclusion recursive du header WaveForm.
#endif
#define	WaveForm_CURRENT_HEADER

#if ! defined (WaveForm_HEADER_INCLUDED)
#define	WaveForm_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"base_ct.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types de bouclage */
#define	WaveForm_LOOP_TYPE_NONE		0			/* Pas de bouclage */
#define	WaveForm_LOOP_TYPE_FWD		1			/* Bouclage normal, vers l'avant */
#define	WaveForm_LOOP_TYPE_PP		3			/* Bouclage en ping-pong */

#define	WaveForm_BASE_LENGTH_P2		10			/* Toujours >= 2 */
#define	WaveForm_BASE_LENGTH			(1L << WaveForm_BASE_LENGTH_P2)	/* Nombre de points pour chaque onde de base */

/* Types d'ondes de base */
enum
{
	WaveForm_BASE_SIN = 0,
	WaveForm_BASE_SQUARE,
	WaveForm_BASE_TRIANGLE,
	WaveForm_BASE_RAMP_UP,
	WaveForm_BASE_RAMP_DOWN,
	WaveForm_BASE_RANDOM,

	WaveForm_NBR_BASE_FORMS
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class WaveForm
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
WaveForm (int p2length, int loop_type = WaveForm_LOOP_TYPE_NONE, bool interpolation_flag = false);
~WaveForm (void);
signed int	check_ok (void) const;
void		self_display (void) const;

inline double	*get_table_ptr (void) const;
double	get_point (signed long pos_int, double pos_frac) const ;
inline double	get_point (QWORD pos) const;
inline double	get_point (double pos) const;
inline double	get_point_fast (long pos) const;

static signed int	init (void);
static void	restore (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static WaveForm	*base_ptr [WaveForm_NBR_BASE_FORMS];
static const char	*const name_0_ptr [WaveForm_NBR_BASE_FORMS];



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
double	*_table_ptr;
long		_length;
long		_mask;
int		_loop_type;
bool		_interpolation_flag;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
WaveForm (void);
WaveForm (const WaveForm &other);
void		operator = (const WaveForm &other);
int		operator == (const WaveForm &other) const;
int		operator != (const WaveForm &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef WaveForm_CURRENT_HEADER
