/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"base.h"
#include	"base_ct.h"
#include	"env.h"
#include	"Envelope.h"
#include	"inst.h"
#include	"log.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* L'enveloppe 0 n'est pas utilisee. */
Envelope	*ENV_env_ptr [1+INST_NBRINSTR_MAXI] [Envelope_NBR_TYPES];



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	ENV_init (void)
{
	for (int cnt = 1; cnt <= INST_NBRINSTR_MAXI; cnt ++)
	{
		for (int type = 0; type < Envelope_NBR_TYPES; type ++)
		{
			ENV_env_ptr [cnt] [type] = new Envelope (cnt, type);
			if (ENV_env_ptr [cnt] [type] == NULL)
			{
				LOG_printf ("ENV_init: couldn't create envelope # %d, type %d.\n", cnt, type);
				return (-1);
			}
			if (ENV_env_ptr [cnt] [type]->check_ok ())
			{
				LOG_printf ("ENV_init: couldn't create envelope # %d, type %d.\n", cnt, type);
				return (-1);
			}
		}
	}

	return (0);
}



void	ENV_restore (void)
{
	for (int cnt = 1; cnt <= INST_NBRINSTR_MAXI; cnt ++)
	{
		for (int type = 0; type < Envelope_NBR_TYPES; type ++)
		{
			if (ENV_env_ptr [cnt] [type] != NULL)
			{
				delete ENV_env_ptr [cnt] [type];
				ENV_env_ptr [cnt] [type] = NULL;
			}
		}
	}
}



WORD	ENV_get_flags (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_flags ());
}



void	ENV_set_flags (int env_type, int env, WORD flags)
{
	ENV_env_ptr [env] [env_type]->set_flags (flags);
}



int	ENV_get_nbr_points (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_nbr_points ());
}



void	ENV_set_nbr_points (int env_type, int env, int nbr_points)
{
	ENV_env_ptr [env] [env_type]->set_nbr_points (nbr_points);
}



Envelope_POINT	ENV_get_point (int env_type, int env, int pos)
{
	return (ENV_env_ptr [env] [env_type]->get_point (pos));
}



void	ENV_set_point (int env_type, int env, int pos, const Envelope_POINT &point)
{
	ENV_env_ptr [env] [env_type]->set_point (pos, point);
}



Envelope_LOOP	ENV_get_loop (int env_type, int env, int type)
{
	return (ENV_env_ptr [env] [env_type]->get_loop (type));
}



void	ENV_set_loop (int env_type, int env, int type, const Envelope_LOOP &loop)
{
	ENV_env_ptr [env] [env_type]->set_loop (type, loop);
}



UWORD	ENV_get_lfo_speed (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_lfo_speed ());
}



void	ENV_set_lfo_speed (int env_type, int env, UWORD val)
{
	ENV_env_ptr [env] [env_type]->set_lfo_speed (val);
}



UWORD	ENV_get_lfo_depth (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_lfo_depth ());
}



void	ENV_set_lfo_depth (int env_type, int env, UWORD val)
{
	ENV_env_ptr [env] [env_type]->set_lfo_depth (val);
}



UWORD	ENV_get_lfo_sweep (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_lfo_sweep ());
}



void	ENV_set_lfo_sweep (int env_type, int env, UWORD val)
{
	ENV_env_ptr [env] [env_type]->set_lfo_sweep (val);
}



UWORD	ENV_get_fadeout (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_fadeout ());
}



void	ENV_set_fadeout (int env_type, int env, UWORD val)
{
	ENV_env_ptr [env] [env_type]->set_fadeout (val);
}



int	ENV_get_lfo_waveform (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->get_lfo_waveform ());
}



void	ENV_set_lfo_waveform (int env_type, int env, int val)
{
	ENV_env_ptr [env] [env_type]->set_lfo_waveform (val);
}



void	ENV_start (int env_type, int env, Envelope_PROCESS &proc)
{
	ENV_env_ptr [env] [env_type]->start (proc);
}



void	ENV_process_tick (int env_type, int env, Envelope_PROCESS &proc)
{
	ENV_env_ptr [env] [env_type]->process_tick (proc);
}



signed int	ENV_kill_envelope (int env_type, int env)
{
	return (ENV_env_ptr [env] [env_type]->kill_envelope ());
}



long	ENV_get_length_in_ticks (int env_type, int env, int last_point)
{
	int		nbr_points;
	int		point_cnt;
	long		length;

	length = 0;
	nbr_points = ENV_get_nbr_points (env_type, env);
	nbr_points = MIN (last_point, nbr_points - 1);
	for (point_cnt = 0; point_cnt < nbr_points; point_cnt ++)
	{
		length += ENV_get_point (env_type, env, point_cnt).time;
	}

	return (length);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
