/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (ERR_CURRENT_HEADER)
	#error Inclusion recursive du header ERR.
#endif
#define	ERR_CURRENT_HEADER

#if ! defined (ERR_HEADER_INCLUDED)
#define	ERR_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES ET MACROS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	ERR_init (void);
void	ERR_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de verification de l'integrite d'une zone memoire          */
/*--------------------------------------------------------------------------*/

void	ERR_mem_guardian_init (void *zone_ptr, long length);
signed int	ERR_mem_guardian_check (void);
unsigned long	ERR_compute_checksum (UBYTE *zone_ptr, long length);

signed int	ERR_check_all (void);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ERR_CURRENT_HEADER
