/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (FILE_CURRENT_HEADER)
	#error Inclusion recursive du header FILE.
#endif
#define	FILE_CURRENT_HEADER

#if ! defined (FILE_HEADER_INCLUDED)
#define	FILE_HEADER_INCLUDED



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"file_ct.h"
#include	"String.h"



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

FILE* FILE_fopen (const char *filename_0, const char *mode_0);
int	FILE_fseek (FILE *f_ptr, int64_t offset, int origin);
int64_t	FILE_ftell (FILE *f_ptr);
int	FILE_read_string_in_file (char *buffer_0, FILE *file_ptr);

/*--------------------------------------------------------------------------*/
/*      Initialisations                                                     */
/*--------------------------------------------------------------------------*/

signed int FILE_get_program_path (void);
signed int	FILE_init (void);
void	FILE_restore (void);
void	FILE_generate_new_module_name (void);
signed int	FILE_load_init_prefs (void);
signed int	FILE_autoloading (void);

/*--------------------------------------------------------------------------*/
/*      Disk                                                                */
/*--------------------------------------------------------------------------*/

bool	FILE_drive_connected (int drive);
int	FILE_get_current_drive (void);
bool	FILE_get_first_file (const char *path_0, FILE_DIR_ENTRY *ptr_dir_entry, char *filename_0);
bool	FILE_get_next_file (FILE_DIR_ENTRY *ptr_dir_entry, char *filename_0);
signed int	FILE_get_free_disk_space (int drive, int64_t *free, int64_t *total);
int64_t	FILE_get_file_length (FILE *file_ptr);
int64_t	FILE_get_file_length (const char *filename_0);
signed int	FILE_change_file_length  (FILE *file_ptr, int64_t length);
bool	FILE_file_exist (const char *filename_0);

signed int	FILE_backup (const char *filename_0, int nbr_backup);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern const char	FILE_path_separator_0 [];

extern String	FILE_module_filename;
extern String	FILE_sample_filename;
extern String	FILE_instrument_filename;
extern String	FILE_prefs_filename;
extern String	FILE_auto_module_filename;
extern String	FILE_misc_filename;

extern String	FILE_program_pathname;
extern String	FILE_auto_sample_pathname;

extern String	FILE_module_maskname;
extern String	FILE_song_maskname;
extern String	FILE_sample_maskname;
extern String	FILE_instrument_maskname;
extern String	FILE_prefs_maskname;
extern String	FILE_auto_sample_maskname;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FILE_CURRENT_HEADER
