/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (INTR_CURRENT_HEADER)
	#error Inclusion recursive du header INTR.
#endif
#define	INTR_CURRENT_HEADER

#if ! defined (INTR_HEADER_INCLUDED)
#define	INTR_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"
#include	"Image.h"
#include	"Mouse.h"
#include	"PatEdMenus.h"
#include	"PatEdTracks.h"
#include	"SplEdMainLoop.h"
#include	"String.h"

#include	<list>

class ConfigKey;


/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Les ecrans principaux */
enum
{
	INTR_MAIN_SCREEN_PATTERN_EDITOR = 0,
	INTR_MAIN_SCREEN_SAMPLE_EDITOR,
	INTR_MAIN_SCREEN_SCORE_EDITOR,
	INTR_MAIN_SCREEN_DRUM_EDITOR
};

/* Souris */
enum
{
	INTR_CLICK_RELEASED = 0,			/* Bouton releche */
	INTR_CLICK_SINGLE,					/* Simple clic (avec relechemnt) */
	INTR_CLICK_DOUBLE,					/* Double clic */
	INTR_CLICK_HELD,						/* Bouton maintenu enfonce */
};
#define	INTR_CLICK_SPEED			25	/* Duree minimale d'un double-click en 100eme de seconde. */

/* Changement des variables */
enum
{
	INTR_CHGTYPE_ABS = 0,				/* Parametre absolu */
	INTR_CHGTYPE_REL,						/* Parametre relatif */
	INTR_CHGTYPE_KBD,						/* Entree au clavier */
	INTR_CHGTYPE_POP,						/* Parametre Pop-up */
	INTR_CHGTYPE_NONE						/* Aucune modification (seulement mise a jour) */
};

/* Types d'affichages pour les positions des samples */
enum
{
	INTR_SPLPOS_TYPE_HEXA = 0,			/* Hexadecimal */
	INTR_SPLPOS_TYPE_DECI,				/* Decimal */
	INTR_SPLPOS_TYPE_MSC,				/* Minutes:Secondes.Centiemes */
	INTR_SPLPOS_TYPE_SM,					/* Secondes.Millisecondes */
};

/* Types d'affichage pour les temps et frequences */
enum
{
	INTR_TIME_UNIT_SEC = 0,				/* En secondes */
	INTR_TIME_UNIT_MSEC,					/* En milli-secondes */
	INTR_TIME_UNIT_BEATS,				/* En fraction de beat */
	INTR_TIME_UNIT_SPL,					/* En samples */
	INTR_TIME_UNIT_HZ,					/* En Hz */
	INTR_TIME_UNIT_NOTE,					/* En note + finetune */

	INTR_NBR_TIME_UNITS
};

/* Types speciaux de Line Step */
enum
{
	INTR_LINE_STEP_NL = 256,			/* Next line */
	INTR_LINE_STEP_NN,					/* Next note */
	INTR_LINE_STEP_NF,					/* Next FX */
	INTR_LINE_STEP_NV,					/* Next volume */
	INTR_LINE_STEP_NEF					/* Next empty FX */
};

/* Ombres des panneaux */
#define	INTR_SHADOW_CARXDEC		1
#define	INTR_SHADOW_PIXYDEC		(INTR_SHADOW_CARXDEC * RSC_CHAR_W)

/* Actions a retardement */
enum
{
	INTR_WAITOP_SPL_RPOS = 1,
	INTR_WAITOP_SPL_RLEN,
	INTR_WAITOP_SPL_DOFFSET
};



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*--------------------------------------------------------------------------*/
/*      Initialisations                                                     */
/*--------------------------------------------------------------------------*/

WORD	INTR_init_interface (void);
void	INTR_restore_interface (void);
void	INTR_init_dec_2_ascii (void);
signed int	INTR_read_display_conf (const std::list <ConfigKey> &key_list);

/*--------------------------------------------------------------------------*/
/*      Souris                                                              */
/*--------------------------------------------------------------------------*/

int	INTR_test_mouse_click (void);
void	INTR_wait_mouse (bool etat);

/*--------------------------------------------------------------------------*/
/*      Divers                                                              */
/*--------------------------------------------------------------------------*/

void	INTR_redraw_all (void);

void	INTR_do_waiting_op (bool act_flag);
void	INTR_splpos_2_string (char *string_0, long spl_pos, long freq_ech, int nbr_chan, int nbr_bytes);
void	INTR_select_splpos_unit (void);

void	INTR_time_2_string (char *string_0, int unit, double sec, int length = 6, double tempo = -1);
bool	INTR_string_2_time (const char *string_0, int unit, double &sec, double tempo = -1);
bool	INTR_select_time_unit (int &unit);
signed int	INTR_set_time_intr (int type, double value, int object, int unit, double &sec, double tempo = -1);

void	INTR_freq_2_string (char *string_0, int unit, double freq, int length, double tempo = -1);
bool	INTR_string_2_freq (const char *string_0, int unit, double &freq, double tempo = -1);
signed int	INTR_set_freq_intr (int type, double value, int object, int unit, double &freq, double tempo = -1);

void	INTR_stop_song (void);
void	INTR_play_song (bool cont_flag);
void	INTR_play_pattern (bool cont_flag);

signed int	INTR_dialog_box (const char *title_0, const char *text_0, const char *buttons_0, signed int default_button, signed int cancel_button);
signed int	INTR_progress_box (const char *title_0,
				                   const volatile long *total_ptr,
				                   const volatile long *position_ptr,
				                   const volatile bool *active_flag_ptr,
				                   volatile bool *cancel_flag_ptr);
String	INTR_file_selector (const char *path_0, const char *file_0, const char *label_0, const char *format_string_0);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern const char	INTR_hexa_2_ascii [256*2+1];
extern const char	INTR_hexa_2_ascii_space [256*2+1];
extern const char	INTR_hexa_2_ascii_point [256*2+1];
extern const char	INTR_note_names [GTK_NBRNOTES_MAXI] [4];
extern const char	*const INTR_time_unit_name_0_ptr [INTR_NBR_TIME_UNITS];
extern char	INTR_dec_2_ascii_units_char [1000] [4];
extern char	INTR_dec_2_ascii_1000_char_s1 [256] [2];
extern char	INTR_dec_2_ascii_1000_char_s2 [256] [2];
extern UWORD	INTR_dec_2_ascii_1000_int [257];

extern int		INTR_waiting_operation_type;

/*--------------------------------------------------------------------------*/
/*      Affichage                                                           */
/*--------------------------------------------------------------------------*/

extern Mouse	*INTR_graph_ptr;
extern int	INTR_init_sreen_resol_width;
extern int	INTR_init_sreen_resol_height;
extern Mouse_CURRENT_STATE	INTR_mouse;

extern int	INTR_main_screen;
extern SplEdMainLoop *INTR_sample_editor_interface_ptr;
extern PatEdMenus *INTR_pattern_editor_menu_ptr;
extern PatEdTracks	*INTR_pattern_editor_track_ptr;

extern int	INTR_double_click_speed;
extern const int	INTR_inc_speed [] [4];

extern int	INTR_base_song;
extern char	INTR_base_song_3 [4+1];
extern char	INTR_base_song_5 [4+1];
extern int	INTR_base_track;
extern char	INTR_base_track_2 [4+1];
extern int	INTR_base_lines;
extern char	INTR_base_lines_3 [4+1];
extern char	INTR_base_lines_2 [4+1];
extern int	INTR_base_speed;
extern char	INTR_base_speed_3 [4+1];
extern const char *	INTR_base_clock_min_sec;

extern int INTR_splpos_type;
extern bool	INTR_splpos_byte_flag;

extern int	INTR_time_unit;
extern int	INTR_freq_unit;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef INTR_CURRENT_HEADER
