/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MIXP_CURRENT_HEADER)
	#error Inclusion recursive du header MIXP.
#endif
#define	MIXP_CURRENT_HEADER

#if ! defined (MIXP_HEADER_INCLUDED)
#define	MIXP_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"play_ct.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	MIXP_NBRMIXP_MAXI		255		/* 1-255 */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	MIXP_init (void);
void	MIXP_restore (void);

void	MIXP_get_preset_name (int preset, char *name_0);
void	MIXP_set_preset_name (int preset, const char *name_0);
int	MIXP_get_track_type (int preset);
void	MIXP_set_track_type (int preset, int track_type);
int	MIXP_get_track_number (int preset);
void	MIXP_set_track_number (int preset, int track_nbr);
int	MIXP_get_nbr_source_tracks (int preset);
signed int	MIXP_set_nbr_source_tracks (int preset, int nbr_sources);
void	MIXP_get_source_track (int preset, int source, PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr);
void	MIXP_set_source_track (int preset, int source, const PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr);
long	MIXP_get_volume (int preset, bool dry_flag);
void	MIXP_set_volume (int preset, bool dry_flag, long volume);
long	MIXP_get_panning (int preset, bool dry_flag);
void	MIXP_set_panning (int preset, bool dry_flag, long panning);
int	MIXP_get_stereo (int preset);
void	MIXP_set_stereo (int preset, int stereo);

signed int	MIXP_remove_source_track (int preset, int source);
signed int	MIXP_remove_track_from_all_presets (int track_type, int track);
signed int	MIXP_kill_preset (int preset);

signed int MIXP_clear_presets (void);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MIXP_CURRENT_HEADER
