/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MODS_CURRENT_HEADER)
	#error Inclusion recursive du header MODS.
#endif
#define	MODS_CURRENT_HEADER

#if ! defined (MODS_HEADER_INCLUDED)
#define	MODS_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"Pattern.h"
#include	"Envelope.h"
#include	"String.h"

#include <string>
#include <vector>



/*\\\ CONSTANTES ET MACROS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Longueur en octets des informations temporaires
   collectees a la reconnaissance du format */
#define	MODS_TEMP_INFO_LEN		1024

enum
{
	MODS_FORMAT_GT2 = 0,
};

/* Format inconnu */
#define	MODS_IMPORT_FORMAT_UNKNOWN		999



/* Cellule de descpription de la position d'un chunk dans un fichier */
typedef struct
{
	char           id [4];
	int64_t        offset;
	long           size;
} MODS_CHUNK_OFFSET;



/*\\\ STRUCURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	const char	*name_0;
	const char	*ext_0;
	const char	*sng_ext_0;

	signed int	(*save_module_ptr) (FILE *file_ptr);
	signed int	(*save_song_ptr) (FILE *file_ptr);
	signed int	(*load_module_ptr) (FILE *file_ptr, BYTE temp_info [MODS_TEMP_INFO_LEN]);
	bool	(*detect_format_ptr) (FILE *file_ptr, const void *header_ptr, long header_length, BYTE temp_info [MODS_TEMP_INFO_LEN]);

	bool		save_module_flag;
	bool		save_song_flag;
	bool		load_module_flag;
} MODS_FORMAT_ROUTINES;



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	MODS_select_module_filename (String &total_name, const char *title_0, bool song_flag, bool save_flag);
void	MODS_load_mru_file_list ();
std::vector <std::string> MODS_get_mru_file_list ();
void  MODS_remove_from_mru_file_list (int index);

/*--------------------------------------------------------------------------*/
/*      Sauvegarde                                                          */
/*--------------------------------------------------------------------------*/

signed int	MODS_save_module (bool song_flag);
signed int	MODS_save_module_direct (const char *filename_0, bool song_flag);
signed int	MODS_save_fx_preset (int preset);
signed int	MODS_save_fx_preset_direct (const char *filename_0, int preset);

/*--------------------------------------------------------------------------*/
/*      Chargement                                                          */
/*--------------------------------------------------------------------------*/

signed int	MODS_load_module (bool song_flag, const char *filename_0);
signed int	MODS_load_module_direct (const char *filename_0);
signed int	MODS_get_module_file_format (FILE *file_ptr, BYTE temp_info [MODS_TEMP_INFO_LEN]);
signed int	MODS_load_fx_preset (int preset);

signed int	MODS_get_real_sample_path (char *text_0, bool sample_needed_flag);

/*--------------------------------------------------------------------------*/
/*      Tests des entites utilisees                                         */
/*--------------------------------------------------------------------------*/

bool	MODS_pattern_filled (int track_type, int pattern);
bool	MODS_instr_filled (int instr);
bool	MODS_sample_filled (int sample);
bool	MODS_mix_preset_filled (int preset);
bool	MODS_fx_preset_filled (int preset);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern MODS_FORMAT_ROUTINES	MODS_format_routines [];
extern int	MODS_export_format;

extern int	MODS_nbr_backups;

extern const char	MODS_patset_chunk_id [Pattern_NBR_TYPES] [4];
extern const char	MODS_pattern_chunk_id [Pattern_NBR_TYPES] [4];
extern const char	MODS_envelope_chunk_id [Envelope_NBR_TYPES] [4];
extern const char	*MODS_track_type_name_0_ptr [];



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MODS_CURRENT_HEADER
