/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Directory_CURRENT_HEADER)
	#error Inclusion recursive du header Directory.
#endif
#define	Directory_CURRENT_HEADER

#if ! defined (Directory_HEADER_INCLUDED)
#define	Directory_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"file_ct.h"



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Directory
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const int	SORT_MASK;
static const int	SORT_NONE;
static const int	SORT_BY_NAME;
static const int	SORT_BY_EXTENSION;
static const int	SORT_BY_DATE;
static const int	SORT_BY_SIZE;
static const int	SORT_INVERTED;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Directory (void);
~Directory (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	build (const char *dir_path_0, const char *mask_0);
signed int	clear (void);
void		sort (int sort_type);
int		get_length (void) const;
const FILE_DIR_ENTRY	*get_file_info (int position) const;
bool		get_selected_flag (int position) const;
void		set_selected_flag (int position, bool state_flag);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	FILE_ARRAY_GRANULARITY;



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	add_file (const char *dir_path_0, const char *mask_0);
void		sort_by_name (void);
void		sort_by_extension (void);
void		sort_by_date (void);
void		sort_by_size (void);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Nombre de fichiers dans le repertoire */
int		_nbr_files;

/* Tableau des pointeurs sur les descripteurs de fichiers */
FILE_DIR_ENTRY	**_file_info_ptr_ptr;

/* true indique qu'on n'a pas encore essaye de recuperer les infos
   du premier fichier du repertoire. */
bool		_first_file_flag;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Directory (const Directory &other);
void		operator = (const Directory &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Directory_CURRENT_HEADER
