/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Envelope_CURRENT_HEADER)
	#error Inclusion recursive du header Envelope.
#endif
#define	Envelope_CURRENT_HEADER

#if ! defined (Envelope_HEADER_INCLUDED)
#define	Envelope_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Nombre de points max par envelope */
#define	Envelope_MAX_NBR_POINTS		64

/* Types d'enveloppes */
enum
{
	Envelope_TYPE_VOL = 0,			// Volume
	Envelope_TYPE_TON,				// Tonalite
	Envelope_TYPE_PAN,				// Panning
	Envelope_TYPE_CUTOFF,			// Frequence de coupure
	Envelope_TYPE_RESO,				// Resonnance

	Envelope_NBR_TYPES				// Nombre de types d'enveloppes
};

/* Types de boucle */
enum
{
	Envelope_LOOP_NORMAL = 0,
	Envelope_LOOP_SUSTAIN,

	Envelope_NBR_LOOPS
};

/* Valeur speciale du champ Envelope_LOOP.nbr_loops */
#define	Envelope_LOOP_INFINITE	0xFFFF		/* Boucle infinie */

/* Flags des enveloppes */
#define	Envelope_FLAG_FADEOUT	0x0001
#define	Envelope_FLAG_LFO			0x0002
#define	Envelope_FLAG_ENV_LOOP	0x0010
#define	Envelope_FLAG_SUS_LOOP	0x0020

#define	Envelope_MAX_NBR_LOOPS	999			/* Nombre maxi de passages pour une boucle */
#define	Envelope_MAX_LFO_DEPTH	0x7FFF
#define	Envelope_MAX_LFO_SPEED	0x7FFF
#define	Envelope_MAX_LFO_SWEEP	0x7FFF
#define	Envelope_MAX_FADEOUT		0x7FFFL



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	UWORD		time;						// Duree en ticks du point ( > 0)
	SWORD		val;						// Valeur du point
} Envelope_POINT;

typedef struct
{
	SWORD		start;					// Point de debut de boucle
	SWORD		end;						// Point de fin de boucle
	UWORD		nbr_loops;				// Nombre de boucles a faire
} Envelope_LOOP;

typedef struct
{
	const char	*name_0;				// Nom de l'envelope
	bool		hexa_flag;				// La valeur est affichee en hexa
	bool		signed_flag;			// Indique que la donnee de l'envelope peut etre negative
	bool		inverted_flag;			// Indique que la donnee se represente avec un axe des Y qui va du bas vers le haut
	UBYTE		fixed_point;			// En cas de valeur decimale, indique le nombre de chiffres apres la virgule (0 = pas de decimale)
	SWORD		std_val;					// Valeur normale
	SWORD		min_val;					// Valeur minimum
	SWORD		max_val;					// Valeur maximum
} Envelope_CONF;

typedef struct
{
	SLWORD	tick_cnt;				// Nombre de ticks depuis le debut du point
	SWORD		cur_point;				// Numero du point courant (en fait on est entre celui-ci et le suivant)
	SWORD		cur_val;					// Valeur courante de l'enveloppe
	SWORD		val_inc;					// Increment de la valeur a chaque tick
	ULWORD	cur_val_frac;			// Partie fractionnelle de la valeur
	ULWORD	val_inc_frac;			// Increment fractionnel (toujours positif)
	SLWORD	fade_val;				// Valeur courante du volume de fadeout (0...0x10000)
	LWORD		sweep_val;				// Valeur courante de l'amplitude du LFO
	LWORD		sweep_val_frac;		// Valeur courante de l'amplitude du LFO, partie fractionnaire
	LWORD		sweep_inc;				// Increment de sweep_val par tick
	ULWORD	sweep_inc_frac;		// Increment fractionnaire de sweep_val par tick
	UWORD		lfo_pos;					// Position du LFO (0...FFFF)
	SWORD		loop_type;				// Indique si on se trouve dans une boucle (-1 = aucune)
	WORD		loop_cnt [Envelope_NBR_LOOPS];	// Nombre de boucles restantes (si on est dans une boucle)
	SWORD		final_val;				// Valeur finale de l'enveloppe avec fadeout et lfo
	WORD		one_point_sustain_flag;	// Indique qu'on boucle sur un seul point
	WORD		key_off_flag;			// A modifier a l'exterieur: 1 indique qu'on est passe en key off
} Envelope_PROCESS;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Envelope
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
/* Configuration specifique a chaque envelope */
const static Envelope_CONF	CONFIG [Envelope_NBR_TYPES];



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Envelope (int number, int type);
~Envelope (void);
signed int	check_ok (void) const;
void		self_display (void) const;

WORD		get_flags (void) const;
void		set_flags (WORD flags);
int		get_nbr_points (void) const;
void		set_nbr_points (int nbr_points);
Envelope_POINT	get_point (int pos) const;
void		set_point (int pos, const Envelope_POINT &point);
Envelope_LOOP	get_loop (int type) const;
void		set_loop (int type, const Envelope_LOOP &loop);
UWORD		get_lfo_speed (void) const;
void		set_lfo_speed (UWORD val);
UWORD		get_lfo_depth (void) const;
void		set_lfo_depth (UWORD val);
UWORD		get_lfo_sweep (void) const;
void		set_lfo_sweep (UWORD val);
int		get_lfo_waveform (void) const;
void		set_lfo_waveform (int val);
UWORD		get_fadeout (void) const;
void		set_fadeout (UWORD val);

void		start (Envelope_PROCESS &proc);
void		process_tick (Envelope_PROCESS &proc);

signed int	kill_envelope (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	init (void);
void		restore (void);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
UWORD		_number;			// Numero de l'enveloppe (1 a ...)
UWORD		_type;			// Type de l'enveloppe (0 = Vol, 1 = Tone, 2 = Pan)
UWORD		_nbr_points;
UWORD		_lfo_speed;
UWORD		_lfo_depth;
UWORD		_lfo_sweep;
WORD		_lfo_waveform;
UWORD		_fadeout;		// Bit 15: fadeout logarithmique
WORD		_flags;
Envelope_LOOP	_loop [Envelope_NBR_LOOPS];
Envelope_POINT	_point [Envelope_MAX_NBR_POINTS];



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Envelope (void);
Envelope (const Envelope &other);
void		operator = (const Envelope &other);
int		operator == (const Envelope &other) const;
int		operator != (const Envelope &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Envelope_CURRENT_HEADER
