/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (FileSelector_CURRENT_HEADER)
	#error Inclusion recursive du header FileSelector.
#endif
#define	FileSelector_CURRENT_HEADER

#if ! defined (FileSelector_HEADER_INCLUDED)
#define	FileSelector_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Directory.h"
#include	"fnames.h"
#include	"Image.h"
#include	"sliders.h"
#include	"String.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class FileSelector
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const int	BUTTON_NONE;
static const int	BUTTON_OK;
static const int	BUTTON_CANCEL;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
FileSelector (const char *path_in_0, const char *file_in_0, const char *label_0, const char *filter_string_0);
~FileSelector (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	manage (void);
void		redraw (void);
void		refresh (void);
String	get_filename (void) const;
String	get_pathname (void) const;
String	get_mask (void) const;
signed int	get_filter_nbr (const char *mask_0) const;
signed int	get_last_valid_filter_nbr (void) const;
void	set_filter_nbr (int filter_nbr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static FileSelector	*displayed_file_selector_ptr;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	NBR_DISP_FILENAMES;
static const int	FILENAME_DISPLEN;
static const char	*SORT_TYPES_0 [5];


/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
String		complete_path (const char *path_in_0) const;
const char	*get_filter_name_0 (int filter_nbr) const;
bool			get_filter_mask_0 (char *dest_mask_0, int filter_nbr) const;
signed int	refresh_misc (void);
signed int	refresh_window (void);
signed int	refresh_info_bar (void);
signed int	read_directory (const char *path_in_0, const char *mask_0);
void			free_directory (void);
bool			select_files (void);
void			select_one_file (int index);
int			get_selected_file_index (void) const;
void			autoselection (void);
void			select_all (void);
void			deselect_all (void);
signed int	enter_directory (const char *dir_name_0);
signed int	close_directory (void);
signed int	select_drive (void);
signed int	select_filter (void);
void			adapt_fileext_to_filter (void);
String		add_fileext (void) const;



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_nbr_disp_filenames;
char		*_label_0;				/* Titre du formulaire */
char		_current_path_0 [FNAM_PATHNAME_MAXLEN+1];			/* Chemin courant entier */
char		_current_mask_0 [FNAM_FILENAME_MAXLEN+1];			/* Nom du masque courant */
char		_current_filename_0 [FNAM_FILENAME_MAXLEN+1];	/* Nom du fichier courant */
int		_sort_type;				/* Type de tri pour l'affichage du repertoire */
int		_winpos_in_dir;		/* Position de la fenetre d'affichage dans le repertoire courant */
Directory	*_dir_ptr;			/* pointeur sur le repertoire courant */
char		*_filter_string_0;	/* Pointeur sur la chaine des masques */
int		_win_car_width;
int		_win_pix_height;
int		_form_pix_width;		/* Taille du selecteur (sans les ombres) */
int		_form_pix_height;
int		_form_pix_x_pos;		/* Position du selecteur */
int		_form_pix_y_pos;
Image		*_background_ptr;
bool		_display_flag;
SLID_INFO	_slider;
int		_filter_nbr;			/* Dernier filtre valide qui a ete selectionne */



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
FileSelector (void);
FileSelector (const FileSelector &other);
void		operator = (const FileSelector &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FileSelector_CURRENT_HEADER
