/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"EditString.h"
#include	"edstring.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"mpannel.h"
#include	"PatEdMenuToolsMain.h"
#include	"PatternTools.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"ssm_tool.h"
#include	"tracks.h"
#include	"UndoCell.h"
#include	"UndoList.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Formats des masques */
enum
{
	PatEdMenuToolsMain_MASK_FORMAT_NOTE = 0,
	PatEdMenuToolsMain_MASK_FORMAT_HEX
};

const	PatEdMenuToolsMain_MASK_SECTION	PatEdMenuToolsMain::mask_info [4] =
{
	/* Samples */
	{
		RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL, 4,
		{
			{
				PatEdMenuToolsMain_MASK_FORMAT_NOTE, 0, 1,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_TAKE_NOTE,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_RBY_NOTE
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_FILT_NOTE
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 1, 1,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_TAKE_INSTR,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_RBY_INSTR
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_FILT_INSTR
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 2, 2,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_TAKE_FX,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_RBY_FX
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_FILT_FX
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 4, 1,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_TAKE_VOL,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_RBY_VOL
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_FILT_VOL
			}
		}
	},
	
	/* Audio In */
	{
		RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN, 2,
		{
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 0, 2,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_TAKE_FX,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_RBY_FX
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_FILT_FX
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 2, 1,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_TAKE_VOL,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_RBY_VOL
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_AIN_FILT_VOL
			}
		}
	},

	/* Effets */
	{
		RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX, 3,
		{
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 0, 4,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_TAKE_COM,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_RBY_COM
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_FILT_COM
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 4, 2,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_TAKE_FX,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_RBY_FX
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_FILT_FX
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 6, 1,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_TAKE_VOL,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_RBY_VOL
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_FX_FILT_VOL
			}
		}
	},

	/* MIDI */
	{
		RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID, 2,
		{
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 0, 2,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_TAKE_COL1,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_RBY_COL1
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_FILT_COL1
			},
			{
				PatEdMenuToolsMain_MASK_FORMAT_HEX, 2, 2,
				{
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_TAKE_COL2,
					RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_RBY_COL2
				},
				RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_MID_FILT_COL2
			}
		}
	}
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuToolsMain::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuToolsMain::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuToolsMain::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuToolsMain::redraw (void)
{
	int		page;
	int		object;

	/* Pour la page Mask, il y a encore une sous-page a selectionner */
	for (page = 0; page < Pattern_NBR_TYPES; page ++)
	{
		object = mask_info [page].object;
		RSC_set_flag (object, RSC_ATTR_NOTDISP);
	}
	object = mask_info [TRK_preset_data [TRK_preset_nbr].track_type].object;
	RSC_clear_flag (object, RSC_ATTR_NOTDISP);

	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuToolsMain::refresh (void)
{
	int		track_type;
	int		section;
	int		mask;
	int		count;
	int		pos;
	int		len;
	char		text_0 [8+1];
	PatternTools_BLOCK_INFO	selection;

/*______________________________________________
 *
 * Outils
 *______________________________________________
 */

	/* Si le clipboard est vide, on invalide les boutons coller/inserer */
	if (GTK_pattern_block_ptr->get_full_clipboard_flag ())
	{
		RSC_clear_flag (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_PASTE,
		                RSC_ATTR_DISABLE | RSC_ATTR_NOCLICK);
		RSC_clear_flag (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_INS,
		                RSC_ATTR_DISABLE | RSC_ATTR_NOCLICK);
	}
	else
	{
		RSC_set_flag (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_PASTE,
		              RSC_ATTR_DISABLE | RSC_ATTR_NOCLICK);
		RSC_set_flag (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_INS,
		              RSC_ATTR_DISABLE | RSC_ATTR_NOCLICK);
	}
	RSC_display_object (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_PASTE);
	RSC_display_object (RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_INS);

	/* Scope */
	switch (GTK_pattern_block_ptr->get_scope ())
	{
	case	PatternTools_SCOPE_TRACK:
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRACK,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRACK);
		break;
	case	PatternTools_SCOPE_PATTERN:
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_PAT,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRACK);
		break;
	case	PatternTools_SCOPE_PRESET:
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_PRESET,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRACK);
		break;
	}

	/* Tracks On */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRKON,
	                           GTK_pattern_block_ptr->get_tracks_on_flag ());

	/* All Track Types */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_ATPAT,
	                           GTK_pattern_block_ptr->get_all_track_type_flag ());

	/* Whole song */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_WSNG,
	                           GTK_pattern_block_ptr->get_song_flag ());

/*______________________________________________
 *
 * Masques
 *______________________________________________
 */

	selection = GTK_pattern_block_ptr->get_current_selection ();
	track_type = TRK_preset_data [TRK_preset_nbr].track_type;
	for (section = 0; section < mask_info [track_type].nbr_sections; section ++)
	{
		len = mask_info [track_type].section [section].len;
		pos = mask_info [track_type].section [section].pos;

		/* Masques */
		for (mask = 0; mask < 2; mask ++)
		{
			switch (mask_info [track_type].section [section].type)
			{
			/* Note */
			case	PatEdMenuToolsMain_MASK_FORMAT_NOTE:
				if (selection.mask_flag [mask] [track_type] [pos] != 0)
				{
					RSC_set_string (mask_info [track_type].section [section].mask_object [mask],
					                " \? ");
				}
				else
				{
					RSC_set_string (mask_info [track_type].section [section].mask_object [mask],
					                INTR_note_names [selection.mask_value [mask] [track_type] [pos]]);
				}
				break;
				
			/* Chiffre hexa */
			case	PatEdMenuToolsMain_MASK_FORMAT_HEX:
				for (count = 0; count < len * 2; count ++)
				{
					if (BASE_get_quartet (selection.mask_flag [mask] [track_type] [pos + count / 2],
					                      (count & 1) ^ 1) != 0)
					{
						text_0 [count] = '\?';
					}
					else
					{
						text_0 [count] = BASE_digit_to_char
						                    (BASE_get_quartet
						                       (selection.mask_value [mask]
						                                             [track_type]
						                                             [pos + count / 2],
						                        (count & 1) ^ 1));
					}
					text_0 [len * 2] = '\0';
					RSC_set_string (mask_info [track_type].section [section].mask_object [mask],
					                text_0);
				}
				break;
			}
			RSC_display_object (mask_info [track_type].section [section].mask_object [mask]);
		}

		/* Filtre */
		RSC_select_object_display (mask_info [track_type].section [section].filter_object,
		                           GTK_pattern_block_ptr->get_filter_flag (track_type, pos, len));
	}

	/* Note extension */
	if (TRK_preset_data [TRK_preset_nbr].track_type == Pattern_TYPE_SPL)
	{

		/*** A faire ***/

	}

	/* Utilisation du masque */
	if (GTK_pattern_block_ptr->get_use_mask_flag ())
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_USEM,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_ALL);
	}
	else
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_ALL,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_ALL);
	}

	/* Transparence */
	if (GTK_pattern_block_ptr->get_transp_flag ())
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_TRANS,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_REPL);
	}
	else
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_REPL,
													RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_REPL);
	}

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuToolsMain::refresh_dynamic (bool force_flag)
{
	/* Rien en fait */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuToolsMain::manage (int sel_object, int sel_elder)
{
	int		track_type;
	int		section;
	int		mask;
	int		pos;
	int		len;
	int		count;
	int		val;
	char		text_0 [8+1];
	bool		mask_flag;
	PatternTools_BLOCK_INFO	selection;
	UndoCell	*undo_ptr;

	switch (sel_object)
	{
	/* Start */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BLOCK_START:
		SSMTOOL_set_block_start ();
		break;

	/* End */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BLOCK_END:
		SSMTOOL_set_block_end ();
		break;

	/* Paste selection */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_ACTION_PASTE:
		INTR_graph_ptr->mouse_bee ();
		GTK_pattern_block_ptr->paste_selection (GTK_get_current_pattern_number (),
		                                        GTK_get_line_position (),
		                                        TRK_preset_data [TRK_preset_nbr].track_type,
		                                        TRK_preset_data [TRK_preset_nbr].track_nbr [TRK_cursor_col + TRK_cursor_offset],
		                                        &undo_ptr);
		GTK_undo_list_ptr->add_action (*undo_ptr, "Paste selection");
		delete undo_ptr;
		INTR_graph_ptr->mouse_arrow ();
		INTR_pattern_editor_track_ptr->refresh_dynamic (true);
		MPAN_display_message ("Selection pasted.");
		break;

	/* Insert selection */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_ACTION_INS:
		INTR_graph_ptr->mouse_bee ();
		GTK_pattern_block_ptr->insert_selection (GTK_get_current_pattern_number (),
		                                         GTK_get_line_position (),
		                                         TRK_preset_data [TRK_preset_nbr].track_type,
		                                         TRK_preset_data [TRK_preset_nbr].track_nbr [TRK_cursor_col + TRK_cursor_offset],
		                                         &undo_ptr);
		GTK_undo_list_ptr->add_action (*undo_ptr, "Insert selection");
		delete undo_ptr;
		INTR_graph_ptr->mouse_arrow ();
		INTR_pattern_editor_track_ptr->refresh_dynamic (true);
		MPAN_display_message ("Selection inserted.");
		break;

	/*  */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_ACTION_SWAP:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/* Clear selection */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_ACTION_CLEAR:
		INTR_graph_ptr->mouse_bee ();
		GTK_pattern_block_ptr->clear_selection (TRK_preset_data [TRK_preset_nbr].track_type,
		                                        &undo_ptr);
		GTK_undo_list_ptr->add_action (*undo_ptr, "Clear selection");
		delete undo_ptr;
		INTR_graph_ptr->mouse_arrow ();
		INTR_pattern_editor_track_ptr->refresh_dynamic (true);
		MPAN_display_message ("Selection cleared.");
		break;

	/* Delete selection */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_ACTION_DEL:
		INTR_graph_ptr->mouse_bee ();
		GTK_pattern_block_ptr->delete_selection (TRK_preset_data [TRK_preset_nbr].track_type,
		                                         &undo_ptr);
		GTK_undo_list_ptr->add_action (*undo_ptr, "Delete selection");
		delete undo_ptr;
		INTR_graph_ptr->mouse_arrow ();
		INTR_pattern_editor_track_ptr->refresh_dynamic (true);
		MPAN_display_message ("Selection deleted.");
		break;

	/*  */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_CUT:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/*  */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_COPY:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/*  */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_PASTE:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/*  */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_BUFFER_INS:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/* Track */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRACK:
		GTK_pattern_block_ptr->set_scope (PatternTools_SCOPE_TRACK);
		refresh ();
		break;

	/* Pattern */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_PAT:
		GTK_pattern_block_ptr->set_scope (PatternTools_SCOPE_PATTERN);
		refresh ();
		break;

	/* Preset */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_PRESET:
		GTK_pattern_block_ptr->set_scope (PatternTools_SCOPE_PRESET);
		refresh ();
		break;

	/* Tracks On only */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_TRKON:
		GTK_pattern_block_ptr->set_tracks_on_flag (! GTK_pattern_block_ptr->get_tracks_on_flag ());
		refresh ();
		break;

	/* All track types */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_ATPAT:
		GTK_pattern_block_ptr->set_all_track_type_flag (! GTK_pattern_block_ptr->get_all_track_type_flag ());
		refresh ();
		break;

	/* Whole song */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_RANGE_WSNG:
		GTK_pattern_block_ptr->set_song_flag (! GTK_pattern_block_ptr->get_song_flag ());
		refresh ();
		break;

	/* Note extension */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_MASK_SPL_NEXT:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);





		/*** A faire ***/




		break;

	/* All */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_ALL:
		GTK_pattern_block_ptr->set_use_mask_flag (false);
		refresh ();
		break;

	/* Use mask */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_MENABLE_USEM:
		GTK_pattern_block_ptr->set_use_mask_flag (true);
		refresh ();
		break;

	/* Replace */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_REPL:
		GTK_pattern_block_ptr->set_transp_flag (false);
		refresh ();
		break;

	/* Transparency */
	case	RSC_OBJ_MP_SUBM_TOOLS_MAIN_TRANS_TRANS:
		GTK_pattern_block_ptr->set_transp_flag (true);
		refresh ();
		break;

	default:
		selection = GTK_pattern_block_ptr->get_current_selection ();
		track_type = TRK_preset_data [TRK_preset_nbr].track_type;
		for (section = 0; section < mask_info [track_type].nbr_sections; section ++)
		{
			len = mask_info [track_type].section [section].len;
			pos = mask_info [track_type].section [section].pos;

			/* Filtre */
			if (sel_object == mask_info [track_type].section [section].filter_object)
			{
				GTK_pattern_block_ptr->set_filter_flag (track_type, pos, len,
				                                        ! GTK_pattern_block_ptr->get_filter_flag (track_type, pos, len));
				GTK_pattern_block_ptr->set_use_mask_flag (true);
				refresh ();
				break;
			}

			/* Masques */
			else
			{
				for (mask = 0; mask < 2; mask ++)
				{
					if (sel_object == mask_info [track_type].section [section].mask_object [mask])
					{
						strcpy (text_0, RSC_get_string (sel_object));
						switch (mask_info [track_type].section [section].type)
						{
						/* Note */
						case	PatEdMenuToolsMain_MASK_FORMAT_NOTE:
							EDIT_edit_string (text_0, sel_object, 3, EditString_TYPE_ALPHA);
							if (strchr (text_0, '\?') != NULL)
							{
								GTK_pattern_block_ptr->set_mask_flag (track_type, pos, 1, 2, mask, true);
							}
							else
							{
								GTK_pattern_block_ptr->set_mask_flag (track_type, pos, 1, 2, mask, false);
								text_0 [0] = toupper (text_0 [0]);
								val = Sample_REF_C2;
								for (count = 0; count < GTK_NBRNOTES_MAXI; count ++)
								{
									if (strcmp (text_0, INTR_note_names [count]) == 0)
									{
										val = count;
										break;
									}
								}
								GTK_pattern_block_ptr->set_mask_value (track_type, pos, 0, mask, val & 0x0F);
								GTK_pattern_block_ptr->set_mask_value (track_type, pos, 1, mask, val >> 4);
							}
							break;

						/* Chiffre hexa */
						case	PatEdMenuToolsMain_MASK_FORMAT_HEX:
							EDIT_edit_string (text_0, sel_object, len * 2, EditString_TYPE_ALPHA);
							for (count = 0; count < len * 2; count ++)
							{
								mask_flag = true;
								val = toupper (text_0 [count]);
								if (val >= '0' && val <= '9')
								{
									mask_flag = false;
									GTK_pattern_block_ptr->set_mask_value (track_type, pos + count / 2,
									                                       (count & 1) ^ 1, mask, val - '0');
								}
								else if (val >= 'A' && val <= 'F')
								{
									mask_flag = false;
									GTK_pattern_block_ptr->set_mask_value (track_type, pos + count / 2,
									                                       (count & 1) ^ 1, mask, val - 'A' + 10);
								}
								GTK_pattern_block_ptr->set_mask_flag (track_type, pos + count / 2,
								                                      (count & 1) ^ 1, 1, mask, mask_flag);
							}
							break;
						}

						GTK_pattern_block_ptr->set_use_mask_flag (true);
						refresh ();
					}
				}
			}
		}
		break;
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuToolsMain::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_MAIN, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_PICN_MAIN, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
