/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"log.h"
#include	"PatEdMenus.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PatEdMenus::PatEdMenus (void)
{
	set_submenu (PatEdMenus_FILES);
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenus::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenus::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenus::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenus::redraw (void)
{
	switch (_submenu)
	{
	case	PatEdMenus_FILES:
		_files.redraw ();
		break;
	case	PatEdMenus_TOOLS:
		_tools.redraw ();
		break;
	case	PatEdMenus_INSTR:
		_instruments.redraw ();
		break;
	case	PatEdMenus_SPL:
		_samples.redraw ();
		break;
	case	PatEdMenus_ENV:
		_envelopes.redraw ();
		break;
	case	PatEdMenus_MIX:
		_mix.redraw ();
		break;
	case	PatEdMenus_FX:
		_effects.redraw ();
		break;
	case	PatEdMenus_MIDI:
		_midi.redraw ();
		break;
	case	PatEdMenus_PREF:
		_pref.redraw ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenus::refresh (void)
{
	switch (_submenu)
	{
	case	PatEdMenus_FILES:
		_files.refresh ();
		break;
	case	PatEdMenus_TOOLS:
		_tools.refresh ();
		break;
	case	PatEdMenus_INSTR:
		_instruments.refresh ();
		break;
	case	PatEdMenus_SPL:
		_samples.refresh ();
		break;
	case	PatEdMenus_ENV:
		_envelopes.refresh ();
		break;
	case	PatEdMenus_MIX:
		_mix.refresh ();
		break;
	case	PatEdMenus_FX:
		_effects.refresh ();
		break;
	case	PatEdMenus_MIDI:
		_midi.refresh ();
		break;
	case	PatEdMenus_PREF:
		_pref.refresh ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenus::refresh_dynamic (bool force_flag)
{
	switch (_submenu)
	{
	case	PatEdMenus_FILES:
		_files.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_TOOLS:
		_tools.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_INSTR:
		_instruments.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_SPL:
		_samples.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_ENV:
		_envelopes.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_MIX:
		_mix.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_FX:
		_effects.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_MIDI:
		_midi.refresh_dynamic (force_flag);
		break;
	case	PatEdMenus_PREF:
		_pref.refresh_dynamic (force_flag);
		break;
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenus::manage (int sel_object, int sel_elder)
{
	switch (_submenu)
	{
	case	PatEdMenus_FILES:
		_files.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_TOOLS:
		_tools.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_INSTR:
		_instruments.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_SPL:
		_samples.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_ENV:
		_envelopes.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_MIX:
		_mix.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_FX:
		_effects.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_MIDI:
		_midi.manage (sel_object, sel_elder);
		break;
	case	PatEdMenus_PREF:
		_pref.manage (sel_object, sel_elder);
		break;
	}
}



int	PatEdMenus::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_MP_SUBM));
}



int	PatEdMenus::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_MP_SUBM));
}



void	PatEdMenus::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_MP_SUBM];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_MP_SUBM];
}



void	PatEdMenus::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_MP_SUBM, pix_x, pix_y);
}



int	PatEdMenus::get_submenu (void) const
{
	return (_submenu);
}



void	PatEdMenus::set_submenu (int submenu)
{
	int		menu_cnt;
	bool		activate_flag;

	_submenu = submenu;

	/* Activation des menus */
	for (menu_cnt = 0; menu_cnt < PatEdMenus_NBR_MENUS; menu_cnt ++)
	{
		activate_flag = (menu_cnt == _submenu);

		switch (menu_cnt)
		{
		case	PatEdMenus_FILES:
			_files.activate (activate_flag);
			break;
		case	PatEdMenus_TOOLS:
			_tools.activate (activate_flag);
			break;
		case	PatEdMenus_INSTR:
			_instruments.activate (activate_flag);
			break;
		case	PatEdMenus_SPL:
			_samples.activate (activate_flag);
			break;
		case	PatEdMenus_ENV:
			_envelopes.activate (activate_flag);
			break;
		case	PatEdMenus_MIX:
			_mix.activate (activate_flag);
			break;
		case	PatEdMenus_FX:
			_effects.activate (activate_flag);
			break;
		case	PatEdMenus_MIDI:
			_midi.activate (activate_flag);
			break;
		case	PatEdMenus_PREF:
			_pref.activate (activate_flag);
			break;
		}
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
