/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"log.h"
#include	"PatSelection.h"
#include	"patt.h"
#include	"tracks.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PatSelection::PatSelection (int pattern, int preset, int left_col, int start_line, int nbr_col, int nbr_lines)
{
	_pattern = pattern;
	_preset = preset;
	_left_col = left_col;
	_nbr_col = nbr_col;
	_start_line = start_line;
	_nbr_lines = nbr_lines;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

PatSelection::~PatSelection (void)
{
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatSelection::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatSelection::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatSelection::self_display (void) const
{

	/*** A faire ***/

}



void	PatSelection::check (void)
{
	int	height;
	int	nbr_col;

	height = PAT_get_pattern_height (_pattern);
	_start_line = MIN (_start_line, height - 1);
	_nbr_lines = MIN (_nbr_lines, height - _start_line);

	nbr_col = TRK_preset_data [_preset].nbr;
	_left_col = MIN (_left_col, nbr_col - 1);
	_nbr_col = MIN (_nbr_col, nbr_col - _left_col);
}



int	PatSelection::get_nbr_col (void) const
{
	return (_nbr_col);
}



int	PatSelection::get_nbr_lines (void) const
{
	return (_nbr_lines);
}



int	PatSelection::get_pattern (void) const
{
	return (_pattern);
}



int	PatSelection::get_track_type (void) const
{
	return (TRK_preset_data [_preset].track_type);
}



int	PatSelection::get_preset (void) const
{
	return (_preset);
}



int	PatSelection::get_left_col (void) const
{
	return (_left_col);
}



int	PatSelection::get_start_line (void) const
{
	return (_start_line);
}



int	PatSelection::get_track (int col) const
{
	return (TRK_preset_data [_preset].track_nbr [col + _left_col]);
}



void	*PatSelection::get_note_ptr (int col, int line) const
{
	return (PAT_get_note_adr_pat (TRK_preset_data [_preset].track_type,
	                              _pattern, line + _start_line,
	                              TRK_preset_data [_preset].track_nbr [col + _left_col]));
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
