/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"base.h"
#include	"base_ct.h"
#include	"log.h"
#include	"String.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

String::String (void)
{
	_text_0 = new char [1];
	if (_text_0 == NULL)
	{
		LOG_printf ("String::String: Error: couldn't allocate memory for string data.\n");
	}
	_text_0 [0] = '\0';
}



String::String (const String &other)
{
	_text_0 = new char [other.get_len () + 1];
	if (_text_0 == NULL)
	{
		LOG_printf ("String::String: Error: couldn't allocate memory for string data.\n");
	}
	strcpy (_text_0, other._text_0);
}



String::String (const char *text_0)
{
	_text_0 = new char [strlen (text_0) + 1];
	if (_text_0 == NULL)
	{
		LOG_printf ("String::String: Error: couldn't allocate memory for string data.\n");
	}
	strcpy (_text_0, text_0);
}



String::String (long length, char fill)
{
	_text_0 = NULL;

	if (length < 0)
	{
		LOG_printf ("String::String: Error: length can't be negative (%ld).\n", length);
		return;
	}

	_text_0 = new char [length + 1];
	if (_text_0 == NULL)
	{
		LOG_printf ("String::String: Error: couldn't allocate memory for string data.\n");
	}

	memset (_text_0, fill, length);
	_text_0 [length] = '\0';
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

String::~String (void)
{
	if (_text_0 != NULL)
	{
		delete [] _text_0;
		_text_0 = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	String::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("String::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_text_0 == NULL)
	{
		LOG_printf ("String::check_ok: Error: _text_0 is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	String::self_display (void) const
{

	/*** A faire ***/

}



String::operator char * (void) const
{
	return (_text_0);
}



String	&String::operator = (const String &other)
{
	if (&other == this)
	{
		return (*this);
	}

	if (_text_0 != NULL)
	{
		delete [] _text_0;
	}

	_text_0 = new char [other.get_len () + 1];
	if (_text_0 == NULL)
	{
		LOG_printf ("String::operator =: Error: couldn't allocate memory for string data.\n");
	}
	strcpy (_text_0, other._text_0);

	return (*this);
}


int	String::operator == (const String &other) const
{
	return (strcmp (_text_0, other) == 0);
}



int	String::operator != (const String &other) const
{
	return (! (*this == other));
}



String	String::operator + (const char *other_0) const
{
	return (String (*this) += other_0);
}



String	&String::operator += (const char *other_0)
{
	char		*temp_0;

	temp_0 = new char [strlen (_text_0) + strlen (other_0) + 1];
	if (temp_0 == NULL)
	{
		LOG_printf ("String::operator =: Error: couldn't allocate memory for string data.\n");
		return (*this);
	}
	strcpy (temp_0, _text_0);
	delete [] _text_0;
	_text_0 = temp_0;
	strcat (_text_0, other_0);

	return (*this);
}



String	String::trim (void) const
{
	char		*temp_0;
	long	length;

	/* Cherche le debut */
	temp_0 = _text_0;
	while (   *temp_0 != '\0'
	       && (   *temp_0 == ' '
	           || *temp_0 == '\t'
	           || *temp_0 == '\v'
	           || *temp_0 == '\n'))
	{
		temp_0 ++;
	}

	/* Cherche la fin */
	length = strlen (temp_0) - 1;
	while (   length >= 0
	       && (   temp_0 [length] == ' '
	           || temp_0 [length] == '\t'
	           || temp_0 [length] == '\v'
	           || temp_0 [length] == '\n'))
	{
		length --;
	}
	length ++;

	/* Recopie les donnees utiles */
	String	new_str (length);
	memcpy (new_str._text_0, temp_0, length);
	new_str._text_0 [length] = '\0';

	return (new_str);
}



String	String::mid (long start, long length) const
{
	long		real_len;

	real_len = strlen (_text_0) - start;
	real_len = MIN (real_len, length);
	real_len = MAX (real_len, 0);
	String	new_str (real_len);
	if (real_len > 0)
	{
		memcpy (new_str._text_0, _text_0 + start, real_len);
	}
	new_str._text_0 [real_len] = '\0';

	return (new_str);
}



String	String::left (long length) const
{
	long		real_len;

	real_len = strlen (_text_0);
	real_len = MIN (real_len, length);
	String	new_str (real_len);
	if (real_len > 0)
	{
		memcpy (new_str._text_0, _text_0, real_len);
	}
	new_str._text_0 [real_len] = '\0';

	return (new_str);
}



String	String::right (long length) const
{
	long		org_str_len;
	long		real_len;

	org_str_len = strlen (_text_0);
	real_len = MIN (org_str_len, length);
	real_len = MAX (real_len, 0);
	String	new_str (real_len);
	if (real_len > 0)
	{
		memcpy (new_str._text_0, _text_0 + org_str_len - real_len, real_len);
	}
	new_str._text_0 [real_len] = '\0';

	return (new_str);
}



String	String::after (long pos) const
{
	long		org_str_len;

	org_str_len = strlen (_text_0);
	pos ++;
	pos = MIN (pos, org_str_len);
	pos = MAX (pos, 0);

	return (String (_text_0 + pos));
}



long	String::find (char c) const
{
	const char	*dummy_0;

	dummy_0 = strchr (_text_0, c);
	if (dummy_0 == NULL)
	{
		return (-1);
	}

	return (dummy_0 - _text_0);
}



long	String::rfind (char c) const
{
	const char	*dummy_0;

	dummy_0 = strrchr (_text_0, c);
	if (dummy_0 == NULL)
	{
		return (-1);
	}

	return (dummy_0 - _text_0);
}



long	String::get_len (void) const
{
	return (strlen (_text_0));
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
