/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"List.h"
#include	"log.h"
#include	"String.h"
#include	"UndoCell.h"
#include	"UndoList.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoList::UndoList (void)
{
	_undo_count = 0;
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoList::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoList::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoList::self_display (void) const
{

	/*** A faire ***/

}



void	UndoList::reset (void)
{
	clear_undo_list ();
	clear_redo_list ();
}



void	UndoList::clear_undo_list (void)
{
	_undo_list.clear ();
	_undo_count = 0;
}



void	UndoList::clear_redo_list (void)
{
	_redo_list.clear ();
}



void	UndoList::add_action (const UndoCell &cell, String name)
{
	UndoList_Elt	undo_elt;

	clear_redo_list ();

	undo_elt.action_ptr = (UndoCell *) cell.clone ();
	undo_elt.name = name;
	_undo_list.add (&undo_elt);
	
	_undo_count ++;
	if (_undo_count > UndoList_MAX_NBR_ACTIONS)
	{
		_undo_list.del (_undo_list.length () - 1);
		_undo_count --;
	}
}



long	UndoList::get_undo_count (void) const
{
	return (_undo_count);
}



String	UndoList::undo_action (void)
{
	String		name;
	UndoList_Elt	*undo_elt_ptr;

	if (_undo_list.is_empty ())
	{
		_undo_count = 0;		// Par securite
		return ("Nothing");
	}

	undo_elt_ptr = (UndoList_Elt *) (_undo_list.get (0));
	name = undo_elt_ptr->name;
	undo_elt_ptr->action_ptr->apply_undo ();
	_redo_list.add (undo_elt_ptr);
	_undo_list.del ();
	_undo_count --;

	return (name);
}



String	UndoList::redo_action (void)
{
	String		name;
	UndoList_Elt	*redo_elt_ptr;

	if (_redo_list.is_empty ())
	{
		return ("Nothing");
	}

	redo_elt_ptr = (UndoList_Elt *) (_redo_list.get (0));
	name = redo_elt_ptr->name;
	redo_elt_ptr->action_ptr->apply_redo ();
	_undo_list.add (redo_elt_ptr);
	_redo_list.del ();
	_undo_count ++;

	return (name);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
