/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (UndoList_CURRENT_HEADER)
	#error Inclusion recursive du header UndoList.
#endif
#define	UndoList_CURRENT_HEADER

#if ! defined (UndoList_HEADER_INCLUDED)
#define	UndoList_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"List.h"
#include	"String.h"
#include	"UndoCell.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Nombre maximum d'actions enregistrables en memoire */
#define	UndoList_MAX_NBR_ACTIONS		500



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class UndoList
{



private:

/* Dans la liste, on stoque l'action et son nom. */

class UndoList_Elt
: public Container
{
public:
	UndoCell	*action_ptr;
	String	name;

	UndoList_Elt (void) { action_ptr = NULL; }
	UndoList_Elt (const UndoList_Elt &other) : name (other.name) { action_ptr = (UndoCell *) other.action_ptr->clone (); }
	~UndoList_Elt (void) { if (action_ptr != NULL) delete action_ptr; }
	signed int	check_ok (void) const { return (0); }
	void	self_display (void) const { }
	Container	*create (void) const { return (new UndoList_Elt ()); }
	Container	*clone (void) const { return (new UndoList_Elt (*this)); }
};



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
UndoList (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		reset (void);
void		clear_undo_list (void);
void		clear_redo_list (void);
void		add_action (const UndoCell &cell, String name);
long		get_undo_count (void) const;
String	undo_action (void);
String	redo_action (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
List		_undo_list;
List		_redo_list;
long		_undo_count;	// Nombre d'actions en memoire



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
UndoList (const UndoList &other);
void		operator = (const UndoList &other);
int		operator == (const UndoList &other) const;
int		operator != (const UndoList &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef UndoList_CURRENT_HEADER
