;/*****************************************************************************
;
;GRAOUMF TRACKER 2
;
;Copyright (c) 1996 - 2002 Laurent de Soras
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
;Contact the author : laurent@ohmforce.com
;More information about this license : http://www.gnu.org/licenses/gpl.html
;
;*****************************************************************************/



%include	"macros.asm"



				SECTION	CODE PUBLIC USE32



;============================================================================;
;       Nom: MIX_mix_track                                                   ;
;       Description: Mixe un buffer 24 bits sur un autre, avec modification  ;
;                    du volume. La stereo de chaque buffer est prise en      ;
;                    compte, ainsi que le mix/ecrasement. Les overflows ne   ;
;                    sont pas controles.                                     ;
;============================================================================;

				proc		MIX_mix_track

%$s_buffer_ptr:	arg
%$d_buffer_ptr:	arg
%$d_length:			arg
%$s_stereo:			arg
%$d_stereo:			arg
%$left_volume:		arg
%$right_volume:	arg
%$erase_flag:		arg

				mov		ecx, dword [ebp + %$d_length]			; ecx = nombre de samples a traiter
				cmp		ecx, 0										; Verifie que la longueur destination soit > 0
				jg			.suite1
				jmp		mix24__end
.suite1:
				mov		esi, dword [ebp + %$s_buffer_ptr]	; esi = pointeur sur sample source
				mov		edi, dword [ebp + %$d_buffer_ptr]	; edi = pointeur sur sample destination
				mov		ebx, dword [ebp + %$left_volume]		; ebx = volume gauche sur 16 bits

				cmp		dword [ebp + %$s_stereo], 2
				jne		mix24__s_mono
				jmp		mix24__s_stereo



mix24__s_mono:
				cmp		dword [ebp + %$d_stereo], 2
				je			mix24__s_mono__d_stereo



;_______________________________________________
;
; Source mono, destination mono
;_______________________________________________
;

mix24__s_mono__d_mono:
				add		ebx, dword [ebp + %$right_volume]	; ebx = volume des deux voies sur 16 bits

				cmp		dword [ebp + %$erase_flag], 0
				jne		mix24__s_mono__d_mono__erase

;--- Mixage ------------------------------------------------------------------

mix24__s_mono__d_mono__mix:
.boucle:
				mov		eax, dword [esi]				; eax = sample a mixer
				imul		ebx								; multiplie par le volume -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



;--- Ecrasement --------------------------------------------------------------

mix24__s_mono__d_mono__erase:
.boucle:
				mov		eax, dword [esi]				; eax = sample a mixer
				imul		ebx								; multiplie par le volume -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample dans le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



;_______________________________________________
;
; Source mono, destination stereo
;_______________________________________________
;

mix24__s_mono__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		mix24__s_mono__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

mix24__s_mono__d_stereo__mix:
.boucle:
				mov		eax, dword [esi]				; eax = sample a mixer
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				mov		eax, dword [esi]				; eax = sample a mixer
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



;--- Ecrasement --------------------------------------------------------------

mix24__s_mono__d_stereo__erase:
.boucle:
				mov		eax, dword [esi]				; eax = sample a mixer
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample gauche dans le buffer
				add		edi, 4							; sample destination suivant

				mov		eax, dword [esi]				; eax = sample a mixer
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample droit dans le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



mix24__s_stereo:
				cmp		dword [ebp + %$d_stereo], 2
				jne		mix24__s_stereo__d_mono
				jmp		mix24__s_stereo__d_stereo



;_______________________________________________
;
; Source stereo, destination mono
;_______________________________________________
;

mix24__s_stereo__d_mono:
				cmp		dword [ebp + %$erase_flag], 0
				jne		mix24__s_stereo__d_mono__erase

;--- Mixage ------------------------------------------------------------------

mix24__s_stereo__d_mono__mix:
.boucle:
				mov		eax, dword [esi]				; eax = sample gauche
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer

				mov		eax, dword [esi]				; eax = sample droit
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



;--- Ecrasement --------------------------------------------------------------

mix24__s_stereo__d_mono__erase:
.boucle:
				mov		eax, dword [esi]				; eax = sample gauche
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample gauche dans le buffer

				mov		eax, dword [esi]				; eax = sample droit
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample droit avec le sample gauche deja dans le buffer
				add		edi, 4							; sample destination suivant

				jmp		mix24__end



;_______________________________________________
;
; Source stereo, destination stereo
;_______________________________________________
;

mix24__s_stereo__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		mix24__s_stereo__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

mix24__s_stereo__d_stereo__mix:
.boucle:
				mov		eax, dword [esi]				; eax = sample gauche
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				mov		eax, dword [esi]				; eax = sample droit
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				add		dword [edi], eax				; Mixe le sample avec le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		mix24__end



;--- Ecrasement --------------------------------------------------------------

mix24__s_stereo__d_stereo__erase:
.boucle:
				mov		eax, dword [esi]				; eax = sample gauche
				imul		ebx								; multiplie par le volume gauche -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample gauche dans le buffer
				add		edi, 4							; sample destination suivant

				mov		eax, dword [esi]				; eax = sample droit
				imul		dword [ebp + %$right_volume]	; multiplie par le volume droit -> edx:eax sur 64 bits base 40
				add		esi, 4							; sample source suivant
				shrd		eax, edx, 16					; Remet notre sample en 32 bits base 24
				mov		dword [edi], eax				; Place le sample droit dans le buffer
				add		edi, 4							; sample destination suivant

				dec      ecx								; Decremente le nombre de samples a traiter
				jnz      .boucle



mix24__end:
				endproc





;============================================================================;
;       Nom: MIX_resample_16f_and_mix_track                                  ;
;       Description: Resampling et mixage vers l'avant d'un buffer 16 bits   ;
;                    dans un buffer 24 bits.                                 ;
;============================================================================;

				proc		MIX_resample_16f_and_mix_track

%$s_buffer_ptr:	arg
%$d_buffer_ptr:	arg
%$d_length:			arg
%$s_stereo:			arg
%$d_stereo:			arg
%$left_volume:		arg
%$right_volume:	arg
%$erase_flag:		arg
%$pos_frac:			arg
%$freq_int:			arg
%$freq_frac:		arg

				cmp		dword [ebp + %$d_length], 0	; Verifie que la longueur destination soit > 0
				jg			.suite1
				jmp		r16famt__end
.suite1:
				sar		dword [ebp + %$left_volume], 4		; Volume gauche sur 12 bits
				sar		dword [ebp + %$right_volume], 4		; Volume droit sur 12 bits
				mov		esi, dword [ebp + %$s_buffer_ptr]	; esi = pointeur sur sample source
				mov		edi, dword [ebp + %$d_buffer_ptr]	; edi = pointeur sur sample destination
				mov		edx, dword [ebp + %$pos_frac]			; edx = position fractionnaire dans le sample source

				cmp		dword [ebp + %$s_stereo], 2
				jne		r16famt__s_mono
				jmp		r16famt__s_stereo



r16famt__s_mono:
				sal		dword [ebp + %$freq_int], 1
				cmp		dword [ebp + %$d_stereo], 2
				je			r16famt__s_mono__d_stereo



;_______________________________________________
;
; Source mono, destination mono
;_______________________________________________
;

r16famt__s_mono__d_mono:
				mov		eax, dword [ebp + %$left_volume]
				add		eax, dword [ebp + %$right_volume]	; eax = volume des deux voies sur 12 bits

				cmp		dword [ebp + %$erase_flag], 0
				jne		r16famt__s_mono__d_mono__erase

;--- Mixage ------------------------------------------------------------------

r16famt__s_mono__d_mono__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				imul     ecx, eax							; Multiplie par le volume
				sar      ecx, 4							; ecx = sample avec volume sur 24 bits
				add		dword [edi], ecx				; Mixe le sample avec la memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;--- Ecrasement --------------------------------------------------------------

r16famt__s_mono__d_mono__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				imul     ecx, eax							; Multiplie par le volume
				sar      ecx, 4							; ecx = sample avec volume
				mov		dword [edi], ecx				; Stoque le sample en memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;_______________________________________________
;
; Source mono, destination stereo
;_______________________________________________
;

r16famt__s_mono__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16famt__s_mono__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

r16famt__s_mono__d_stereo__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				mov		eax, ecx
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				add		dword [edi], ecx				; Mixe le sample gauche avec la memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				add		dword [edi], eax				; Mixe le sample droit avec la memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;--- Ecrasement --------------------------------------------------------------

r16famt__s_mono__d_stereo__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				mov		eax, ecx
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				mov		dword [edi], ecx				; Place le sample gauche en memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				mov		dword [edi], eax				; Place le sample droit en memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



r16famt__s_stereo:
				sal		dword [ebp + %$freq_int], 2
				cmp		dword [ebp + %$d_stereo], 2
				jne		r16famt__s_stereo__d_mono
				jmp		r16famt__s_stereo__d_stereo



;_______________________________________________
;
; Source stereo, destination mono
;_______________________________________________
;

r16famt__s_stereo__d_mono:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16famt__s_stereo__d_mono__erase

;--- Mixage ------------------------------------------------------------------

r16famt__s_stereo__d_mono__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				movsx    eax, word [esi + 2]			; eax = sample source droit
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		eax, ecx							; Mixe les deux samples
				sar      eax, 4							; eax = sample avec volume
				add		dword [edi], eax				; Mixe le sample avec la memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;--- Ecrasement --------------------------------------------------------------

r16famt__s_stereo__d_mono__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				movsx    eax, word [esi + 2]			; eax = sample source droit
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		eax, ecx							; Mixe les deux samples
				sar      eax, 4							; eax = sample avec volume
				mov		dword [edi], eax				; Place le sample en memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;_______________________________________________
;
; Source stereo, destination stereo
;_______________________________________________
;

r16famt__s_stereo__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16famt__s_stereo__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

r16famt__s_stereo__d_stereo__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				movsx    eax, word [esi + 2]			; eax = sample source droit
				add		dword [edi], ecx				; Mixe le sample gauche avec la memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				add		dword [edi], eax				; Mixe le sample droit avec la memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16famt__end



;--- Ecrasement --------------------------------------------------------------

r16famt__s_stereo__d_stereo__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				movsx    eax, word [esi + 2]			; eax = sample source droit
				mov		dword [edi], ecx				; Place le sample gauche en memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				mov		dword [edi], eax				; Place le sample droit en memoire

				add      edx, dword [ebp + %$freq_frac]	; Additionne la partie fractionnaire de la position
				jnc      .suite
				add      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				add      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle



r16famt__end:
				endproc





;============================================================================;
;       Nom: MIX_resample_16b_and_mix_track                                  ;
;       Description: Resampling et mixage vers l'arriere d'un buffer 16 bits ;
;                    dans un buffer 24 bits.                                 ;
;============================================================================;

				proc		MIX_resample_16b_and_mix_track

%$s_buffer_ptr:	arg
%$d_buffer_ptr:	arg
%$d_length:			arg
%$s_stereo:			arg
%$d_stereo:			arg
%$left_volume:		arg
%$right_volume:	arg
%$erase_flag:		arg
%$pos_frac:			arg
%$freq_int:			arg
%$freq_frac:		arg

				cmp		dword [ebp + %$d_length], 0	; Verifie que la longueur destination soit > 0
				jg			.suite1
				jmp		r16bamt__end
.suite1:
				sar		dword [ebp + %$left_volume], 4		; Volume gauche sur 12 bits
				sar		dword [ebp + %$right_volume], 4		; Volume droit sur 12 bits
				mov		esi, dword [ebp + %$s_buffer_ptr]	; esi = pointeur sur sample source
				mov		edi, dword [ebp + %$d_buffer_ptr]	; edi = pointeur sur sample destination
				mov		edx, dword [ebp + %$pos_frac]	; edx = position fractionnaire dans le sample source

				cmp		dword [ebp + %$s_stereo], 2
				jne		r16bamt__s_mono
				jmp		r16bamt__s_stereo



r16bamt__s_mono:
				sal		dword [ebp + %$freq_int], 1
				cmp		dword [ebp + %$d_stereo], 2
				je			r16bamt__s_mono__d_stereo



;_______________________________________________
;
; Source mono, destination mono
;_______________________________________________
;

r16bamt__s_mono__d_mono:
				mov		eax, dword [ebp + %$left_volume]
				add		eax, dword [ebp + %$right_volume]	; eax = volume des deux voies sur 12 bits

				cmp		dword [ebp + %$erase_flag], 0
				jne		r16bamt__s_mono__d_mono__erase

;--- Mixage ------------------------------------------------------------------

r16bamt__s_mono__d_mono__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				imul     ecx, eax							; Multiplie par le volume
				sar      ecx, 4							; ecx = sample avec volume
				add		dword [edi], ecx				; Mixe le sample avec la memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;--- Ecrasement --------------------------------------------------------------

r16bamt__s_mono__d_mono__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				imul     ecx, eax							; Multiplie par le volume
				sar      ecx, 4							; ecx = sample avec volume
				mov		dword [edi], ecx				; Stoque le sample en memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;_______________________________________________
;
; Source mono, destination stereo
;_______________________________________________
;

r16bamt__s_mono__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16bamt__s_mono__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

r16bamt__s_mono__d_stereo__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				mov		eax, ecx
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 16							; ecx = sample gauche avec volume
				add		dword [edi], ecx				; Mixe le sample gauche avec la memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4						; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				add		dword [edi], eax				; Mixe le sample droit avec la memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;--- Ecrasement --------------------------------------------------------------

r16bamt__s_mono__d_stereo__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source
				mov		eax, ecx
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				mov		dword [edi], ecx				; Place le sample gauche en memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				mov		dword [edi], eax				; Place le sample droit en memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 2							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



r16bamt__s_stereo:
				sal		dword [ebp + %$freq_int], 2
				cmp		dword [ebp + %$d_stereo], 2
				jne		r16bamt__s_stereo__d_mono
				jmp		r16bamt__s_stereo__d_stereo



;_______________________________________________
;
; Source stereo, destination mono
;_______________________________________________
;

r16bamt__s_stereo__d_mono:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16bamt__s_stereo__d_mono__erase

;--- Mixage ------------------------------------------------------------------

r16bamt__s_stereo__d_mono__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				movsx    eax, word [esi + 2]			; eax = sample source droit
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		eax, ecx							; Mixe les deux samples
				sar      eax, 4							; eax = sample avec volume
				add		dword [edi], eax				; Mixe le sample avec la memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;--- Ecrasement --------------------------------------------------------------

r16bamt__s_stereo__d_mono__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				movsx    eax, word [esi + 2]			; eax = sample source droit
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		eax, ecx							; Mixe les deux samples
				sar      eax, 4							; eax = sample avec volume
				mov		dword [edi], eax				; Place le sample en memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;_______________________________________________
;
; Source stereo, destination stereo
;_______________________________________________
;

r16bamt__s_stereo__d_stereo:
				cmp		dword [ebp + %$erase_flag], 0
				jne		r16bamt__s_stereo__d_stereo__erase

;--- Mixage ------------------------------------------------------------------

r16bamt__s_stereo__d_stereo__mix:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				movsx    eax, word [esi + 2]			; eax = sample source droit
				add		dword [edi], ecx				; Mixe le sample gauche avec la memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				add		dword [edi], eax				; Mixe le sample droit avec la memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle

				jmp		r16bamt__end



;--- Ecrasement --------------------------------------------------------------

r16bamt__s_stereo__d_stereo__erase:
.boucle:
				movsx    ecx, word [esi]				; ecx = sample source gauche
				imul     ecx, dword [ebp + %$left_volume]	; Multiplie par le volume gauche
				sar      ecx, 4							; ecx = sample gauche avec volume
				movsx    eax, word [esi + 2]			; eax = sample source droit
				mov		dword [edi], ecx				; Place le sample gauche en memoire
				imul     eax, dword [ebp + %$right_volume]	; Multiplie par le volume droit
				add		edi, 4							; Pointe sur le sample destination droit
				sar      eax, 4							; eax = sample droit avec volume
				mov		dword [edi], eax				; Place le sample droit en memoire

				sub      edx, dword [ebp + %$freq_frac]	; Soustrait la partie fractionnaire de la position
				jnc      .suite
				sub      esi, 4							; Retenue: saute un sample source
.suite:		add		edi, 4							; Pointe sur le sample destination gauche suivant
				sub      esi, dword [ebp + %$freq_int]	; Sample source suivant

				dec      dword [ebp + %$d_length]	; Decremente le nombre de samples a traiter
				jnz      .boucle



r16bamt__end:
				endproc


