/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (MODMOD_CURRENT_HEADER)
	#error Inclusion recursive du header MODMOD.
#endif
#define	MODMOD_CURRENT_HEADER

#if ! defined (MODMOD_HEADER_INCLUDED)
#define	MODMOD_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"mods_ct.h"
#include	"modstruc.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#if defined (_MSC_VER)
#pragma pack (push, 1)
#endif

typedef struct
{
	/*
	Structure reele:
		-  4 bits: MSQ instument
		- 12 bits: Periode
		-  4 bits: LSQ instrument
		- 12 bits: commande
	*/
	BYTE		data [4];
} MODMOD_NOTE;

#if defined (_MSC_VER)
#pragma pack (pop)
#endif



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	MODMOD_save_module (FILE *file_ptr);

signed int	MODMOD_load_module (FILE *file_ptr, BYTE temp_info [MODS_TEMP_INFO_LEN]);
bool	MODMOD_detect_format (FILE *file_ptr, const void *header_ptr, long header_length, BYTE temp_info [MODS_TEMP_INFO_LEN]);

void	MODMOD_modpat_2_gtpat (int pattern, const MODMOD_NOTE *pattern_ptr);
void	MODMOD_modcmd_2_gtcmd (MODS_GT2_SPL_NOTE &gt2_note, int cmd, bool allow_nul_param_flag = false);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MODMOD_CURRENT_HEADER
