/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (MODS_CT_CURRENT_HEADER)
	#error Inclusion recursive du header MODS_CT.
#endif
#define	MODS_CT_CURRENT_HEADER

#if ! defined (MODS_CT_HEADER_INCLUDED)
#define	MODS_CT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "archi.h"



/*\\\ CONSTANTES ET MACROS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Plutot utiliser ca a la place du sizeof () */
#define	MODS_GT2_SPL_NOTE_LEN		5
#define	MODS_GT2_AIN_NOTE_LEN		3
#define	MODS_GT2_FX_NOTE_LEN			7
#define	MODS_GT2_MID_NOTE_LEN		4

/* La note qui prend le plus de place */
#define	MODS_GT2_MAX_NOTE_LEN		MODS_GT2_FX_NOTE_LEN



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Attention longueurs impaires, ne pas sizeofer sous Pure C ! */

typedef struct
{
	UBYTE		note;
	UBYTE		instr;
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_SPL_NOTE;			/* 5 octets */

typedef struct
{
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_AIN_NOTE;			/* 3 octets */

typedef struct
{
	UBYTE		comnum1;
	UBYTE		comnum2;
	UBYTE		comparam_msb;
	UBYTE		comparam_lsb;
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_FX_NOTE;			/* 7 octets */

typedef struct
{
	union
	{
		struct					/* Commande normale */
		{
			UBYTE		command;		/* Numero de commande normale */
			UBYTE		data [3];	/* Donnees des commandes normales */
		}			normal;
		LWORD		sysex_num;	/* Numero (0xF0 + 24 bits!) dans la table des System Exclusives */
	} event;
} MODS_GT2_MID_NOTE;			/* 4 octets */



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MODS_CT_CURRENT_HEADER
