/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PAT_CURRENT_HEADER)
	#error Inclusion recursive du header PAT.
#endif
#define	PAT_CURRENT_HEADER

#if ! defined (PAT_HEADER_INCLUDED)
#define	PAT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"mods_ct.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	PAT_NBRPATTERNS_MAXI		256		/* 0-255 */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	PAT_init (void);
void	PAT_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de base                                                    */
/*--------------------------------------------------------------------------*/

char	*PAT_get_pattern_name (int pattern, char *name_0);
void	PAT_set_pattern_name (int pattern, const char *name_0);
int	PAT_get_pattern_nbr_tracks (int track_type, int pattern);
void	PAT_set_pattern_nbr_tracks (int track_type, int pattern, int nbr_tracks);

int	PAT_get_pattern_height (int pattern);
signed int	PAT_set_pattern_height (int pattern, int nbrlines);
int	PAT_get_current_pattern_height (void);
signed int	PAT_set_current_pattern_height (int height);
signed int	PAT_set_nbr_tracks (int track_type, int nbr_tracks);

void	*PAT_get_note_adr_pat (int track_type, int pattern, int line, int track);
MODS_GT2_SPL_NOTE	*PAT_get_spl_note_adr_pat (int pattern, int line, int track);
MODS_GT2_AIN_NOTE	*PAT_get_ain_note_adr_pat (int pattern, int line, int track);
MODS_GT2_FX_NOTE	*PAT_get_fx_note_adr_pat (int pattern, int line, int track);
MODS_GT2_MID_NOTE	*PAT_get_mid_note_adr_pat (int pattern, int line, int track);

UWORD	PAT_get_track_command (int pattern, int track_type, int line, int track);
void	PAT_set_track_command (int pattern, int track_type, int line, int track, UWORD command);

ULWORD	PAT_get_fx_command (int pattern, int line, int track);
void	PAT_set_fx_command (int pattern, int line, int track, ULWORD command);

void	PAT_clear_note (int track_type, int pattern, int line, int track);
signed int	PAT_clear_patterns (void);

/*--------------------------------------------------------------------------*/
/*      Modifications avec l'interface                                      */
/*--------------------------------------------------------------------------*/

void	PAT_set_pattern_height_intr (int type, signed int value);
void	PAT_set_nbr_tracks_intr (int type, signed int value, int track_type);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern int	PAT_new_pattern_nbr_lines;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PAT_CURRENT_HEADER
