/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<math.h>

#include	"archi.h"
#include	"base.h"
#include	"base_ct.h"
#include	"env.h"
#include	"Envelope.h"
#include	"inst.h"
#include	"play_cmd.h"
#include	"play_env.h"
#include	"play_fx.h"
#include	"player.h"
#include	"song.h"
#include	"splhandl.h"
#include	"WaveForm.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*--------------------------------------------------------------------------*/
/*      Effets, premier tick de la ligne                                    */
/*--------------------------------------------------------------------------*/

void	PLAYCMD_nop (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_detune (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_delay_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_cut_note_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_jump_pos (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_vibrato_waveform (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_break_pattern (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_tremolo_waveform (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_tempo (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_arpeggio_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_porta_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_porta_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll_vol_slide_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_lin_master_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_lin_master_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_nbr_ticks (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_fine_tempo (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_pattern_delay (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_tremor_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_pattern_loop (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_flags (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_vol_env (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_tone_env (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_pan_env (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_cutoff_env (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_reso_env (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_demo_synchro (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_sample_offset (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_very_fine_sample_offset (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_inc_sample_pos (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_dec_sample_pos (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_mix_preset (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_lin_track_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_log_track_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_log_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_fine_log_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_lin_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_log_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_pan (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_lin_master_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_log_master_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll_vol_slide_set_pan_init (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_set_mix_preset_source_only (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_add_source_tracks (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_change_source_track_vol (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_change_source_track_pan (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_sample_offset (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Effets, tous les ticks                                              */
/*--------------------------------------------------------------------------*/

void	PLAYCMD_porta_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_porta_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_tone_porta_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_vibrato_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_tremolo (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_delay (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_cut_note (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_arpeggio (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll_vol_slide (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_up_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_down_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_up_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_down_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_up_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_vol_slide_down_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_up_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_vol_slide_down_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_master_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_master_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_extra_fine_tone_porta (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_extra_fine_porta_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_extra_fine_porta_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_left_balance_move (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_right_balance_move (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_tremor (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_auto_tempo (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_auto_period (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_lin_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_log_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_change_sample_direction (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_roll_vol_slide_set_pan (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Effets de la colonne de volume, premier tick de la ligne            */
/*--------------------------------------------------------------------------*/

void	PLAYCMD_volfx_fine_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_fine_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_set_panning (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Effets de la colonne de volume, tous les ticks                      */
/*--------------------------------------------------------------------------*/

void	PLAYCMD_volfx_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_set_vibrato_speed (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_vibrato (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_pan_slide_left (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_pan_slide_right (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYCMD_volfx_tone_portamento (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Fonctions communes a plusieurs effets                               */
/*--------------------------------------------------------------------------*/

void	PLAYCMD_do_sample_offset (PLAY_TRACK_INFO *track_info_ptr, LWORD pos_int, ULWORD pos_frac);
void	PLAYCMD_do_tone_porta (PLAY_TRACK_INFO *track_info_ptr, int speed);
void	PLAYCMD_do_vibrato (PLAY_TRACK_INFO *track_info_ptr, int param);
void	PLAYCMD_do_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr, int speed);
void	PLAYCMD_do_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr, int speed);
void	PLAYCMD_do_pan_slide_left (PLAY_TRACK_INFO *track_info_ptr, long speed);
void	PLAYCMD_do_pan_slide_right (PLAY_TRACK_INFO *track_info_ptr, long speed);
void	PLAYCMD_do_set_mix_preset (PLAY_TRACK_INFO *track_info_ptr, int preset, int flags);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Gestion des effets */
/* Tableau de pointeurs sur des fonctions pour chaque effet */
/* Effets: 00xx-1Fxx, A0xx-CFxx, 0xxx-Fxxx */
void	(*(PLAYCMD_effect_1st_tick_ptr [3] [0x60])) (PLAY_TRACK_INFO *) =
{
	/* Samples */
	{
		/* 00xx - 0Fxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_detune, PLAYCMD_delay_init, PLAYCMD_cut_note_init, PLAYCMD_jump_pos,
		PLAYCMD_set_vibrato_waveform, PLAYCMD_break_pattern, PLAYCMD_set_tremolo_waveform, PLAYCMD_set_tempo,
		/* 10xx - 1Fxx */
		PLAYCMD_arpeggio_init, PLAYCMD_fine_porta_up, PLAYCMD_fine_porta_down, PLAYCMD_roll_vol_slide_init,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* A0xx - AFxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_lin_vol_slide_up, PLAYCMD_fine_lin_vol_slide_down, PLAYCMD_fine_lin_master_vol_slide_up, PLAYCMD_fine_lin_master_vol_slide_down,
		PLAYCMD_set_nbr_ticks, PLAYCMD_set_fine_tempo, PLAYCMD_pattern_delay, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* B0xx - BFxx */
		PLAYCMD_tremor_init, PLAYCMD_pattern_loop, PLAYCMD_set_flags, PLAYCMD_set_vol_env,
		PLAYCMD_set_tone_env, PLAYCMD_set_pan_env, PLAYCMD_set_cutoff_env, PLAYCMD_set_reso_env,
		PLAYCMD_nop, PLAYCMD_demo_synchro, PLAYCMD_fine_sample_offset, PLAYCMD_very_fine_sample_offset,
		PLAYCMD_inc_sample_pos, PLAYCMD_dec_sample_pos, PLAYCMD_nop, PLAYCMD_nop,
		/* C0xx - CFxx */
		PLAYCMD_nop, PLAYCMD_set_mix_preset, PLAYCMD_set_lin_track_vol, PLAYCMD_set_log_track_vol,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_log_track_vol_slide_up, PLAYCMD_fine_log_track_vol_slide_down, PLAYCMD_set_mix_preset_source_only, PLAYCMD_add_source_tracks,
		PLAYCMD_change_source_track_vol, PLAYCMD_change_source_track_pan, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_set_lin_vol, PLAYCMD_set_log_vol,
		PLAYCMD_set_pan, PLAYCMD_set_lin_master_vol, PLAYCMD_set_log_master_vol, PLAYCMD_roll_init,
		PLAYCMD_roll_vol_slide_set_pan_init, PLAYCMD_sample_offset, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	},

	/* Audio In */
	{
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_jump_pos,
		PLAYCMD_nop, PLAYCMD_break_pattern, PLAYCMD_set_tremolo_waveform, PLAYCMD_set_tempo,
		/* 10xx - 1Fxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* A0xx - AFxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_lin_vol_slide_up, PLAYCMD_fine_lin_vol_slide_down, PLAYCMD_fine_lin_master_vol_slide_up, PLAYCMD_fine_lin_master_vol_slide_down,
		PLAYCMD_set_nbr_ticks, PLAYCMD_set_fine_tempo, PLAYCMD_pattern_delay, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* B0xx - BFxx */
		PLAYCMD_tremor_init, PLAYCMD_pattern_loop, PLAYCMD_set_flags, PLAYCMD_set_vol_env,
		PLAYCMD_nop, PLAYCMD_set_pan_env, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_demo_synchro, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* C0xx - CFxx */
		PLAYCMD_nop, PLAYCMD_set_mix_preset, PLAYCMD_set_lin_track_vol, PLAYCMD_set_log_track_vol,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_log_track_vol_slide_up, PLAYCMD_fine_log_track_vol_slide_down, PLAYCMD_set_mix_preset_source_only, PLAYCMD_add_source_tracks,
		PLAYCMD_change_source_track_vol, PLAYCMD_change_source_track_pan, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_set_lin_vol, PLAYCMD_set_log_vol,
		PLAYCMD_set_pan, PLAYCMD_set_lin_master_vol, PLAYCMD_set_log_master_vol, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	},

	/* Effets */
	{
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_detune, PLAYCMD_delay_init, PLAYCMD_cut_note_init, PLAYCMD_jump_pos,
		PLAYCMD_set_vibrato_waveform, PLAYCMD_break_pattern, PLAYCMD_set_tremolo_waveform, PLAYCMD_set_tempo,
		/* 10xx - 1Fxx */
		PLAYCMD_arpeggio_init, PLAYCMD_fine_porta_up, PLAYCMD_fine_porta_down, PLAYCMD_roll_vol_slide_init,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* A0xx - AFxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_lin_vol_slide_up, PLAYCMD_fine_lin_vol_slide_down, PLAYCMD_fine_lin_master_vol_slide_up, PLAYCMD_fine_lin_master_vol_slide_down,
		PLAYCMD_set_nbr_ticks, PLAYCMD_set_fine_tempo, PLAYCMD_pattern_delay, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* B0xx - BFxx */
		PLAYCMD_tremor_init, PLAYCMD_pattern_loop, PLAYCMD_set_flags, PLAYCMD_set_vol_env,
		PLAYCMD_set_tone_env, PLAYCMD_set_pan_env, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_demo_synchro, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* C0xx - CFxx */
		PLAYCMD_nop, PLAYCMD_set_mix_preset, PLAYCMD_set_lin_track_vol, PLAYCMD_set_log_track_vol,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_fine_log_track_vol_slide_up, PLAYCMD_fine_log_track_vol_slide_down, PLAYCMD_set_mix_preset_source_only, PLAYCMD_add_source_tracks,
		PLAYCMD_change_source_track_vol, PLAYCMD_change_source_track_pan, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_set_lin_vol, PLAYCMD_set_log_vol,
		PLAYCMD_set_pan, PLAYCMD_set_lin_master_vol, PLAYCMD_set_log_master_vol, PLAYCMD_roll_init,
		PLAYCMD_roll_vol_slide_set_pan_init, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	}
};

void	(*(PLAYCMD_effect_all_ticks_ptr [3] [0x60])) (PLAY_TRACK_INFO *) =
{
	/* Samples */
	{
		/* 00xx - 0Fxx */
		PLAYCMD_nop, PLAYCMD_porta_up, PLAYCMD_porta_down, PLAYCMD_tone_porta,
		PLAYCMD_vibrato, PLAYCMD_tone_porta_vibrato, PLAYCMD_vibrato_tone_porta, PLAYCMD_tremolo,
		PLAYCMD_nop, PLAYCMD_delay, PLAYCMD_cut_note, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 10xx - 1Fxx */
		PLAYCMD_arpeggio, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_roll_vol_slide,
		PLAYCMD_lin_vol_slide_up, PLAYCMD_lin_vol_slide_down, PLAYCMD_log_vol_slide_up, PLAYCMD_log_vol_slide_down,
		PLAYCMD_lin_vol_slide_up_tone_porta, PLAYCMD_lin_vol_slide_down_tone_porta, PLAYCMD_log_vol_slide_up_tone_porta, PLAYCMD_log_vol_slide_down_tone_porta,
		PLAYCMD_lin_vol_slide_up_vibrato, PLAYCMD_lin_vol_slide_down_vibrato, PLAYCMD_log_vol_slide_up_vibrato, PLAYCMD_log_vol_slide_down_vibrato,
		/* A0xx - AFxx */
		PLAYCMD_lin_master_vol_slide_up, PLAYCMD_lin_master_vol_slide_down, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_extra_fine_tone_porta,
		PLAYCMD_extra_fine_porta_up, PLAYCMD_extra_fine_porta_down, PLAYCMD_left_balance_move, PLAYCMD_right_balance_move,
		/* B0xx - BFxx */
		PLAYCMD_tremor, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_auto_tempo, PLAYCMD_auto_period,
		/* C0xx - CFxx */
		PLAYCMD_change_sample_direction, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_lin_track_vol_slide_up, PLAYCMD_lin_track_vol_slide_down, PLAYCMD_log_track_vol_slide_up, PLAYCMD_log_track_vol_slide_down,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_roll,
		PLAYCMD_roll_vol_slide_set_pan, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	},

	/* Audio In */
	{
		/* 00xx - 0Fxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_tremolo,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 10xx - 1Fxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_lin_vol_slide_up, PLAYCMD_lin_vol_slide_down, PLAYCMD_log_vol_slide_up, PLAYCMD_log_vol_slide_down,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* A0xx - AFxx */
		PLAYCMD_lin_master_vol_slide_up, PLAYCMD_lin_master_vol_slide_down, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_left_balance_move, PLAYCMD_right_balance_move,
		/* B0xx - BFxx */
		PLAYCMD_tremor, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_auto_tempo, PLAYCMD_auto_period,
		/* C0xx - CFxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_lin_track_vol_slide_up, PLAYCMD_lin_track_vol_slide_down, PLAYCMD_log_track_vol_slide_up, PLAYCMD_log_track_vol_slide_down,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	},

	/* Effets */
	{
		/* 00xx - 0Fxx */
		PLAYCMD_nop, PLAYCMD_porta_up, PLAYCMD_porta_down, PLAYCMD_tone_porta,
		PLAYCMD_vibrato, PLAYCMD_tone_porta_vibrato, PLAYCMD_vibrato_tone_porta, PLAYCMD_tremolo,
		PLAYCMD_nop, PLAYCMD_delay, PLAYCMD_cut_note, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 10xx - 1Fxx */
		PLAYCMD_arpeggio, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_roll_vol_slide,
		PLAYCMD_lin_vol_slide_up, PLAYCMD_lin_vol_slide_down, PLAYCMD_log_vol_slide_up, PLAYCMD_log_vol_slide_down,
		PLAYCMD_lin_vol_slide_up_tone_porta, PLAYCMD_lin_vol_slide_down_tone_porta, PLAYCMD_log_vol_slide_up_tone_porta, PLAYCMD_log_vol_slide_down_tone_porta,
		PLAYCMD_lin_vol_slide_up_vibrato, PLAYCMD_lin_vol_slide_down_vibrato, PLAYCMD_log_vol_slide_up_vibrato, PLAYCMD_log_vol_slide_down_vibrato,
		/* A0xx - AFxx */
		PLAYCMD_lin_master_vol_slide_up, PLAYCMD_lin_master_vol_slide_down, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_extra_fine_tone_porta,
		PLAYCMD_extra_fine_porta_up, PLAYCMD_extra_fine_porta_down, PLAYCMD_left_balance_move, PLAYCMD_right_balance_move,
		/* B0xx - BFxx */
		PLAYCMD_tremor, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_auto_tempo, PLAYCMD_auto_period,
		/* C0xx - CFxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_lin_track_vol_slide_up, PLAYCMD_lin_track_vol_slide_down, PLAYCMD_log_track_vol_slide_up, PLAYCMD_log_track_vol_slide_down,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		/* 0xxx - Fxxx */
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_roll,
		PLAYCMD_roll_vol_slide_set_pan, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop, PLAYCMD_nop
	}
};

/* Effets de la colonne de volume (a partir de 0x6?) */
void	(*(PLAYCMD_vol_effect_1st_tick_ptr [3] [10])) (PLAY_TRACK_INFO *) =
{
	/* Samples */
	{
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_fine_lin_vol_slide_down, PLAYCMD_volfx_fine_lin_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_set_panning, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop
	},

	/* Audio In */
	{
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_fine_lin_vol_slide_down, PLAYCMD_volfx_fine_lin_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_set_panning, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop
	},

	/* Effects */
	{
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_fine_lin_vol_slide_down, PLAYCMD_volfx_fine_lin_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_set_panning, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop
	}
};

void	(*(PLAYCMD_vol_effect_all_ticks_ptr [3] [10])) (PLAY_TRACK_INFO *) =
{
	/* Samples */
	{
		PLAYCMD_volfx_vol_slide_down, PLAYCMD_volfx_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_set_vibrato_speed, PLAYCMD_volfx_vibrato,
		PLAYCMD_nop, PLAYCMD_volfx_pan_slide_left,
		PLAYCMD_volfx_pan_slide_right, PLAYCMD_volfx_tone_portamento
	},

	/* Audio In */
	{
		PLAYCMD_volfx_vol_slide_down, PLAYCMD_volfx_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_nop, PLAYCMD_volfx_pan_slide_left,
		PLAYCMD_volfx_pan_slide_right, PLAYCMD_nop
	},

	/* Effects */
	{
		PLAYCMD_volfx_vol_slide_down, PLAYCMD_volfx_vol_slide_up,
		PLAYCMD_nop, PLAYCMD_nop,
		PLAYCMD_volfx_set_vibrato_speed, PLAYCMD_volfx_vibrato,
		PLAYCMD_nop, PLAYCMD_volfx_pan_slide_left,
		PLAYCMD_volfx_pan_slide_right, PLAYCMD_volfx_tone_portamento
	}
};



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_1st_tick_spl                            */
/*      Description: Gere les effets, notes et parametres qui n'agissent    */
/*                   qu'au premier tick d'une ligne, pour une piste donnee  */
/*                   de samples.                                            */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_1st_tick_spl (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_SPL] [track];
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;

	/* On ne gere pas ici la nouvelle note si l'effet est un Note delay */
	if (effect_nbr != 0x09)
	{
		PLAY_set_new_note (track_info_ptr);
	}

	/* Gestion des effets de la colonne de volume */
	vol_cmd = track_info_ptr->score.score.volume >> 4;
	if (vol_cmd >= 0x06)
	{
		(PLAYCMD_vol_effect_1st_tick_ptr [Pattern_TYPE_SPL] [vol_cmd - 0x6]) (track_info_ptr);
	}

	/* Gestion des commandes */
	if (effect_nbr < 0x20U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_SPL] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_SPL] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		track_info_ptr->score.score.effect_par = effect & 0xFFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_SPL] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_1st_tick_ain                            */
/*      Description: Gere les effets, notes et parametres qui n'agissent    */
/*                   qu'au premier tick d'une ligne, pour une piste donnee  */
/*                   d'Audio In.                                            */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_1st_tick_ain (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	int		volume;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_AIN] [track];

	/* Gestion de la colonne de volume */
	volume = track_info_ptr->score.score.volume;
	if (   volume >= 0x10
	    && volume <= 0x50)
	{
		PLAY_set_lin_velocity (track_info_ptr, (volume - 0x10) << 5);
	}
	else
	{
		vol_cmd = volume >> 4;
		if (vol_cmd >= 0x06)
		{
			(PLAYCMD_vol_effect_1st_tick_ptr [Pattern_TYPE_AIN] [vol_cmd - 0x6]) (track_info_ptr);
		}
	}

	/* Gestion des commandes */
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;
	
	if (effect_nbr < 0x20U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_AIN] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_AIN] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		track_info_ptr->score.score.effect_par = effect & 0xFFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_AIN] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_1st_tick_fx                             */
/*      Description: Gere les effets, notes et parametres qui n'agissent    */
/*                   qu'au premier tick d'une ligne, pour une piste donnee  */
/*                   d'effets.                                              */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_1st_tick_fx (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_FX] [track];

	/* Gestion des effets */
	PLAYFX_manage_1st_tick (track_info_ptr);

	/* Gestion des effets de la colonne de volume */
	vol_cmd = track_info_ptr->score.score.volume >> 4;
	if (vol_cmd >= 0x06)
	{
		(PLAYCMD_vol_effect_1st_tick_ptr [Pattern_TYPE_FX] [vol_cmd - 0x6]) (track_info_ptr);
	}

	/* Gestion des commandes */
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;

	if (effect_nbr < 0x20U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_FX] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		track_info_ptr->score.score.effect_par = effect & 0xFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_FX] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		track_info_ptr->score.score.effect_par = effect & 0xFFF;
		(PLAYCMD_effect_1st_tick_ptr [Pattern_TYPE_FX] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_1st_tick_mid                            */
/*      Description: Gere les effets, notes et parametres qui n'agissent    */
/*                   qu'au premier tick d'une ligne, pour une piste donnee  */
/*                   MIDI.                                                  */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_1st_tick_mid (int track)
{
	PLAY_TRACK_INFO			*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_MID] [track];

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_all_ticks_spl                           */
/*      Description: Gere les effets qui durent toute la duree de la ligne  */
/*                   pour une piste donnee de samples.                      */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_all_ticks_spl (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_SPL] [track];

	track_info_ptr->score.velocity_loc = track_info_ptr->score.velocity_lin;
	track_info_ptr->score.period_loc = track_info_ptr->score.period;

	/* Gestion des effets de la colonne de volume */
	vol_cmd = track_info_ptr->score.score.volume >> 4;
	if (vol_cmd >= 0x06)
	{
		(PLAYCMD_vol_effect_all_ticks_ptr [Pattern_TYPE_SPL] [vol_cmd - 0x06]) (track_info_ptr);
	}

	/* Gestion des commandes */
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;

	if (effect_nbr < 0x20U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_SPL] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_SPL] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_SPL] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_all_ticks_ain                           */
/*      Description: Gere les effets qui durent toute la duree de la ligne  */
/*                   pour une piste donnee d'Audio In.                      */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_all_ticks_ain (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_AIN] [track];

	track_info_ptr->score.velocity_loc = track_info_ptr->score.velocity_lin;

	/* Gestion des effets de la colonne de volume */
	vol_cmd = track_info_ptr->score.score.volume >> 4;
	if (vol_cmd >= 0x06)
	{
		(PLAYCMD_vol_effect_all_ticks_ptr [Pattern_TYPE_AIN] [vol_cmd - 0x06]) (track_info_ptr);
	}

	/* Gestion des commandes */
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;

	if (effect_nbr < 0x20U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_AIN] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_AIN] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_AIN] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_all_ticks_fx                            */
/*      Description: Gere les effets qui durent toute la duree de la ligne  */
/*                   pour une piste donnee d'effets.                        */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_all_ticks_fx (int track)
{
	unsigned int	effect;
	int		effect_nbr;
	int		vol_cmd;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_FX] [track];

	track_info_ptr->score.velocity_loc = track_info_ptr->score.velocity_lin;
	track_info_ptr->score.period_loc = track_info_ptr->score.period;

	/* Gestion des effets de la colonne de volume */
	vol_cmd = track_info_ptr->score.score.volume >> 4;
	if (vol_cmd >= 0x06)
	{
		(PLAYCMD_vol_effect_all_ticks_ptr [Pattern_TYPE_FX] [vol_cmd - 0x06]) (track_info_ptr);
	}

	/* Gestion des commandes */
	effect = track_info_ptr->score.score.effect;
	effect_nbr = effect >> 8;

	if (effect_nbr < 0x20U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_FX] [effect_nbr]) (track_info_ptr);
	}
	else if (effect_nbr >= 0xA0U && effect_nbr < 0xD0U)
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_FX] [effect_nbr - 0x80]) (track_info_ptr);
	}
	else
	{
		(PLAYCMD_effect_all_ticks_ptr [Pattern_TYPE_FX] [(effect_nbr >> 4) + 0x50]) (track_info_ptr);
	}
}



/*==========================================================================*/
/*      Nom: PLAYCMD_manage_effects_all_ticks_mid                           */
/*      Description: Gere les effets qui durent toute la duree de la ligne  */
/*                   pour une piste donnee MIDI.                            */
/*      Parametres en entree:                                               */
/*        - track: numero de la piste a traiter.                            */
/*==========================================================================*/

void	PLAYCMD_manage_effects_all_ticks_mid (int track)
{
	PLAY_TRACK_INFO			*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [Pattern_TYPE_MID] [track];

	/*** A faire ***/

}



/****************************************************************************/
/*                                                                          */
/*      EFFETS, PREMIER TICK DE LA LIGNE                                    */
/*                                                                          */
/****************************************************************************/



void	PLAYCMD_nop (PLAY_TRACK_INFO *track_info_ptr)
{
	/* Rien. Que dalle. Nib. */

	/* C'est pour eviter le warning d'inutilisation du parametre */
	track_info_ptr = NULL;
}



void	PLAYCMD_detune (PLAY_TRACK_INFO *track_info_ptr)
{
	signed int	val;

	val = track_info_ptr->score.score.effect_par;
	track_info_ptr->score.sample.finetune = ((val & 0xF0) >> 4) - (val & 0x0F);
	if (track_info_ptr->score.score.note != 0)
	{
		PLAY_set_period (track_info_ptr,
		                 (float)PLAY_convert_note_to_internal_period
			(  track_info_ptr->score.score.note
			 + track_info_ptr->score.sample.transp,
			 track_info_ptr->score.sample.finetune));
	}
}



void	PLAYCMD_delay_init (PLAY_TRACK_INFO *track_info_ptr)
{
	track_info_ptr->score.delay.play = track_info_ptr->score.score.effect_par;
}



void	PLAYCMD_cut_note_init (PLAY_TRACK_INFO *track_info_ptr)
{
	track_info_ptr->score.delay.cut = track_info_ptr->score.score.effect_par;
}



void	PLAYCMD_jump_pos (PLAY_TRACK_INFO *track_info_ptr)
{
	switch (PLAY_score_info.current_play_mode)
	{
	case	PLAY_MODE_SONG:
		PLAY_score_info.next_pos = track_info_ptr->score.score.effect_par;
		break;
	case	PLAY_MODE_STOP:
		PLAY_score_info.next_pos = 1;
		break;
	/* PLAY_MODE_PATTERN: pas de changement */
	}
	PLAY_score_info.next_flag = true;
}



void	PLAYCMD_set_vibrato_waveform (PLAY_TRACK_INFO *track_info_ptr)
{
	track_info_ptr->score.vibrato.waveform = track_info_ptr->score.score.effect_par & 0x03;
}



void	PLAYCMD_break_pattern (PLAY_TRACK_INFO *track_info_ptr)
{
	int		pattern;

	switch (PLAY_score_info.current_play_mode)
	{
	case	PLAY_MODE_SONG:
		/* Position suivante si elle n'a pas ete deja forcee */
		if (PLAY_score_info.next_flag == 0)
		{
			PLAY_score_info.next_pos = PLAY_score_info.current_pos + 1;
			if (PLAY_score_info.next_pos >= SONG_get_song_length ())
			{
				PLAY_score_info.next_pos = SONG_get_song_repeat ();
			}
		}
		pattern = SONG_get_pattern_number (PLAY_score_info.next_pos);
		break;

	case	PLAY_MODE_PATTERN:
		PLAY_score_info.next_pos = PLAY_score_info.current_pos;
		pattern = SONG_get_pattern_number (PLAY_score_info.next_pos);
		break;

	case	PLAY_MODE_STOP:
		PLAY_score_info.next_pos = 1;
		pattern = GTK_PATTERN_BIDON_B;
		break;
	}

	/* Nouvelle ligne */
	if (   track_info_ptr->score.score.effect_par
		 >= PAT_get_pattern_height (pattern))
	{
		PLAY_score_info.next_line = 0;
	}
	else
	{
		PLAY_score_info.next_line = track_info_ptr->score.score.effect_par;
	}

	PLAY_score_info.next_flag = true;
}



void	PLAYCMD_set_tremolo_waveform (PLAY_TRACK_INFO *track_info_ptr)
{
	track_info_ptr->score.tremolo.waveform = track_info_ptr->score.score.effect_par & 0x03;
}



void	PLAYCMD_set_tempo (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par == 0)
	{
		return;
	}

	/* Fixe la vitesse et le tempo a 125 */
	if (track_info_ptr->score.score.effect_par <= 31)
	{
		PLAY_score_info.speed = track_info_ptr->score.score.effect_par;
		PLAY_score_info.tempo_int = 125;
		PLAY_score_info.tempo_frac = 0;
	}

	/* Fixe le tempo */
	else
	{
		PLAY_score_info.tempo_int = track_info_ptr->score.score.effect_par;
		PLAY_score_info.tempo_frac = 0;
	}
}



void	PLAYCMD_arpeggio_init (PLAY_TRACK_INFO *track_info_ptr)
{
	track_info_ptr->score.arpeggio_cnt = 0;
}



void	PLAYCMD_fine_porta_up (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_period (track_info_ptr,
							 track_info_ptr->score.period
						  - (track_info_ptr->score.score.effect_par << 4));
}



void	PLAYCMD_fine_porta_down (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_period (track_info_ptr,
							 track_info_ptr->score.period
						  + (track_info_ptr->score.score.effect_par << 4));
}



void	PLAYCMD_roll_vol_slide_init (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	speed = track_info_ptr->score.score.effect_par & 0xF;
	if (speed != 0)
	{
		track_info_ptr->score.roll.speed = speed;
		track_info_ptr->score.roll.cnt = 0;
		track_info_ptr->score.roll.nbr = -1;
	}
}



void	PLAYCMD_fine_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.fine_speed;
	}
	track_info_ptr->score.vol_slide.fine_speed = speed;
	PLAY_set_lin_velocity (track_info_ptr, track_info_ptr->score.velocity_lin + speed * 8);
}



void	PLAYCMD_fine_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.fine_speed;
	}
	track_info_ptr->score.vol_slide.fine_speed = speed;
	PLAY_set_lin_velocity (track_info_ptr, track_info_ptr->score.velocity_lin - speed * 8);
}



void	PLAYCMD_fine_lin_master_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		vol;

	vol =   (LWORD) (PLAY_track_info + PLAY_track_info_list [GTK_TRACK_TYPE_AOU] [0])->score.track.volume_lin
	      + (LWORD) track_info_ptr->score.score.effect_par;
	PLAY_set_lin_master_volume (vol);
}



void	PLAYCMD_fine_lin_master_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		vol;

	vol =   (LWORD) (PLAY_track_info + PLAY_track_info_list [GTK_TRACK_TYPE_AOU] [0])->score.track.volume_lin
	      - (LWORD) track_info_ptr->score.score.effect_par;
	PLAY_set_lin_master_volume (vol);
}



void	PLAYCMD_set_nbr_ticks (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par != 0)
	{
		PLAY_score_info.speed = track_info_ptr->score.score.effect_par;
	}
}



void	PLAYCMD_set_fine_tempo (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_score_info.tempo_frac = (ULWORD)track_info_ptr->score.score.effect_par << 24;
}



void	PLAYCMD_pattern_delay (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_score_info.pattern_delay = track_info_ptr->score.score.effect_par;
}



void	PLAYCMD_tremor_init (PLAY_TRACK_INFO *track_info_ptr)
{
	int		trem_on;
	int		trem_off;

	if (track_info_ptr->score.score.effect_par == 0)
	{
		return;
	}

	trem_on = track_info_ptr->score.score.effect_par >> 4;
	trem_off = track_info_ptr->score.score.effect_par & 15;
	track_info_ptr->score.tremor.on = trem_on;
	track_info_ptr->score.tremor.period = trem_on + trem_off;
	track_info_ptr->score.tremor.cnt = 0;
}



void	PLAYCMD_pattern_loop (PLAY_TRACK_INFO *track_info_ptr)
{
	int		nbr;
	int		count;

	nbr = track_info_ptr->score.score.effect_par;

	/* Debut de la boucle: on memorise la position de bouclage */
	if (nbr == 0)
	{
		track_info_ptr->score.ploop.songpos = PLAY_score_info.current_pos;
		track_info_ptr->score.ploop.linepos = PLAY_score_info.current_line;
		return;
	}

	count = track_info_ptr->score.ploop.cnt;

	/* Premiere fin de boucle: memorise le nombre de repetitions */
	if (count == 0)
	{
		count = nbr;
	}
	else
	{
		count --;
	}
	track_info_ptr->score.ploop.cnt = count;

	/* Bouclage */
	if (   count > 0
	    && track_info_ptr->score.ploop.songpos >= 0)
	{
		PLAY_score_info.next_line = track_info_ptr->score.ploop.linepos;
		PLAY_score_info.next_pos = track_info_ptr->score.ploop.songpos;
		PLAY_score_info.next_flag = true;
	}
}



void	PLAYCMD_set_flags (PLAY_TRACK_INFO *track_info_ptr)
{
	int		track;

	/* Interpolation sur aucune piste */
	if (track_info_ptr->score.score.effect_par & 0x04)
	{
		for (track = 0; track < GTK_nbr_tracks [Pattern_TYPE_SPL]; track ++)
		{
			PLAY_set_interpolation_flag (track, false);
		}
	}

	/* Interpolation sur toutes les pistes */
	if (track_info_ptr->score.score.effect_par & 0x02)
	{
		for (track = 0; track < GTK_nbr_tracks [Pattern_TYPE_SPL]; track ++)
		{
			PLAY_set_interpolation_flag (track, true);
		}
	}

	/* Interpolation */
	track_info_ptr->mix.spl.interpol_flag = ((track_info_ptr->score.score.effect_par & 0x01) != 0);
}



void	PLAYCMD_set_vol_env (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par > INST_NBRINSTR_MAXI)
	{
		return;
	}

	track_info_ptr->score.com_env [Envelope_TYPE_VOL].nbr = track_info_ptr->score.score.effect_par;
	if (track_info_ptr->score.score.effect_par != 0)
	{
		ENV_start (Envelope_TYPE_VOL,
		           track_info_ptr->score.com_env [Envelope_TYPE_VOL].nbr,
		           track_info_ptr->score.com_env [Envelope_TYPE_VOL].proc);
	}
}



void	PLAYCMD_set_tone_env (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par > INST_NBRINSTR_MAXI)
	{
		return;
	}

	track_info_ptr->score.com_env [Envelope_TYPE_TON].nbr = track_info_ptr->score.score.effect_par;
	if (track_info_ptr->score.score.effect_par != 0)
	{
		ENV_start (Envelope_TYPE_TON,
		           track_info_ptr->score.com_env [Envelope_TYPE_TON].nbr,
		           track_info_ptr->score.com_env [Envelope_TYPE_TON].proc);
	}
}



void	PLAYCMD_set_pan_env (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par > INST_NBRINSTR_MAXI)
	{
		return;
	}

	track_info_ptr->score.com_env [Envelope_TYPE_PAN].nbr = track_info_ptr->score.score.effect_par;
	if (track_info_ptr->score.score.effect_par != 0)
	{
		ENV_start (Envelope_TYPE_PAN,
		           track_info_ptr->score.com_env [Envelope_TYPE_PAN].nbr,
		           track_info_ptr->score.com_env [Envelope_TYPE_PAN].proc);
	}
}



void	PLAYCMD_set_cutoff_env (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par > INST_NBRINSTR_MAXI)
	{
		return;
	}

	track_info_ptr->score.com_env [Envelope_TYPE_CUTOFF].nbr = track_info_ptr->score.score.effect_par;
	if (track_info_ptr->score.score.effect_par != 0)
	{
		track_info_ptr->score.lpf.filter_flag = true;
		track_info_ptr->score.changed_filter_flag = true;
		ENV_start (Envelope_TYPE_CUTOFF,
		           track_info_ptr->score.com_env [Envelope_TYPE_CUTOFF].nbr,
		           track_info_ptr->score.com_env [Envelope_TYPE_CUTOFF].proc);
	}
}



void	PLAYCMD_set_reso_env (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.score.effect_par > INST_NBRINSTR_MAXI)
	{
		return;
	}

	track_info_ptr->score.com_env [Envelope_TYPE_RESO].nbr = track_info_ptr->score.score.effect_par;
	if (track_info_ptr->score.score.effect_par != 0)
	{
		track_info_ptr->score.lpf.filter_flag = true;
		track_info_ptr->score.changed_filter_flag = true;
		ENV_start (Envelope_TYPE_RESO,
		           track_info_ptr->score.com_env [Envelope_TYPE_RESO].nbr,
		           track_info_ptr->score.com_env [Envelope_TYPE_RESO].proc);
	}
}



void	PLAYCMD_demo_synchro (PLAY_TRACK_INFO *track_info_ptr)
{
	/* Rien. Que dalle. Nib. */

	/* C'est pour eviter le warning d'inutilisation du parametre */
	track_info_ptr = NULL;
}



void	PLAYCMD_fine_sample_offset (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_sample_offset (track_info_ptr,
	                          (LWORD)track_info_ptr->score.score.effect_par << 4,
	                          0);
}



void	PLAYCMD_very_fine_sample_offset (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_sample_offset (track_info_ptr,
	                          (LWORD)track_info_ptr->score.score.effect_par,
	                          0);
}



void	PLAYCMD_inc_sample_pos (PLAY_TRACK_INFO *track_info_ptr)
{
	SLWORD	new_pos;
	LWORD		length;
	LWORD		reppos;
	LWORD		replen;
	int		direction;

	direction = track_info_ptr->mix.spl.direction;
	new_pos = track_info_ptr->mix.spl.curpos_int;
	reppos = track_info_ptr->mix.spl.reppos;
	replen = track_info_ptr->mix.spl.replen;
	length = reppos + replen;

	/* Bouclage forward */
	if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_NONE)
	{
		if (direction == 1)
		{
			new_pos -= (LWORD)track_info_ptr->score.score.effect_par;
		}
		else
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
			if (new_pos > length)
			{
				new_pos -= reppos;
				new_pos %= replen;
				new_pos += reppos;
			}
		}
	}

	/* Ping-Pong Loop */
	else if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_PP)
	{
		if (direction == 1)
		{
			new_pos -= (LWORD)track_info_ptr->score.score.effect_par;
			/* Si on depasse a gauche, on remet dans la direction positive */
			if (new_pos < reppos - 1)
			{
				direction = 0;
				new_pos = (reppos * 2 - 1) - new_pos;
				if (track_info_ptr->mix.spl.curpos_frac != 0)
				{
					track_info_ptr->mix.spl.curpos_frac = - (SLWORD)track_info_ptr->mix.spl.curpos_frac;
					new_pos --;
				}
			}
		}
		else
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
		}

		/* Si on depasse a gauche */
		if (new_pos > length)
		{
			new_pos -= reppos;
			new_pos %= replen * 2;
			if (new_pos >= replen)
			{
				direction = 1;
				new_pos = (replen * 2 - 1) - new_pos;
				if (track_info_ptr->mix.spl.curpos_frac != 0)
				{
					new_pos --;
					track_info_ptr->mix.spl.curpos_frac = - (SLWORD)track_info_ptr->mix.spl.curpos_frac;
				}
			}
			new_pos += reppos;
		}
	}

	/* Pas de bouclage */
	else
	{
		if (direction == 1)
		{
			new_pos -= (LWORD)track_info_ptr->score.score.effect_par;
		}
		else
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
		}
	}

	track_info_ptr->mix.spl.curpos_int = new_pos;
	track_info_ptr->mix.spl.direction = direction;
}



void	PLAYCMD_dec_sample_pos (PLAY_TRACK_INFO *track_info_ptr)
{
	SLWORD	new_pos;
	LWORD		length;
	LWORD		reppos;
	LWORD		replen;
	int		direction;

	direction = track_info_ptr->mix.spl.direction;
	new_pos = track_info_ptr->mix.spl.curpos_int;
	reppos = track_info_ptr->mix.spl.reppos;
	replen = track_info_ptr->mix.spl.replen;
	length = reppos + replen;

	/* Marche arriere */
	if (direction == 1)
	{
		/* Bouclage forward */
		if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_NONE)
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
			if (new_pos > length)
			{
				new_pos -= reppos;
				new_pos %= replen;
				new_pos += reppos;
			}
		}

		/* Ping-Pong Loop */
		else if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_PP)
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
			/* Si on depasse a gauche */
			if (new_pos > length)
			{
				new_pos -= reppos;
				new_pos %= replen * 2;
				if (new_pos >= replen)
				{
					direction = 0;
					new_pos = (replen * 2 - 1) - new_pos;
					if (track_info_ptr->mix.spl.curpos_frac != 0)
					{
						new_pos --;
						track_info_ptr->mix.spl.curpos_frac = - (SLWORD)track_info_ptr->mix.spl.curpos_frac;
					}
				}
				new_pos += reppos;
			}
		}

		/* Pas de bouclage */
		else
		{
			new_pos += (LWORD)track_info_ptr->score.score.effect_par;
			new_pos = MIN (new_pos, length - 1);
		}
	}

	/* Marche avant */
	else
	{
		new_pos -= (LWORD)track_info_ptr->score.score.effect_par;
		new_pos = MAX (new_pos, 0);
	}

	track_info_ptr->mix.spl.curpos_int = new_pos;
	track_info_ptr->mix.spl.direction = direction;
}



void	PLAYCMD_set_mix_preset (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_set_mix_preset (track_info_ptr,
	                           track_info_ptr->score.score.effect_par,
	                           PLAY_MIX_PRESET_REPL);
}



void	PLAYCMD_set_lin_track_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_lin_volume (track_info_ptr, track_info_ptr->score.score.effect_par << 8);
}



void	PLAYCMD_set_log_track_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_log_volume (track_info_ptr, track_info_ptr->score.score.effect_par << 4);
}



void	PLAYCMD_fine_log_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.log_vol_fine_speed;
	}
	track_info_ptr->score.track.log_vol_fine_speed = speed;
	PLAY_set_log_volume (track_info_ptr, track_info_ptr->score.track.volume_log + speed);
}



void	PLAYCMD_fine_log_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.lin_vol_fine_speed;
	}
	track_info_ptr->score.track.log_vol_fine_speed = speed;
	PLAY_set_log_volume (track_info_ptr, track_info_ptr->score.track.volume_log - speed);
}



void	PLAYCMD_set_mix_preset_source_only (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_set_mix_preset (track_info_ptr,
	                           track_info_ptr->score.score.effect_par,
	                           PLAY_MIX_PRESET_REPL | PLAY_MIX_PRESET_NO_DEST);
}



void	PLAYCMD_add_source_tracks (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_set_mix_preset (track_info_ptr,
	                           track_info_ptr->score.score.effect_par,
	                           PLAY_MIX_PRESET_ADD | PLAY_MIX_PRESET_NO_DEST);
}



void	PLAYCMD_change_source_track_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_set_mix_preset (track_info_ptr,
	                           track_info_ptr->score.score.effect_par,
	                           PLAY_MIX_PRESET_ADD | PLAY_MIX_PRESET_NO_DEST | PLAY_MIX_PRESET_NO_PAN);
}



void	PLAYCMD_change_source_track_pan (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_set_mix_preset (track_info_ptr,
	                           track_info_ptr->score.score.effect_par,
	                           PLAY_MIX_PRESET_ADD | PLAY_MIX_PRESET_NO_DEST | PLAY_MIX_PRESET_NO_VOL);
}



void	PLAYCMD_set_lin_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_lin_velocity (track_info_ptr, track_info_ptr->score.score.effect_par * 8);
}



void	PLAYCMD_set_log_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_log_velocity (track_info_ptr, track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_set_pan (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_panning (track_info_ptr, false, track_info_ptr->score.score.effect_par << 4);
}



void	PLAYCMD_set_lin_master_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_lin_master_volume (track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_set_log_master_vol (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_log_master_volume (track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_roll_init (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	/* Nombre de coups */
	if ((track_info_ptr->score.score.effect_par & 0xFF) == 0)
	{
		track_info_ptr->score.roll.nbr = -1;
	}
	else
	{
		track_info_ptr->score.roll.nbr = track_info_ptr->score.score.effect_par & 0xFF;
	}

	/* Vitesse */
	speed = track_info_ptr->score.score.effect_par >> 8;
	if (speed != 0)
	{
		track_info_ptr->score.roll.speed = speed;
		track_info_ptr->score.roll.cnt = 0;
	}
}



void	PLAYCMD_roll_vol_slide_set_pan_init (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	/* Balance */
	track_info_ptr->score.track.panning = (track_info_ptr->score.score.effect_par & 0xF00) << 4;

	/* Vitesse */
	speed = track_info_ptr->score.score.effect_par & 0xF;
	if (speed != 0)
	{
		track_info_ptr->score.roll.speed = speed;
		track_info_ptr->score.roll.cnt = 0;
		track_info_ptr->score.roll.nbr = -1;
	}
}



void	PLAYCMD_sample_offset (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_sample_offset (track_info_ptr,
	                          (LWORD)track_info_ptr->score.score.effect_par << 8,
	                          0);
}



/****************************************************************************/
/*                                                                          */
/*      EFFETS, TOUS LES TICKS                                              */
/*                                                                          */
/****************************************************************************/



void	PLAYCMD_porta_up (PLAY_TRACK_INFO *track_info_ptr)
{
	SLWORD	speed;

	speed = track_info_ptr->score.score.effect_par << 4;
	if (speed == 0)
	{
		speed = track_info_ptr->score.porta.speed;
	}
	track_info_ptr->score.porta.speed = speed;

	PLAY_set_period (track_info_ptr, track_info_ptr->score.period - speed);
}



void	PLAYCMD_porta_down (PLAY_TRACK_INFO *track_info_ptr)
{
	SLWORD	speed;

	speed = track_info_ptr->score.score.effect_par << 4;
	if (speed == 0)
	{
		speed = track_info_ptr->score.porta.speed;
	}
	track_info_ptr->score.porta.speed = speed;

	PLAY_set_period (track_info_ptr, track_info_ptr->score.period + speed);
}



void	PLAYCMD_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_tone_porta (track_info_ptr,
								  track_info_ptr->score.score.effect_par << 4);
}



void	PLAYCMD_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_vibrato (track_info_ptr,
							  track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_tone_porta_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_tone_porta (track_info_ptr,
								  track_info_ptr->score.score.effect_par << 4);
	PLAYCMD_do_vibrato (track_info_ptr, 0);
}



void	PLAYCMD_vibrato_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_tone_porta (track_info_ptr, 0);
	PLAYCMD_do_vibrato (track_info_ptr,
							  track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_tremolo (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;
	int		amplitude;
	int		new_velo;

	/* Vitesse du Tremolo */
	speed = (track_info_ptr->score.score.effect_par & 0xF0) >> 2;
	if (speed == 0)
	{
		speed = track_info_ptr->score.tremolo.speed;
	}
	track_info_ptr->score.tremolo.speed = speed;

	/* Amplitude du Tremolo */
	amplitude = track_info_ptr->score.score.effect_par & 0xF;
	if (amplitude == 0)
	{
		amplitude = track_info_ptr->score.tremolo.amp;
	}
	track_info_ptr->score.tremolo.amp = amplitude;

	/* Reglage de la velocite locale */
	new_velo =   track_info_ptr->score.velocity_lin
				  + (SWORD) ((  PLAY_sin_table [track_info_ptr->score.tremolo.waveform]
														 [(track_info_ptr->score.tremolo.cnt >> 2) & 0x3F]
								  * amplitude) / 2);
	new_velo = MIN (new_velo, 0x800);
	new_velo = MAX (new_velo, 0);
	track_info_ptr->score.velocity_loc = new_velo;
	track_info_ptr->score.changed_volume_flag = true;

	/* Compteur suivant */
	track_info_ptr->score.vibrato.cnt += (UBYTE)speed;
}



void	PLAYCMD_delay (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.delay.play == PLAY_score_info.tick_counter)
	{
		PLAY_set_new_note (track_info_ptr);
	}
}



void	PLAYCMD_cut_note (PLAY_TRACK_INFO *track_info_ptr)
{
	if (track_info_ptr->score.delay.cut == PLAY_score_info.tick_counter)
	{
		/* Pas d'enveloppe de volume, on coupe simplement le sifflet */
		if (track_info_ptr->score.com_env [Envelope_TYPE_VOL].nbr == 0)
		{
			PLAY_set_lin_velocity (track_info_ptr, 0);
		}

		/* Sinon on passe toutes les enveloppes en key off. */
		else
		{
			for (int type = 0; type < Envelope_NBR_TYPES; type ++)
			{
				track_info_ptr->score.com_env [type].proc.key_off_flag = 1;
			}
		}
	}
}



void	PLAYCMD_arpeggio (PLAY_TRACK_INFO *track_info_ptr)
{
	int		count;
	int		transp;
	int		note;

	count = track_info_ptr->score.arpeggio_cnt;

	if (count == 0)
	{
		count = 1;
	}

	else
	{
		if (count == 1)
		{
			transp = (track_info_ptr->score.score.effect_par >> 4) & 0xF;
			count = 2;
		}
		else if (count == 2)
		{
			transp = track_info_ptr->score.score.effect_par & 0xF;
			count = 0;
		}

		note =   track_info_ptr->score.note
				 + (signed int)track_info_ptr->score.sample.transp
				 + transp;
		note = MIN (note, GTK_NBRNOTES_MAXI - 1);
		note = MAX (note, 1);
		track_info_ptr->score.period_loc
			= (float) PLAY_convert_note_to_internal_period
			(note, track_info_ptr->score.sample.finetune);
	}

	track_info_ptr->score.arpeggio_cnt = count;
}



void	PLAYCMD_roll_vol_slide (PLAY_TRACK_INFO *track_info_ptr)
{
	int		count;
	int		cmd;
	int		vol;

	/* Roulement */
	count = track_info_ptr->score.roll.cnt;
	if (count == 0)
	{
		/* Reprend le sample depuis le debut */
		track_info_ptr->mix.spl.curpos_int = 0;
		track_info_ptr->mix.spl.curpos_frac = 0;
		track_info_ptr->mix.spl.direction = 0;
		track_info_ptr->mix.spl.cr.broken_curve_state = SPLH_BrokenCurveState_START;

		/* Changement de volume */
		cmd = (track_info_ptr->score.score.effect_par >> 4) & 0xF;
		vol = track_info_ptr->score.velocity_lin;

		/* 0, -4, -8, -16, -32, -64 */
		if (cmd <= 5)
		{
			vol -= (16 << cmd) & ~4;
		}

		/* x2/3 */
		else if (cmd == 6)
		{
			vol = (vol << 1) / 3;
		}

		/* x1/2 */
		else if (cmd == 7)
		{
			vol >>= 1;
		}

		/* 0, +4, +8, +16, +32, +64 */
		else if (cmd <= 13)
		{
			vol += (16 << (cmd & 0x7)) & ~4;
		}

		/* x3/2 */
		else if (cmd == 14)
		{
			vol = (vol * 3) >> 1;
		}

		/* x2 */
		else
		{
			vol <<= 1;
		}

		PLAY_set_lin_velocity (track_info_ptr, vol);
	}

	/* Tick suivant */
	count ++;
	if (count >= track_info_ptr->score.roll.speed)
	{
		count = 0;
	}
	track_info_ptr->score.roll.cnt = count;
}



void	PLAYCMD_change_sample_direction (PLAY_TRACK_INFO *track_info_ptr)
{
	int		mode;
	int		direction;
	int		loop_type;
	long		length;

	/* On est sur le bon tick ? */
	if ((track_info_ptr->score.score.effect_par & 0x0F) != PLAY_score_info.tick_counter)
	{
		return;
	}

	direction = track_info_ptr->mix.spl.direction;
	length = track_info_ptr->mix.spl.reppos + track_info_ptr->mix.spl.replen;
	loop_type = track_info_ptr->mix.spl.loopmode;

	/* Le sample est en mode non-ping-pong et est fini ? */
	if (   (   track_info_ptr->mix.spl.curpos_int >= length
	        || track_info_ptr->mix.spl.curpos_int < 0)
	    && loop_type != WaveForm_LOOP_TYPE_PP)
	{
		return;
	}

	/* Trouve la nouvelle direction */
	mode = track_info_ptr->score.score.effect_par >> 4;
	if (mode == 1)
	{
		direction = 0;
	}
	else if (mode == 2)
	{
		direction = 1;
	}
	else
	{
		direction = 1 - direction;
	}
	track_info_ptr->mix.spl.direction = direction;

	if (   track_info_ptr->mix.spl.curpos_frac == 0
	    && length > 0)
	{
		/* Le sample n'a pas encore commence et on va vers l'arriere, on le
		   passe a l'envers depuis la fin. */
		if (   track_info_ptr->mix.spl.curpos_int == 0
			 && direction == 1)
		{
			track_info_ptr->mix.spl.curpos_int = length - 1;
		}

		/* Inversement, si on est a la fin d'un sample en ping-pong loop, et
		   qu'on repart vers l'avant, on se positionne au debut du sample. */
		else if (   track_info_ptr->mix.spl.curpos_int == length
		         && direction == 0
		         && loop_type == WaveForm_LOOP_TYPE_PP)
		{
			track_info_ptr->mix.spl.curpos_int = 0;
		}
	}
}



void	PLAYCMD_roll (PLAY_TRACK_INFO *track_info_ptr)
{
	int		count;
	int		nbr;

	nbr = track_info_ptr->score.roll.nbr;
	if (nbr == 0)
	{
		return;
	}

	count = track_info_ptr->score.roll.cnt;
	if (count == 0)
	{
		track_info_ptr->mix.spl.curpos_int = 0;
		track_info_ptr->mix.spl.curpos_frac = 0;
		track_info_ptr->mix.spl.direction = 0;
		track_info_ptr->mix.spl.cr.broken_curve_state = SPLH_BrokenCurveState_START;
	}

	count ++;
	if (count >= track_info_ptr->score.roll.speed)
	{
		count = 0;
	}
	track_info_ptr->score.roll.cnt = count;

	if (nbr > 0)
	{
		track_info_ptr->score.roll.nbr = nbr - 1;
	}
}



void	PLAYCMD_roll_vol_slide_set_pan (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_roll_vol_slide (track_info_ptr);
}



void	PLAYCMD_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_up (track_info_ptr, track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_down (track_info_ptr, track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_log_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.speed;
	}
	track_info_ptr->score.vol_slide.speed = speed;
	PLAY_set_log_velocity (track_info_ptr, track_info_ptr->score.velocity_log + speed);
}



void	PLAYCMD_log_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	int		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.speed;
	}
	track_info_ptr->score.vol_slide.speed = speed;
	PLAY_set_log_velocity (track_info_ptr, track_info_ptr->score.velocity_log - speed);
}



void	PLAYCMD_lin_vol_slide_up_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_up (track_info_ptr, track_info_ptr->score.score.effect_par);
	PLAYCMD_do_tone_porta (track_info_ptr, 0);
}



void	PLAYCMD_lin_vol_slide_down_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_down (track_info_ptr, track_info_ptr->score.score.effect_par);
	PLAYCMD_do_tone_porta (track_info_ptr, 0);
}



void	PLAYCMD_log_vol_slide_up_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_log_vol_slide_up (track_info_ptr);
	PLAYCMD_do_tone_porta (track_info_ptr, 0);
}



void	PLAYCMD_log_vol_slide_down_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_log_vol_slide_down (track_info_ptr);
	PLAYCMD_do_tone_porta (track_info_ptr, 0);
}



void	PLAYCMD_lin_vol_slide_up_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_up (track_info_ptr, track_info_ptr->score.score.effect_par);
	PLAYCMD_do_vibrato (track_info_ptr, 0);
}



void	PLAYCMD_lin_vol_slide_down_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_lin_vol_slide_down (track_info_ptr, track_info_ptr->score.score.effect_par);
	PLAYCMD_do_vibrato (track_info_ptr, 0);
}



void	PLAYCMD_log_vol_slide_up_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_log_vol_slide_up (track_info_ptr);
	PLAYCMD_do_vibrato (track_info_ptr, 0);
}



void	PLAYCMD_log_vol_slide_down_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_log_vol_slide_down (track_info_ptr);
	PLAYCMD_do_vibrato (track_info_ptr, 0);
}



void	PLAYCMD_lin_master_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_lin_master_volume (  (LWORD) (  PLAY_track_info
														+ PLAY_track_info_list [GTK_TRACK_TYPE_AOU] [0])->score.track.volume_lin
										 + (LWORD) track_info_ptr->score.score.effect_par);
}

void	PLAYCMD_lin_master_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAY_set_lin_master_volume (  (LWORD) (  PLAY_track_info
														+ PLAY_track_info_list [GTK_TRACK_TYPE_AOU] [0])->score.track.volume_lin
										 - (LWORD) track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_extra_fine_tone_porta (PLAY_TRACK_INFO *track_info_ptr)
{
	PLAYCMD_do_tone_porta (track_info_ptr, track_info_ptr->score.score.effect_par);
}



void	PLAYCMD_extra_fine_porta_up (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.porta.speed;
	}
	track_info_ptr->score.porta.speed = speed;

	PLAY_set_period (track_info_ptr, track_info_ptr->score.period - speed);
}



void	PLAYCMD_extra_fine_porta_down (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.porta.speed;
	}
	track_info_ptr->score.porta.speed = speed;

	PLAY_set_period (track_info_ptr, track_info_ptr->score.period + speed);
}



void	PLAYCMD_left_balance_move (PLAY_TRACK_INFO *track_info_ptr)
{
	long		speed;

	speed = (long)track_info_ptr->score.score.effect_par << 8;
	PLAYCMD_do_pan_slide_left (track_info_ptr, speed);
}



void	PLAYCMD_right_balance_move (PLAY_TRACK_INFO *track_info_ptr)
{
	long		speed;

	speed = (long)track_info_ptr->score.score.effect_par << 8;
	PLAYCMD_do_pan_slide_right (track_info_ptr, speed);
}



void	PLAYCMD_tremor (PLAY_TRACK_INFO *track_info_ptr)
{
	int		count;

	count = track_info_ptr->score.tremor.cnt;

	/* Mettre le volume a 0 ? */
	if (count >= track_info_ptr->score.tremor.on)
	{
		track_info_ptr->score.velocity_loc = 0;
	}

	/* Tick suivant */
	count ++;
	if (count >= track_info_ptr->score.tremor.period)
	{
		count = 0;
	}
	track_info_ptr->score.tremor.cnt = count;
}



void	PLAYCMD_auto_tempo (PLAY_TRACK_INFO *track_info_ptr)
{
	double	val_2;
	double	val_1;

	if (   PLAY_score_info.tick_counter != 0
		 || track_info_ptr->score.score.effect_par == 0)
	{
		return;
	}

/*
			  60s * lignes * speed   frequence_spl   periode_ref
	tempo = -------------------- * ------------- * ------------
				4 lignes * 6 ticks    longueur_spl    periode_note
*/

	val_1 =   (double) (  (long)track_info_ptr->score.score.effect_par
	                    * PLAY_score_info.speed * 60)
			  * (  PLAY_convert_period_to_rel_freq (track_info_ptr->score.period)
	           * track_info_ptr->mix.spl.freq);

	if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_FWD)
	{
		val_2 =   (double)track_info_ptr->mix.spl.replen * (4 * 6);
	}
	else if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_PP)
	{
		val_2 =   (double)(track_info_ptr->mix.spl.replen << 1) * (4 * 6);
	}
	else
	{
		val_2 =   (double) (track_info_ptr->mix.spl.reppos + track_info_ptr->mix.spl.replen)
				  * (4 * 6);
	}

	if (val_2 <= 0)
	{
		return;
	}

	val_1 /= val_2;

	/* Si le tempo est trop rapide, on le divise par 2 */
	while (val_1 > PLAY_MAX_TEMPO)
	{
		val_1 /= 2;
	}

	PLAY_set_tempo (val_1);
}



void	PLAYCMD_auto_period (PLAY_TRACK_INFO *track_info_ptr)
{
	double	val_1;
	double	val_2;

	if (PLAY_score_info.tick_counter != 0
		 || track_info_ptr->score.score.effect_par == 0)
	{
		return;
	}

/*
						60s * lignes * speed   frequence_spl   periode_ref
	periode_note = -------------------- * ------------- * -----------
						 4 lignes * 6 ticks    longueur_spl       tempo
*/

	if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_FWD)
	{
		val_1 = track_info_ptr->mix.spl.replen;
	}
	else if (track_info_ptr->mix.spl.loopmode == WaveForm_LOOP_TYPE_PP)
	{
		val_1 = track_info_ptr->mix.spl.replen << 1;
	}
	else
	{
		val_1 = track_info_ptr->mix.spl.reppos + track_info_ptr->mix.spl.replen;
	}

	if (val_1 <= 0)
	{
		return;
	}

	val_2 =   (  PLAY_score_info.tempo_int
	           + PLAY_score_info.tempo_frac * (1.0/4294967296.0))
	        * (4 * 6)
			  * val_1
	        / (  ((long)PLAY_score_info.speed * track_info_ptr->score.score.effect_par * 60)
	           * (double) track_info_ptr->mix.spl.freq);

	val_1 = PLAY_convert_rel_freq_to_period (val_2);
	val_1 = MIN (val_1, PLAY_MAX_PERIOD);
	val_1 = MAX (val_1, PLAY_MIN_PERIOD);
	track_info_ptr->score.period = (float) val_1;
	track_info_ptr->score.period_loc = (float) val_1;
}



void	PLAYCMD_lin_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par << 4;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.lin_vol_speed;
	}
	track_info_ptr->score.track.lin_vol_speed = speed;
	PLAY_set_lin_volume (track_info_ptr, track_info_ptr->score.track.volume_lin + speed);
}



void	PLAYCMD_lin_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par << 4;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.lin_vol_speed;
	}
	track_info_ptr->score.track.lin_vol_speed = speed;
	PLAY_set_lin_volume (track_info_ptr, track_info_ptr->score.track.volume_lin - speed);
}



void	PLAYCMD_log_track_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.log_vol_speed;
	}
	track_info_ptr->score.track.log_vol_speed = speed;
	PLAY_set_log_volume (track_info_ptr, track_info_ptr->score.track.volume_log + speed);
}



void	PLAYCMD_log_track_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	LWORD		speed;

	speed = track_info_ptr->score.score.effect_par;
	if (speed == 0)
	{
		speed = track_info_ptr->score.track.log_vol_speed;
	}
	track_info_ptr->score.track.log_vol_speed = speed;
	PLAY_set_log_volume (track_info_ptr, track_info_ptr->score.track.volume_log - speed);
}



/****************************************************************************/
/*                                                                          */
/*      EFFETS DE LA COLONNE DE VOLUME, PREMIER TICK DE LA LIGNE            */
/*                                                                          */
/****************************************************************************/



void	PLAYCMD_volfx_fine_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_lin_vol_slide_down (track_info_ptr, param << 2);
}



void	PLAYCMD_volfx_fine_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_lin_vol_slide_up (track_info_ptr, param << 2);
}



void	PLAYCMD_volfx_set_panning (PLAY_TRACK_INFO *track_info_ptr)
{
	long		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAY_set_panning (track_info_ptr, false, param << 12);
}



/****************************************************************************/
/*                                                                          */
/*      EFFETS DE LA COLONNE DE VOLUME, TOUS LES TICKS                      */
/*                                                                          */
/****************************************************************************/



void	PLAYCMD_volfx_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_lin_vol_slide_down (track_info_ptr, param << 2);
}



void	PLAYCMD_volfx_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_lin_vol_slide_up (track_info_ptr, param << 2);
}



void	PLAYCMD_volfx_set_vibrato_speed (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_vibrato (track_info_ptr, param << 4);
}



void	PLAYCMD_volfx_vibrato (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_vibrato (track_info_ptr, param);
}



void	PLAYCMD_volfx_pan_slide_left (PLAY_TRACK_INFO *track_info_ptr)
{
	long		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_pan_slide_left (track_info_ptr, param << 12);
}



void	PLAYCMD_volfx_pan_slide_right (PLAY_TRACK_INFO *track_info_ptr)
{
	long		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_pan_slide_right (track_info_ptr, param << 12);
}



void	PLAYCMD_volfx_tone_portamento (PLAY_TRACK_INFO *track_info_ptr)
{
	int		param;

	param = track_info_ptr->score.score.volume & 0x0F;
	PLAYCMD_do_tone_porta (track_info_ptr, param << 4);
}



/****************************************************************************/
/*                                                                          */
/*      FONCTIONS COMMUNES A PLUSIEURS EFFETS                               */
/*                                                                          */
/****************************************************************************/



void	PLAYCMD_do_sample_offset (PLAY_TRACK_INFO *track_info_ptr, LWORD pos_int, ULWORD pos_frac)
{
	if (pos_int == 0 && pos_frac == 0)
	{
		pos_int = track_info_ptr->score.offset.pos_int;
		pos_frac = track_info_ptr->score.offset.pos_frac;
	}
	track_info_ptr->score.offset.pos_int = pos_int;
	track_info_ptr->score.offset.pos_frac = pos_frac;

	/* Verifie qu'on est bien dans la bonne zone */
	pos_int = MIN (pos_int,   track_info_ptr->mix.spl.reppos
	                        + track_info_ptr->mix.spl.replen);
	pos_int = MAX (pos_int, 0);

	/* Met a jour les positions */
	track_info_ptr->mix.spl.curpos_int = pos_int;
	track_info_ptr->mix.spl.curpos_frac = pos_frac;

	track_info_ptr->mix.spl.cr.broken_curve_state = SPLH_BrokenCurveState_MID;
}



void	PLAYCMD_do_tone_porta (PLAY_TRACK_INFO *track_info_ptr, int speed)
{
	float		new_period;

	/* Vitesse du Tone Portamento */
	if (speed == 0)
	{
		speed = track_info_ptr->score.porta.speed;
	}
	track_info_ptr->score.porta.speed = speed;

	/* Reglage de la nouvelle periode */
	new_period = track_info_ptr->score.period;
	if (track_info_ptr->score.porta.period < new_period)
	{
		new_period -= speed;
		new_period = MAX (new_period, track_info_ptr->score.porta.period);
	}
	else if (track_info_ptr->score.porta.period > new_period)
	{
		new_period += speed;
		new_period = MIN (new_period, track_info_ptr->score.porta.period);
	}

	/* Validation de la periode */
	PLAY_set_period (track_info_ptr, new_period);
}



void	PLAYCMD_do_vibrato (PLAY_TRACK_INFO *track_info_ptr, int param)
{
	float		new_period;
	int		speed;
	int		amplitude;

	/* Vitesse du Vibrato */
	speed = (param & 0xF0) >> 2;
	if (speed == 0)
	{
		speed = track_info_ptr->score.vibrato.speed;
	}
	track_info_ptr->score.vibrato.speed = speed;

	/* Amplitude du Vibrato */
	amplitude = param & 0xF;
	if (amplitude == 0)
	{
		amplitude = track_info_ptr->score.vibrato.amp;
	}
	track_info_ptr->score.vibrato.amp = amplitude;

	/* Reglage de la nouvelle periode */
	new_period =   track_info_ptr->score.period
					 + ((  PLAY_sin_table [track_info_ptr->score.vibrato.waveform]
												 [(track_info_ptr->score.vibrato.cnt >> 2) & 0x3F]
						  * amplitude) / 8.0f);

	/* Validation de la periode locale */
	new_period = MIN (new_period, PLAY_MAX_PERIOD);
	new_period = MAX (new_period, PLAY_MIN_PERIOD);
	track_info_ptr->score.period_loc = new_period;

	/* Compteur suivant */
	track_info_ptr->score.vibrato.cnt += speed;
}



void	PLAYCMD_do_lin_vol_slide_up (PLAY_TRACK_INFO *track_info_ptr, int speed)
{
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.speed;
	}
	track_info_ptr->score.vol_slide.speed = speed;
	PLAY_set_lin_velocity (track_info_ptr, track_info_ptr->score.velocity_lin + speed * 8);
}



void	PLAYCMD_do_lin_vol_slide_down (PLAY_TRACK_INFO *track_info_ptr, int speed)
{
	if (speed == 0)
	{
		speed = track_info_ptr->score.vol_slide.speed;
	}
	track_info_ptr->score.vol_slide.speed = speed;
	PLAY_set_lin_velocity (track_info_ptr, track_info_ptr->score.velocity_lin - speed * 8);
}


void	PLAYCMD_do_pan_slide_left (PLAY_TRACK_INFO *track_info_ptr, long speed)
{
	if (speed == 0)
	{
		speed = track_info_ptr->score.pan_slide.speed;
	}
	track_info_ptr->score.pan_slide.speed = (UWORD) speed;

	PLAY_set_panning (track_info_ptr, false, (long)track_info_ptr->score.track.panning - speed);
}



void	PLAYCMD_do_pan_slide_right (PLAY_TRACK_INFO *track_info_ptr, long speed)
{
	if (speed == 0)
	{
		speed = track_info_ptr->score.pan_slide.speed;
	}
	track_info_ptr->score.pan_slide.speed = (UWORD) speed;

	PLAY_set_panning (track_info_ptr, false, (long)track_info_ptr->score.track.panning + speed);
}



void	PLAYCMD_do_set_mix_preset (PLAY_TRACK_INFO *track_info_ptr, int preset, int flags)
{
	int		dest_track_type;
	int		dest_track_nbr;

	if (preset <= 0 || preset > MIXP_NBRMIXP_MAXI)
	{
		return;
	}

	/* Sur une piste d'effet, on applique le preset a la
	   piste qui a envoye la commande. */
	if (track_info_ptr->track_type == Pattern_TYPE_FX)
	{
		dest_track_type = track_info_ptr->track_type;
		dest_track_nbr = track_info_ptr->track;
	}

	/* Sinon on utilise la piste destination par defaut du preset. */
	else
	{
		dest_track_type = MIXP_get_track_type (preset);
		dest_track_nbr = MIXP_get_track_number (preset);
	}

	/* On ne verifie pas si l'action a reussi ou pas,
	   de toute facon on s'en fout. */
	PLAY_load_mix_preset (dest_track_type, dest_track_nbr,
	                      preset, flags);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
