/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PLAYFX_CURRENT_HEADER)
	#error Inclusion recursive du header PLAYFX.
#endif
#define	PLAYFX_CURRENT_HEADER

#if ! defined (PLAYFX_HEADER_INCLUDED)
#define	PLAYFX_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"FxPreset.h"
#include	"player.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types des parametres des commandes */
#define	PLAYFX_TIME_PARAMETER		0x010000L	/* Indique un effet agissant sur un parametre temporel */
#define	PLAYFX_FREQ_PARAMETER		0x020000L	/* Indique un effet agissant sur un parametre frequentiel */
#define	PLAYFX_DOUBLE_PARAMETER_2D	0x040000L	/* Effet a parametre general en virgule flottante, 2 decimale */
#define	PLAYFX_DOUBLE_PARAMETER_3D	0x080000L	/* Effet a parametre general en virgule flottante, 3 decimales */
#define	PLAYFX_INT_PARAMETER			0x100000L	/* Effet a parametre general entier */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	PLAYFX_init (void);
void	PLAYFX_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines generales                                                  */
/*--------------------------------------------------------------------------*/

void	PLAYFX_fx_set_preset (PLAY_TRACK_INFO *track_info_ptr, const FxPreset_EFFECT_CONF &conf, int effect_type, long auto_val = 0);
void	PLAYFX_fx_get_preset (PLAY_TRACK_INFO *track_info_ptr, FxPreset_EFFECT_CONF &conf, int &effect_type);
void	PLAYFX_fx_set_default_parameters (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_fx_init (PLAY_TRACK_INFO *track_info_ptr);
int	PLAYFX_fx_set_stereo (PLAY_TRACK_INFO *track_info_ptr, int stereo);
signed int	PLAYFX_fx_silence (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_fx_update (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYFX_fx_restore (PLAY_TRACK_INFO *track_info_ptr);

void	PLAYFX_manage_1st_tick (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYFX_manage_all_ticks (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Delay                                                               */
/*--------------------------------------------------------------------------*/

void	PLAYFX_delay_set_default_parameters (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_delay_init (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_delay_set_stereo (PLAY_TRACK_INFO *track_info_ptr, int stereo);
signed int	PLAYFX_delay_silence (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_delay_update (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYFX_delay_restore (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Filtre resonnant                                                    */
/*--------------------------------------------------------------------------*/

void	PLAYFX_resfilt_set_default_parameters (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_resfilt_init (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_resfilt_set_stereo (PLAY_TRACK_INFO *track_info_ptr, int stereo);
signed int	PLAYFX_resfilt_silence (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_resfilt_update (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYFX_resfilt_restore (PLAY_TRACK_INFO *track_info_ptr);

/*--------------------------------------------------------------------------*/
/*      Distorsion                                                          */
/*--------------------------------------------------------------------------*/

void	PLAYFX_disto_set_default_parameters (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_disto_init (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_disto_set_stereo (PLAY_TRACK_INFO *track_info_ptr, int stereo);
signed int	PLAYFX_disto_silence (PLAY_TRACK_INFO *track_info_ptr);
signed int	PLAYFX_disto_update (PLAY_TRACK_INFO *track_info_ptr);
void	PLAYFX_disto_restore (PLAY_TRACK_INFO *track_info_ptr);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern UBYTE	(*PLAYFX_command_format_ptr) [0x100];



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PLAYFX_CURRENT_HEADER
