/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SAMP_CURRENT_HEADER)
	#error Inclusion recursive du header SAMP.
#endif
#define	SAMP_CURRENT_HEADER

#if ! defined (SAMP_HEADER_INCLUDED)
#define	SAMP_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"Sample.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	SAMP_NBRSAMPLES_MAXI			255		/* 1-255 */

/* Nombre de buffers reserves aux acces aux samples */
#define	SAMP_NBR_ACCESS_BUFFERS	4



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	SAMP_init (void);
void	SAMP_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de base                                                    */
/*--------------------------------------------------------------------------*/

void	SAMP_get_sample_name (int sample, char *name_0);
void	SAMP_set_sample_name (int sample, const char *name_0);
int	SAMP_get_sample_resolution (int sample);
void	SAMP_set_sample_resolution (int sample, int nbits);
int SAMP_get_sample_stereo (int sample);
void	SAMP_set_sample_stereo (int sample, int tracks);
int	SAMP_get_sample_bytes_per_sample (int sample);
signed int SAMP_get_sample_balance (int sample);
void	SAMP_set_sample_balance (int sample, signed int balance);
int SAMP_get_sample_midi_note (int sample);
void	SAMP_set_sample_midi_note (int sample, int note);
int SAMP_get_sample_volume (int sample);
void	SAMP_set_sample_volume (int sample, int volume);
signed int SAMP_get_sample_finetune (int sample);
void	SAMP_set_sample_finetune (int sample, signed int finetune);
long SAMP_get_sample_freq (int sample);
void	SAMP_set_sample_freq (int sample, long freq);
long	SAMP_get_sample_length (int sample);
signed int	SAMP_set_sample_length (int sample, long length);
long	SAMP_get_sample_repeat (int sample);
long	SAMP_get_sample_replen (int sample);
long	SAMP_get_sample_loop (int sample);
void	SAMP_set_sample_loop (int sample, int loop_type, long reppos, long replen);
long	SAMP_get_sample_loopbuf (int sample);
signed int	SAMP_set_sample_loopbuf (int sample, long loopbuf);
void	*SAMP_get_sample_loopbuf_adr (int sample);
void	*SAMP_get_sample_data_adr (int sample);
int	SAMP_get_sample_type (int sample);

FILE	*SAMP_get_sample_file_ptr (int sample);
void	SAMP_set_sample_file_ptr (int sample, FILE *file_ptr);
long	SAMP_get_sample_buffer_len (int sample, int buffer);
signed int	SAMP_set_sample_d2d_buffers (int sample, long sbuffer_len, long buffer1_len, long buffer2_len);
void	*SAMP_get_sample_startbuf_ptr (int sample);
long	SAMP_get_sample_file_data_offset (int sample);
void	SAMP_set_sample_file_data_offset (int sample, long pos);
bool	SAMP_get_read_d2d_header_flag (int sample);
void	SAMP_set_read_d2d_header_flag (int sample, bool flag);
const char	*SAMP_get_sample_d2d_filename (int sample);
signed int	SAMP_set_sample_d2d_filename (int sample, const char *filename_0);
signed int	SAMP_use_file_for_d2d (int sample, const char *filename_0);
signed int	SAMP_read_d2d_header (int sample);
signed int	SAMP_update_d2d_header (int sample);

signed int	SAMP_make_buffers (int sample);

BYTE	*SAMP_get_access_buffer_ptr (int samples, long position, long length, int buffer_id, bool write_flag, bool peak_file_flag = false);
signed int	SAMP_release_access_buffer (int buffer_id);
signed int	SAMP_flush_access_buffers (void);

signed int	SAMP_kill_sample (int sample);
signed int	SAMP_clear_samples (void);

void	SAMP_get_sample_view (int sample, Sample_VIEW &view);
void	SAMP_set_sample_view (int sample, const Sample_VIEW &view);
void	SAMP_get_sample_selection (int sample, Sample_SELECTION &selection);
void	SAMP_set_sample_selection (int sample, const Sample_SELECTION &selection);

/*--------------------------------------------------------------------------*/
/*      Conversions                                                         */
/*--------------------------------------------------------------------------*/

signed int	SAMP_convert_sample_8_2_16 (int sample);
signed int	SAMP_convert_sample_16_2_8 (int sample);
signed int	SAMP_convert_sample_mono_2_stereo (int sample);
signed int	SAMP_convert_sample_stereo_2_mono (int sample);

signed int	SAMP_check_all_samples (void);

/*--------------------------------------------------------------------------*/
/*      Routines avec utilisation de l'interface                            */
/*--------------------------------------------------------------------------*/

void	SAMP_set_sample_volume_intr (int type, signed int value);
void	SAMP_set_sample_length_intr (int type, signed long value);
void	SAMP_set_sample_repeat_intr (int type, signed long value, bool wait_flag);
void	SAMP_set_sample_replen_intr (int type, signed long value, bool wait_flag);
void	SAMP_set_sample_loopbuf_intr (int type, signed long value);
void	SAMP_set_sample_midi_note_intr (int type, signed int value);
void	SAMP_set_sample_finetune_intr (int type, signed int value);
void	SAMP_set_sample_d2d_buffers_intr (int buffer_num, int type, signed long value);
void	SAMP_set_file_data_offset_intr (int type, signed long value, bool wait_flag);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SAMP_CURRENT_HEADER
