/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SONG_CURRENT_HEADER)
	#error Inclusion recursive du header SONG.
#endif
#define	SONG_CURRENT_HEADER

#if ! defined (SONG_HEADER_INCLUDED)
#define	SONG_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"String.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	SONG_MAX_SONG_LENGTH			999	/* Songlen maximum (pos = 0 a x-1) */
#define	SONG_NAME_LEN					32		/* Longueur du nom du module */
#define	SONG_SMALLCOM_LEN				160	/* Longueur du commentaire du header */
#define	SONG_TRACKER_NAME_LEN		24		/* Longueur du nom du tracker de composition */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	SONG_init (void);
void	SONG_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de base                                                    */
/*--------------------------------------------------------------------------*/

int	SONG_get_pattern_number (int songpos);
void	SONG_set_pattern_number (int songpos, int pattern);
int	SONG_get_song_length (void);
void	SONG_set_song_length (int length);
int	SONG_get_song_repeat (void);
void	SONG_set_song_repeat (int repeat);
void	SONG_get_song_name (char *name_0);
void	SONG_set_song_name (const char *name_0);
void	SONG_get_small_comment (char *text_0);
void	SONG_set_small_comment (const char *text_0);
String	SONG_get_extra_comment (void);
void	SONG_set_extra_comment (const String &xcom);
void	SONG_get_tracker_name (char *name_0);
void	SONG_set_tracker_name (const char *name_0);
void	SONG_reset_date (void);
signed int	SONG_clear_song (void);
signed int	SONG_insert_pos (int position);
signed int	SONG_delete_pos (int position);

/*--------------------------------------------------------------------------*/
/*      Modifications avec l'interface                                      */
/*--------------------------------------------------------------------------*/

void	SONG_set_pattern_number_intr (int type, signed int value);
void	SONG_set_song_length_intr (int type, signed int value);
void	SONG_set_song_repeat_intr (int type, signed int value);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SONG_CURRENT_HEADER
